/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils.taskexecutor;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkManagerTaskExecutor
implements TaskExecutor {
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final Executor mMainThreadExecutor = new Executor(){

        @Override
        public void execute(@NonNull Runnable command) {
            WorkManagerTaskExecutor.this.postToMainThread(command);
        }
    };
    volatile Thread mCurrentBackgroundExecutorThread;
    private final ThreadFactory mBackgroundThreadFactory = new ThreadFactory(){
        private int mThreadsCreated = 0;

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("WorkManager-WorkManagerTaskExecutor-thread-" + this.mThreadsCreated);
            ++this.mThreadsCreated;
            WorkManagerTaskExecutor.this.mCurrentBackgroundExecutorThread = thread;
            return thread;
        }
    };
    private final ExecutorService mBackgroundExecutor = Executors.newSingleThreadExecutor(this.mBackgroundThreadFactory);

    @Override
    public void postToMainThread(Runnable r) {
        this.mMainThreadHandler.post(r);
    }

    @Override
    public Executor getMainThreadExecutor() {
        return this.mMainThreadExecutor;
    }

    @Override
    public void executeOnBackgroundThread(Runnable r) {
        this.mBackgroundExecutor.execute(r);
    }

    @Override
    public Executor getBackgroundExecutor() {
        return this.mBackgroundExecutor;
    }

    @Override
    @NonNull
    public Thread getBackgroundExecutorThread() {
        return this.mCurrentBackgroundExecutorThread;
    }
}

