/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.core.view.ViewGroupKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0086\n\u001a0\u0010\r\u001a\u00020\u000e*\u00020\u00032!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u000e0\u0010H\u0086\b\u001aE\u0010\u0013\u001a\u00020\u000e*\u00020\u000326\u0010\u000f\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u000e0\u0014H\u0086\b\u001a\u0015\u0010\u0016\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0007H\u0086\u0002\u001a\r\u0010\u0017\u001a\u00020\u000b*\u00020\u0003H\u0086\b\u001a\r\u0010\u0018\u001a\u00020\u000b*\u00020\u0003H\u0086\b\u001a\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a*\u00020\u0003H\u0086\u0002\u001a\u0015\u0010\u001b\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0086\n\u001a\u0015\u0010\u001c\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0086\n\u001a\u0017\u0010\u001d\u001a\u00020\u000e*\u00020\u001e2\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0086\b\u001a5\u0010\u001f\u001a\u00020\u000e*\u00020\u001e2\b\b\u0003\u0010 \u001a\u00020\u00072\b\b\u0003\u0010!\u001a\u00020\u00072\b\b\u0003\u0010\"\u001a\u00020\u00072\b\b\u0003\u0010#\u001a\u00020\u0007H\u0086\b\u001a5\u0010$\u001a\u00020\u000e*\u00020\u001e2\b\b\u0003\u0010%\u001a\u00020\u00072\b\b\u0003\u0010!\u001a\u00020\u00072\b\b\u0003\u0010&\u001a\u00020\u00072\b\b\u0003\u0010#\u001a\u00020\u0007H\u0087\b\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"children", "Lkotlin/sequences/Sequence;", "Landroid/view/View;", "Landroid/view/ViewGroup;", "getChildren", "(Landroid/view/ViewGroup;)Lkotlin/sequences/Sequence;", "size", "", "getSize", "(Landroid/view/ViewGroup;)I", "contains", "", "view", "forEach", "", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "forEachIndexed", "Lkotlin/Function2;", "index", "get", "isEmpty", "isNotEmpty", "iterator", "", "minusAssign", "plusAssign", "setMargins", "Landroid/view/ViewGroup$MarginLayoutParams;", "updateMargins", "left", "top", "right", "bottom", "updateMarginsRelative", "start", "end", "core-ktx_release"})
public final class ViewGroupKt {
    @NotNull
    public static final View get(@NotNull ViewGroup $this$get, int index) {
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        View view = $this$get.getChildAt(index);
        if (view == null) {
            throw (Throwable)new IndexOutOfBoundsException("Index: " + index + ", Size: " + $this$get.getChildCount());
        }
        return view;
    }

    public static final boolean contains(@NotNull ViewGroup $this$contains, @NotNull View view) {
        int $i$f$contains = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$contains, (String)"$this$contains");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return $this$contains.indexOfChild(view) != -1;
    }

    public static final void plusAssign(@NotNull ViewGroup $this$plusAssign, @NotNull View view) {
        int $i$f$plusAssign = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$plusAssign, (String)"$this$plusAssign");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        $this$plusAssign.addView(view);
    }

    public static final void minusAssign(@NotNull ViewGroup $this$minusAssign, @NotNull View view) {
        int $i$f$minusAssign = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$minusAssign, (String)"$this$minusAssign");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        $this$minusAssign.removeView(view);
    }

    public static final int getSize(@NotNull ViewGroup $this$size) {
        int $i$f$getSize = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$size, (String)"$this$size");
        return $this$size.getChildCount();
    }

    public static final boolean isEmpty(@NotNull ViewGroup $this$isEmpty) {
        int $i$f$isEmpty = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$isEmpty, (String)"$this$isEmpty");
        return $this$isEmpty.getChildCount() == 0;
    }

    public static final boolean isNotEmpty(@NotNull ViewGroup $this$isNotEmpty) {
        int $i$f$isNotEmpty = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$isNotEmpty, (String)"$this$isNotEmpty");
        return $this$isNotEmpty.getChildCount() != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final void forEach(@NotNull ViewGroup $this$forEach, @NotNull Function1<? super View, Unit> action) {
        int $i$f$forEach = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$forEach, (String)"$this$forEach");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        int n = 0;
        int n2 = $this$forEach.getChildCount();
        while (n < n2) {
            void index;
            View view = $this$forEach.getChildAt((int)index);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getChildAt(index)");
            action.invoke((Object)view);
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void forEachIndexed(@NotNull ViewGroup $this$forEachIndexed, @NotNull Function2<? super Integer, ? super View, Unit> action) {
        int $i$f$forEachIndexed = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$forEachIndexed, (String)"$this$forEachIndexed");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        int n = 0;
        int n2 = $this$forEachIndexed.getChildCount();
        while (n < n2) {
            void index;
            Integer n3 = (int)index;
            View view = $this$forEachIndexed.getChildAt((int)index);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getChildAt(index)");
            action.invoke((Object)n3, (Object)view);
            ++index;
        }
    }

    @NotNull
    public static final Iterator<View> iterator(@NotNull ViewGroup $this$iterator) {
        Intrinsics.checkParameterIsNotNull((Object)$this$iterator, (String)"$this$iterator");
        return new Iterator<View>($this$iterator){
            private int index;
            final /* synthetic */ ViewGroup $this_iterator;

            public boolean hasNext() {
                return this.index < this.$this_iterator.getChildCount();
            }

            @NotNull
            public View next() {
                int n = this.index;
                this.index = n + 1;
                View view = this.$this_iterator.getChildAt(n);
                if (view == null) {
                    throw (Throwable)new IndexOutOfBoundsException();
                }
                return view;
            }

            public void remove() {
                iterator.1 v0 = this;
                v0.index += -1;
                this.$this_iterator.removeViewAt(v0.index);
            }
            {
                this.$this_iterator = $receiver;
            }
        };
    }

    @NotNull
    public static final Sequence<View> getChildren(@NotNull ViewGroup $this$children) {
        Intrinsics.checkParameterIsNotNull((Object)$this$children, (String)"$this$children");
        return (Sequence)new Sequence<View>($this$children){
            final /* synthetic */ ViewGroup $this_children;

            @NotNull
            public Iterator<View> iterator() {
                return ViewGroupKt.iterator(this.$this_children);
            }
            {
                this.$this_children = $receiver;
            }
        };
    }

    public static final void setMargins(@NotNull ViewGroup.MarginLayoutParams $this$setMargins, @Px int size) {
        int $i$f$setMargins = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$setMargins, (String)"$this$setMargins");
        $this$setMargins.setMargins(size, size, size, size);
    }

    public static final void updateMargins(@NotNull ViewGroup.MarginLayoutParams $this$updateMargins, @Px int left, @Px int top, @Px int right, @Px int bottom) {
        int $i$f$updateMargins = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$updateMargins, (String)"$this$updateMargins");
        $this$updateMargins.setMargins(left, top, right, bottom);
    }

    public static /* synthetic */ void updateMargins$default(ViewGroup.MarginLayoutParams $this$updateMargins, int left, int top, int right, int bottom, int n, Object object) {
        if ((n & 1) != 0) {
            left = $this$updateMargins.leftMargin;
        }
        if ((n & 2) != 0) {
            top = $this$updateMargins.topMargin;
        }
        if ((n & 4) != 0) {
            right = $this$updateMargins.rightMargin;
        }
        if ((n & 8) != 0) {
            bottom = $this$updateMargins.bottomMargin;
        }
        boolean $i$f$updateMargins = false;
        Intrinsics.checkParameterIsNotNull((Object)$this$updateMargins, (String)"$this$updateMargins");
        $this$updateMargins.setMargins(left, top, right, bottom);
    }

    @RequiresApi(value=17)
    public static final void updateMarginsRelative(@NotNull ViewGroup.MarginLayoutParams $this$updateMarginsRelative, @Px int start, @Px int top, @Px int end, @Px int bottom) {
        int $i$f$updateMarginsRelative = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$updateMarginsRelative, (String)"$this$updateMarginsRelative");
        $this$updateMarginsRelative.setMarginStart(start);
        $this$updateMarginsRelative.topMargin = top;
        $this$updateMarginsRelative.setMarginEnd(end);
        $this$updateMarginsRelative.bottomMargin = bottom;
    }

    @RequiresApi(value=17)
    public static /* synthetic */ void updateMarginsRelative$default(ViewGroup.MarginLayoutParams $this$updateMarginsRelative, int start, int top, int end, int bottom, int n, Object object) {
        if ((n & 1) != 0) {
            start = $this$updateMarginsRelative.getMarginStart();
        }
        if ((n & 2) != 0) {
            top = $this$updateMarginsRelative.topMargin;
        }
        if ((n & 4) != 0) {
            end = $this$updateMarginsRelative.getMarginEnd();
        }
        if ((n & 8) != 0) {
            bottom = $this$updateMarginsRelative.bottomMargin;
        }
        boolean $i$f$updateMarginsRelative = false;
        Intrinsics.checkParameterIsNotNull((Object)$this$updateMarginsRelative, (String)"$this$updateMarginsRelative");
        $this$updateMarginsRelative.setMarginStart(start);
        $this$updateMarginsRelative.topMargin = top;
        $this$updateMarginsRelative.setMarginEnd(end);
        $this$updateMarginsRelative.bottomMargin = bottom;
    }
}

