/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.Point;
import android.graphics.PointF;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a#\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0086\b\u001a7\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a)\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0086\b\u00f8\u0001\u0000\u001a\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\n\u001a\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0014H\u0086\n\u001a\u001d\u0010\u0015\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\n\u001a'\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0086\b\u001a'\u0010\u001a\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\b\b\u0001\u0010\u001b\u001a\u00020\u0003H\u0086\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"createBitmap", "Landroid/graphics/Bitmap;", "width", "", "height", "config", "Landroid/graphics/Bitmap$Config;", "hasAlpha", "", "colorSpace", "Landroid/graphics/ColorSpace;", "applyCanvas", "block", "Lkotlin/Function1;", "Landroid/graphics/Canvas;", "", "Lkotlin/ExtensionFunctionType;", "contains", "p", "Landroid/graphics/Point;", "Landroid/graphics/PointF;", "get", "x", "y", "scale", "filter", "set", "color", "core-ktx_release"})
public final class BitmapKt {
    @NotNull
    public static final Bitmap applyCanvas(@NotNull Bitmap $this$applyCanvas, @NotNull Function1<? super Canvas, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$applyCanvas, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$applyCanvas = false;
        Canvas c = new Canvas($this$applyCanvas);
        block.invoke((Object)c);
        return $this$applyCanvas;
    }

    public static final int get(@NotNull Bitmap $this$get, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        boolean $i$f$get = false;
        return $this$get.getPixel(x, y);
    }

    public static final void set(@NotNull Bitmap $this$set, int x, int y, @ColorInt int color) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        boolean $i$f$set = false;
        $this$set.setPixel(x, y, color);
    }

    @NotNull
    public static final Bitmap scale(@NotNull Bitmap $this$scale, int width, int height, boolean filter) {
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        boolean $i$f$scale = false;
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)$this$scale, (int)width, (int)height, (boolean)filter);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createScaledBitmap(this, width, height, filter)");
        return bitmap;
    }

    public static /* synthetic */ Bitmap scale$default(Bitmap $this$scale_u24default, int width, int height, boolean filter, int n, Object object) {
        if ((n & 4) != 0) {
            filter = true;
        }
        Intrinsics.checkNotNullParameter((Object)$this$scale_u24default, (String)"<this>");
        boolean $i$f$scale = false;
        object = Bitmap.createScaledBitmap((Bitmap)$this$scale_u24default, (int)width, (int)height, (boolean)filter);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createScaledBitmap(this, width, height, filter)");
        return object;
    }

    @NotNull
    public static final Bitmap createBitmap(int width, int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean $i$f$createBitmap = false;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, height, config)");
        return bitmap;
    }

    public static /* synthetic */ Bitmap createBitmap$default(int width, int height, Bitmap.Config config, int n, Object object) {
        if ((n & 4) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean $i$f$createBitmap = false;
        object = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createBitmap(width, height, config)");
        return object;
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap createBitmap(int width, int height, @NotNull Bitmap.Config config, boolean hasAlpha, @NotNull ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        boolean $i$f$createBitmap = false;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config, (boolean)hasAlpha, (ColorSpace)colorSpace);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, heig\u2026ig, hasAlpha, colorSpace)");
        return bitmap;
    }

    public static /* synthetic */ Bitmap createBitmap$default(int width, int height, Bitmap.Config config, boolean hasAlpha, ColorSpace colorSpace, int n, Object object) {
        if ((n & 4) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        if ((n & 8) != 0) {
            hasAlpha = true;
        }
        if ((n & 0x10) != 0) {
            ColorSpace colorSpace2 = ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace2, (String)"get(ColorSpace.Named.SRGB)");
            colorSpace = colorSpace2;
        }
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        boolean $i$f$createBitmap = false;
        object = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config, (boolean)hasAlpha, (ColorSpace)colorSpace);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createBitmap(width, heig\u2026ig, hasAlpha, colorSpace)");
        return object;
    }

    public static final boolean contains(@NotNull Bitmap $this$contains, @NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        boolean $i$f$contains = false;
        return p.x >= 0 && p.x < $this$contains.getWidth() && p.y >= 0 && p.y < $this$contains.getHeight();
    }

    public static final boolean contains(@NotNull Bitmap $this$contains, @NotNull PointF p) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        boolean $i$f$contains = false;
        return p.x >= 0.0f && p.x < (float)$this$contains.getWidth() && p.y >= 0.0f && p.y < (float)$this$contains.getHeight();
    }
}

