/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jsp.compilers;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.jsp.compilers.JasperC;
import org.apache.tools.ant.taskdefs.optional.jsp.compilers.JspCompilerAdapter;

public class JspCompilerAdapterFactory {
    private JspCompilerAdapterFactory() {
    }

    public static JspCompilerAdapter getCompiler(String compilerType, Task task) throws BuildException {
        return JspCompilerAdapterFactory.getCompiler(compilerType, task, new AntClassLoader(task.getProject(), null));
    }

    public static JspCompilerAdapter getCompiler(String compilerType, Task task, AntClassLoader loader) throws BuildException {
        if (compilerType.equalsIgnoreCase("jasper")) {
            return new JasperC();
        }
        return JspCompilerAdapterFactory.resolveClassName(compilerType, loader);
    }

    private static JspCompilerAdapter resolveClassName(String className, AntClassLoader classloader) throws BuildException {
        try {
            Class c = classloader.findClass(className);
            Object o = c.newInstance();
            return (JspCompilerAdapter)o;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException(className + " can't be found.", (Throwable)cnfe);
        }
        catch (ClassCastException cce) {
            throw new BuildException(className + " isn't the classname of " + "a compiler adapter.", (Throwable)cce);
        }
        catch (Throwable t) {
            throw new BuildException(className + " caused an interesting " + "exception.", t);
        }
    }
}

