/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;

public class TagUtils {
    private static final TagUtils instance = new TagUtils();
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$struts$taglib$TagUtils == null ? (class$org$apache$struts$taglib$TagUtils = TagUtils.class$("org.apache.struts.taglib.TagUtils")) : class$org$apache$struts$taglib$TagUtils));
    private static final MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.LocalStrings");
    private static Method encode = null;
    private static final Map scopes = new HashMap();
    static /* synthetic */ Class class$org$apache$struts$taglib$TagUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URLEncoder;

    protected TagUtils() {
    }

    public static TagUtils getInstance() {
        return instance;
    }

    public Map computeParameters(PageContext pageContext, String paramId, String paramName, String paramProperty, String paramScope, String name, String property, String scope, boolean transaction) throws JspException {
        if (paramId == null && name == null && !transaction) {
            return null;
        }
        Map map = null;
        try {
            if (name != null) {
                map = (Map)TagUtils.getInstance().lookup(pageContext, name, property, scope);
            }
        }
        catch (ClassCastException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("parameters.multi", (Object)name, (Object)property, (Object)scope));
        }
        catch (JspException e) {
            this.saveException(pageContext, e);
            throw e;
        }
        HashMap<String, Object> results = null;
        results = map != null ? new HashMap(map) : new HashMap<String, Object>();
        if (paramId != null && paramName != null) {
            Object paramValue = null;
            try {
                paramValue = TagUtils.getInstance().lookup(pageContext, paramName, paramProperty, paramScope);
            }
            catch (JspException e) {
                this.saveException(pageContext, e);
                throw e;
            }
            if (paramValue != null) {
                String paramString = null;
                paramString = paramValue instanceof String ? (String)paramValue : paramValue.toString();
                Object mapValue = results.get(paramId);
                if (mapValue == null) {
                    results.put(paramId, paramString);
                } else if (mapValue instanceof String) {
                    String[] newValues = new String[]{(String)mapValue, paramString};
                    results.put(paramId, newValues);
                } else {
                    String[] oldValues = (String[])mapValue;
                    String[] newValues = new String[oldValues.length + 1];
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                    newValues[oldValues.length] = paramString;
                    results.put(paramId, newValues);
                }
            }
        }
        if (transaction) {
            HttpSession session = pageContext.getSession();
            String token = null;
            if (session != null) {
                token = (String)session.getAttribute("org.apache.struts.action.TOKEN");
            }
            if (token != null) {
                results.put("org.apache.struts.taglib.html.TOKEN", token);
            }
        }
        return results;
    }

    public String computeURL(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, false);
    }

    public String computeURLWithCharEncoding(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean useLocalEncoding) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, true, useLocalEncoding);
    }

    public String computeURL(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean encodeSeparator) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, encodeSeparator, false);
    }

    public String computeURLWithCharEncoding(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean encodeSeparator, boolean useLocalEncoding) throws MalformedURLException {
        int hash;
        String temp;
        String charEncoding = "UTF-8";
        if (useLocalEncoding) {
            charEncoding = pageContext.getResponse().getCharacterEncoding();
        }
        int n = 0;
        if (forward != null) {
            ++n;
        }
        if (href != null) {
            ++n;
        }
        if (page != null) {
            ++n;
        }
        if (action != null) {
            ++n;
        }
        if (n != 1) {
            throw new MalformedURLException(messages.getMessage("computeURL.specifier"));
        }
        ModuleConfig moduleConfig = instance.getModuleConfig(module, pageContext);
        StringBuffer url = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        if (forward != null) {
            ForwardConfig forwardConfig = moduleConfig.findForwardConfig(forward);
            if (forwardConfig == null) {
                throw new MalformedURLException(messages.getMessage("computeURL.forward", (Object)forward));
            }
            if (forwardConfig.getRedirect()) {
                redirect = true;
            }
            if (forwardConfig.getPath().startsWith("/")) {
                url.append(request.getContextPath());
                url.append(RequestUtils.forwardURL(request, forwardConfig, moduleConfig));
            } else {
                url.append(forwardConfig.getPath());
            }
        } else if (href != null) {
            url.append(href);
        } else if (action != null) {
            url.append(instance.getActionMappingURL(action, module, pageContext, false));
        } else {
            url.append(request.getContextPath());
            url.append(this.pageURL(request, page, moduleConfig));
        }
        if (anchor != null) {
            temp = url.toString();
            hash = temp.indexOf(35);
            if (hash >= 0) {
                url.setLength(hash);
            }
            url.append('#');
            url.append(this.encodeURL(anchor, charEncoding));
        }
        if (params != null && params.size() > 0) {
            temp = url.toString();
            hash = temp.indexOf(35);
            if (hash >= 0) {
                anchor = temp.substring(hash + 1);
                url.setLength(hash);
                temp = url.toString();
            } else {
                anchor = null;
            }
            String separator = null;
            separator = redirect ? "&" : (encodeSeparator ? "&amp;" : "&");
            boolean question = temp.indexOf(63) >= 0;
            Iterator keys = params.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = params.get(key);
                if (value == null) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append(separator);
                    }
                    url.append(this.encodeURL(key, charEncoding));
                    url.append('=');
                    continue;
                }
                if (value instanceof String) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append(separator);
                    }
                    url.append(this.encodeURL(key, charEncoding));
                    url.append('=');
                    url.append(this.encodeURL((String)value, charEncoding));
                    continue;
                }
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    for (int i = 0; i < values.length; ++i) {
                        if (!question) {
                            url.append('?');
                            question = true;
                        } else {
                            url.append(separator);
                        }
                        url.append(this.encodeURL(key, charEncoding));
                        url.append('=');
                        url.append(this.encodeURL(values[i], charEncoding));
                    }
                    continue;
                }
                if (!question) {
                    url.append('?');
                    question = true;
                } else {
                    url.append(separator);
                }
                url.append(this.encodeURL(key, charEncoding));
                url.append('=');
                url.append(this.encodeURL(value.toString(), charEncoding));
            }
            if (anchor != null) {
                url.append('#');
                url.append(this.encodeURL(anchor, charEncoding));
            }
        }
        if (href == null && pageContext.getSession() != null) {
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            if (redirect) {
                return response.encodeRedirectURL(url.toString());
            }
            return response.encodeURL(url.toString());
        }
        return url.toString();
    }

    public String encodeURL(String url) {
        return this.encodeURL(url, "UTF-8");
    }

    public String encodeURL(String url, String enc) {
        try {
            if (enc == null || enc.length() == 0) {
                enc = "UTF-8";
            }
            if (encode != null) {
                return (String)encode.invoke(null, url, enc);
            }
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"Could not find Java 1.4 encode method.  Using deprecated version.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.debug((Object)"Could not find Java 1.4 encode method. Using deprecated version.", (Throwable)e);
        }
        return URLEncoder.encode(url);
    }

    public String filter(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuffer result = null;
        String filtered = null;
        for (int i = 0; i < value.length(); ++i) {
            filtered = null;
            switch (value.charAt(i)) {
                case '<': {
                    filtered = "&lt;";
                    break;
                }
                case '>': {
                    filtered = "&gt;";
                    break;
                }
                case '&': {
                    filtered = "&amp;";
                    break;
                }
                case '\"': {
                    filtered = "&quot;";
                    break;
                }
                case '\'': {
                    filtered = "&#39;";
                }
            }
            if (result == null) {
                if (filtered == null) continue;
                result = new StringBuffer(value.length() + 50);
                if (i > 0) {
                    result.append(value.substring(0, i));
                }
                result.append(filtered);
                continue;
            }
            if (filtered == null) {
                result.append(value.charAt(i));
                continue;
            }
            result.append(filtered);
        }
        return result == null ? value : result.toString();
    }

    public ActionErrors getActionErrors(PageContext pageContext, String paramName) throws JspException {
        ActionErrors errors;
        block8: {
            errors = new ActionErrors();
            Object value = pageContext.findAttribute(paramName);
            if (value != null) {
                try {
                    if (value instanceof String) {
                        errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage((String)value));
                        break block8;
                    }
                    if (value instanceof String[]) {
                        String[] keys = (String[])value;
                        for (int i = 0; i < keys.length; ++i) {
                            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(keys[i]));
                        }
                        break block8;
                    }
                    if (value instanceof ActionErrors) {
                        errors = (ActionErrors)value;
                        break block8;
                    }
                    throw new JspException(messages.getMessage("actionErrors.errors", (Object)value.getClass().getName()));
                }
                catch (JspException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                }
            }
        }
        return errors;
    }

    public String getActionMappingName(String action) {
        String value = action;
        int question = action.indexOf("?");
        if (question >= 0) {
            value = value.substring(0, question);
        }
        int slash = value.lastIndexOf("/");
        int period = value.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            value = value.substring(0, period);
        }
        return value.startsWith("/") ? value : "/" + value;
    }

    public String getActionMappingURL(String action, PageContext pageContext) {
        return this.getActionMappingURL(action, null, pageContext, false);
    }

    public String getActionMappingURL(String action, String module, PageContext pageContext, boolean contextRelative) {
        String servletMapping;
        ModuleConfig moduleConfig;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String contextPath = request.getContextPath();
        StringBuffer value = new StringBuffer();
        if (contextPath.length() > 1) {
            value.append(contextPath);
        }
        if ((moduleConfig = ModuleUtils.getInstance().getModuleConfig(module, request, pageContext.getServletContext())) != null && !contextRelative) {
            value.append(moduleConfig.getPrefix());
        }
        if ((servletMapping = (String)pageContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING", 4)) != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = this.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            } else if (servletMapping.equals("/")) {
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    public ActionMessages getActionMessages(PageContext pageContext, String paramName) throws JspException {
        ActionMessages am;
        block9: {
            am = new ActionMessages();
            Object value = pageContext.findAttribute(paramName);
            if (value != null) {
                try {
                    if (value instanceof String) {
                        am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage((String)value));
                        break block9;
                    }
                    if (value instanceof String[]) {
                        String[] keys = (String[])value;
                        for (int i = 0; i < keys.length; ++i) {
                            am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(keys[i]));
                        }
                        break block9;
                    }
                    if (value instanceof ActionErrors) {
                        ActionMessages m = (ActionMessages)value;
                        am.add(m);
                        break block9;
                    }
                    if (value instanceof ActionMessages) {
                        am = (ActionMessages)value;
                        break block9;
                    }
                    throw new JspException(messages.getMessage("actionMessages.errors", (Object)value.getClass().getName()));
                }
                catch (JspException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to retieve ActionMessage for paramName : " + paramName), (Throwable)e);
                }
            }
        }
        return am;
    }

    public ModuleConfig getModuleConfig(PageContext pageContext) {
        return this.getModuleConfig(null, pageContext);
    }

    public ModuleConfig getModuleConfig(String module, PageContext pageContext) {
        return ModuleUtils.getInstance().getModuleConfig(module, (HttpServletRequest)pageContext.getRequest(), pageContext.getServletContext());
    }

    public int getScope(String scopeName) throws JspException {
        Integer scope = (Integer)scopes.get(scopeName.toLowerCase());
        if (scope == null) {
            throw new JspException(messages.getMessage("lookup.scope", scope));
        }
        return scope;
    }

    public Locale getUserLocale(PageContext pageContext, String locale) {
        return RequestUtils.getUserLocale((HttpServletRequest)pageContext.getRequest(), locale);
    }

    public boolean isXhtml(PageContext pageContext) {
        String xhtml = (String)pageContext.getAttribute("org.apache.struts.globals.XHTML", 1);
        return "true".equalsIgnoreCase(xhtml);
    }

    public Object lookup(PageContext pageContext, String name, String scopeName) throws JspException {
        if (scopeName == null) {
            return pageContext.findAttribute(name);
        }
        try {
            return pageContext.getAttribute(name, instance.getScope(scopeName));
        }
        catch (JspException e) {
            this.saveException(pageContext, e);
            throw e;
        }
    }

    public Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object bean = this.lookup(pageContext, name, scope);
        if (bean == null) {
            JspException e = null;
            e = scope == null ? new JspException(messages.getMessage("lookup.bean.any", (Object)name)) : new JspException(messages.getMessage("lookup.bean", (Object)name, (Object)scope));
            this.saveException(pageContext, e);
            throw e;
        }
        if (property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (IllegalAccessException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.access", (Object)property, (Object)name));
        }
        catch (IllegalArgumentException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.argument", (Object)property, (Object)name));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            this.saveException(pageContext, t);
            throw new JspException(messages.getMessage("lookup.target", (Object)property, (Object)name));
        }
        catch (NoSuchMethodException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.method", (Object)property, (Object)name));
        }
    }

    public String message(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        return this.message(pageContext, bundle, locale, key, null);
    }

    public String message(PageContext pageContext, String bundle, String locale, String key, Object[] args) throws JspException {
        MessageResources resources = this.retrieveMessageResources(pageContext, bundle, false);
        Locale userLocale = this.getUserLocale(pageContext, locale);
        String message = null;
        message = args == null ? resources.getMessage(userLocale, key) : resources.getMessage(userLocale, key, args);
        if (message == null && log.isDebugEnabled()) {
            log.debug((Object)resources.getMessage("message.resources", (Object)key, (Object)bundle, (Object)locale));
        }
        return message;
    }

    public String pageURL(HttpServletRequest request, String page, ModuleConfig moduleConfig) {
        StringBuffer sb = new StringBuffer();
        String pagePattern = moduleConfig.getControllerConfig().getPagePattern();
        if (pagePattern == null) {
            sb.append(moduleConfig.getPrefix());
            sb.append(page);
        } else {
            boolean dollar = false;
            for (int i = 0; i < pagePattern.length(); ++i) {
                char ch = pagePattern.charAt(i);
                if (dollar) {
                    switch (ch) {
                        case 'M': {
                            sb.append(moduleConfig.getPrefix());
                            break;
                        }
                        case 'P': {
                            sb.append(page);
                            break;
                        }
                        case '$': {
                            sb.append('$');
                            break;
                        }
                    }
                    dollar = false;
                    continue;
                }
                if (ch == '$') {
                    dollar = true;
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    public boolean present(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        MessageResources resources = this.retrieveMessageResources(pageContext, bundle, true);
        Locale userLocale = this.getUserLocale(pageContext, locale);
        return resources.isPresent(userLocale, key);
    }

    private MessageResources retrieveMessageResources(PageContext pageContext, String bundle, boolean checkPageScope) throws JspException {
        MessageResources resources = null;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if (checkPageScope) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 1);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 2);
        }
        if (resources == null) {
            ModuleConfig moduleConfig = this.getModuleConfig(pageContext);
            resources = (MessageResources)pageContext.getAttribute(bundle + moduleConfig.getPrefix(), 4);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 4);
        }
        if (resources == null) {
            JspException e = new JspException(messages.getMessage("message.bundle", (Object)bundle));
            this.saveException(pageContext, e);
            throw e;
        }
        return resources;
    }

    public void saveException(PageContext pageContext, Throwable exception) {
        pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)exception, 2);
    }

    public void write(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.print(text);
        }
        catch (IOException e) {
            TagUtils.getInstance().saveException(pageContext, e);
            throw new JspException(messages.getMessage("write.io", (Object)e.toString()));
        }
    }

    public void writePrevious(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        if (writer instanceof BodyContent) {
            writer = ((BodyContent)writer).getEnclosingWriter();
        }
        try {
            writer.print(text);
        }
        catch (IOException e) {
            TagUtils.getInstance().saveException(pageContext, e);
            throw new JspException(messages.getMessage("write.io", (Object)e.toString()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TagUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TagUtils.class$("java.lang.String")) : class$java$lang$String};
            encode = (class$java$net$URLEncoder == null ? (class$java$net$URLEncoder = TagUtils.class$("java.net.URLEncoder")) : class$java$net$URLEncoder).getMethod("encode", args);
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)"Could not find Java 1.4 encode method.  Using deprecated version.", (Throwable)e);
        }
        scopes.put("page", new Integer(1));
        scopes.put("request", new Integer(2));
        scopes.put("session", new Integer(3));
        scopes.put("application", new Integer(4));
    }
}

