/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.matchers;

import au.com.dius.pact.core.support.json.JsonValue;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Patch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"NEW_LINE", "", "generateDiff", "", "", "expectedBodyString", "actualBodyString", "generateJsonDiff", "expected", "Lau/com/dius/pact/core/support/json/JsonValue;", "actual", "matchers"})
public final class DiffUtilsKt {
    private static final char NEW_LINE = '\n';

    @NotNull
    public static final List<String> generateDiff(@NotNull String expectedBodyString, @NotNull String actualBodyString) {
        Intrinsics.checkNotNullParameter((Object)expectedBodyString, (String)"expectedBodyString");
        Intrinsics.checkNotNullParameter((Object)actualBodyString, (String)"actualBodyString");
        char[] cArray = new char[]{'\n'};
        List expectedLines = StringsKt.split$default((CharSequence)expectedBodyString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'\n'};
        List actualLines = StringsKt.split$default((CharSequence)actualBodyString, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        Patch patch = DiffUtils.diff((List)expectedLines, (List)actualLines);
        List diff = new ArrayList();
        int line = 0;
        List list = patch.getDeltas();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"patch.deltas");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            Object element$iv2;
            AbstractDelta delta = (AbstractDelta)element$iv;
            boolean bl = false;
            if (!(delta instanceof ChangeDelta)) continue;
            if (((ChangeDelta)delta).getSource().getPosition() >= 1 && (diff.isEmpty() || !Intrinsics.areEqual(expectedLines.get(((ChangeDelta)delta).getSource().getPosition() - 1), (Object)CollectionsKt.last((List)diff)))) {
                diff.addAll(CollectionsKt.slice((List)expectedLines, (IntRange)RangesKt.until((int)line, (int)((ChangeDelta)delta).getSource().getPosition())));
            }
            List list2 = ((ChangeDelta)delta).getSource().getLines();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"delta.source.lines");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl2 = false;
                diff.add("-" + it);
            }
            List list3 = ((ChangeDelta)delta).getTarget().getLines();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"delta.target.lines");
            $this$forEach$iv2 = list3;
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl3 = false;
                diff.add("+" + it);
            }
            line = ((ChangeDelta)delta).getSource().getPosition() + ((ChangeDelta)delta).getSource().getLines().size();
        }
        if (line < expectedLines.size()) {
            CollectionsKt.addAll((Collection)diff, (Sequence)SequencesKt.asSequence((Iterator)expectedLines.listIterator(line)));
        }
        return diff;
    }

    @NotNull
    public static final String generateJsonDiff(@NotNull JsonValue expected, @NotNull JsonValue actual) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        String actualJson = JsonValue.prettyPrint$default((JsonValue)actual, (int)0, (boolean)false, (int)3, null);
        String expectedJson = JsonValue.prettyPrint$default((JsonValue)expected, (int)0, (boolean)false, (int)3, null);
        return CollectionsKt.joinToString$default((Iterable)DiffUtilsKt.generateDiff(expectedJson, actualJson), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

