/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.matchers;

import au.com.dius.pact.core.matchers.BodyItemMatchResult;
import au.com.dius.pact.core.matchers.BodyMatchResult;
import au.com.dius.pact.core.matchers.BodyMismatch;
import au.com.dius.pact.core.matchers.ContentMatcher;
import au.com.dius.pact.core.matchers.JsonContentMatcher;
import au.com.dius.pact.core.matchers.MatchingContext;
import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.json.JsonException;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.KafkaSchemaRegistryWireFormatter;
import io.pact.plugins.jvm.core.InteractionContents;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J0\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\u00180\u00152\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aH\u0016\u00a8\u0006\u001d"}, d2={"Lau/com/dius/pact/core/matchers/KafkaJsonSchemaContentMatcher;", "Lau/com/dius/pact/core/matchers/ContentMatcher;", "()V", "getInvalidActualJsonResult", "Lau/com/dius/pact/core/matchers/BodyMatchResult;", "expected", "Lau/com/dius/pact/core/model/OptionalBody;", "actual", "isInvalidActualValue", "", "decodedActualOptionalBody", "isParsableJson", "value", "", "isValidJson", "matchBody", "context", "Lau/com/dius/pact/core/matchers/MatchingContext;", "removeMagicBytes", "optionalBody", "setupBodyFromConfig", "Lau/com/dius/pact/core/support/Result;", "", "Lio/pact/plugins/jvm/core/InteractionContents;", "", "bodyConfig", "", "", "Companion", "matchers"})
public final class KafkaJsonSchemaContentMatcher
implements ContentMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public BodyMatchResult matchBody(@NotNull OptionalBody expected, @NotNull OptionalBody actual, @NotNull MatchingContext context) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OptionalBody raw = this.removeMagicBytes(actual);
        if (this.isInvalidActualValue(expected, raw)) {
            return this.getInvalidActualJsonResult(expected, raw);
        }
        return JsonContentMatcher.INSTANCE.matchBody(expected, raw, context);
    }

    private final OptionalBody removeMagicBytes(OptionalBody optionalBody) {
        return OptionalBody.copy$default((OptionalBody)optionalBody, null, (byte[])KafkaSchemaRegistryWireFormatter.removeMagicBytes((byte[])optionalBody.getValue()), null, null, (int)13, null);
    }

    private final boolean isInvalidActualValue(OptionalBody expected, OptionalBody decodedActualOptionalBody) {
        return expected.isPresent() && !this.isValidJson(decodedActualOptionalBody.getValue());
    }

    private final BodyMatchResult getInvalidActualJsonResult(OptionalBody expected, OptionalBody actual) {
        return new BodyMatchResult(null, CollectionsKt.listOf((Object)new BodyItemMatchResult("$", CollectionsKt.listOf((Object)new BodyMismatch(expected.valueAsString(), actual.valueAsString(), "Expected json body but received '" + actual.valueAsString() + "'", null, null, 24, null)))));
    }

    @Override
    @NotNull
    public Result<List<InteractionContents>, String> setupBodyFromConfig(@NotNull Map<String, ? extends Object> bodyConfig) {
        Intrinsics.checkNotNullParameter(bodyConfig, (String)"bodyConfig");
        String string = Json.toJson((Object)bodyConfig.get("body")).serialise();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return (Result)new Result.Ok((Object)CollectionsKt.listOf((Object)new InteractionContents("", OptionalBody.Companion.body(byArray, ContentType.Companion.getKAFKA_SCHEMA_REGISTRY_JSON()), null, null, null, null, null, null, null, 508, null)));
    }

    private final boolean isValidJson(byte[] value) {
        if (value == null) {
            return false;
        }
        return value.length == 0 || this.isParsableJson(value);
    }

    private final boolean isParsableJson(byte[] value) {
        boolean bl;
        try {
            JsonParser.parseString((String)new String(value, Charsets.UTF_8));
            bl = true;
        }
        catch (JsonException e) {
            Companion.getLogger().debug("Swallowed Exception deliberately", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/core/matchers/KafkaJsonSchemaContentMatcher$Companion;", "Lmu/KLogging;", "()V", "matchers"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

