/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.HttpPart;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.json.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J&\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J&\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lau/com/dius/pact/core/model/BaseRequest;", "Lau/com/dius/pact/core/model/HttpPart;", "()V", "isMultipartFileUpload", "", "withMultipartFileUpload", "partName", "", "filename", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "contents", "Companion", "model"})
public abstract class BaseRequest
extends HttpPart {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final BaseRequest withMultipartFileUpload(@NotNull String partName, @NotNull String filename, @NotNull ContentType contentType, @NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        return this.withMultipartFileUpload(partName, filename, contentType.toString(), contents);
    }

    @NotNull
    public final BaseRequest withMultipartFileUpload(@NotNull String partName, @NotNull String filename, @NotNull String contentType, @NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        MimeMultipart multipart = new MimeMultipart("form-data");
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader("Content-Disposition", "form-data; name=\"" + partName + "\"; filename=\"" + filename + "\"");
        internetHeaders.setHeader("Content-Type", contentType);
        String string = contents;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        multipart.addBodyPart((BodyPart)new MimeBodyPart(internetHeaders, byArray));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)stream);
        this.setBody(OptionalBody.Companion.body(stream.toByteArray(), new ContentType(contentType)));
        this.getHeaders().put("Content-Type", CollectionsKt.listOf((Object)multipart.getContentType()));
        return this;
    }

    public final boolean isMultipartFileUpload() {
        return this.determineContentType().isMultipartFormData();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lau/com/dius/pact/core/model/BaseRequest$Companion;", "", "()V", "parseQueryParametersToMap", "", "", "", "query", "Lau/com/dius/pact/core/support/json/JsonValue;", "model"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, List<String>> parseQueryParametersToMap(@Nullable JsonValue query) {
            Map map;
            JsonValue jsonValue = query;
            if (jsonValue == null) {
                map = MapsKt.emptyMap();
            } else if (jsonValue instanceof JsonValue.Object) {
                void $this$associateTo$iv$iv;
                Iterable $this$associate$iv = ((JsonValue.Object)query).getEntries().entrySet();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    List list;
                    Map map2 = destination$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    JsonValue value = (JsonValue)entry.getValue();
                    if (value instanceof JsonValue.Array) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = ((JsonValue.Array)value).getValues();
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            JsonValue jsonValue2 = (JsonValue)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl2 = false;
                            collection.add(Json.INSTANCE.toString((JsonValue)it));
                        }
                        list = (List)destination$iv$iv2;
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List list2 = list;
                    Pair pair = TuplesKt.to(entry.getKey(), (Object)list2);
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                map = destination$iv$iv;
            } else {
                map = jsonValue instanceof JsonValue.StringValue ? PactReaderKt.queryStringToMap$default(((JsonValue.StringValue)query).asString(), false, 2, null) : MapsKt.emptyMap();
            }
            return map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

