/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.ContentTypeKt;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lau/com/dius/pact/core/model/ContentType;", "", "contentType", "", "(Ljava/lang/String;)V", "Lorg/apache/tika/mime/MediaType;", "(Lorg/apache/tika/mime/MediaType;)V", "getContentType", "()Lorg/apache/tika/mime/MediaType;", "asCharset", "Ljava/nio/charset/Charset;", "asString", "equals", "", "other", "getBaseType", "getSupertype", "hashCode", "", "isBinaryType", "isJson", "isKafkaSchemaRegistryJson", "isMultipart", "isMultipartFormData", "isOctetStream", "isXml", "or", "toString", "Companion", "model"})
public final class ContentType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final MediaType contentType;
    @NotNull
    private static final Regex XMLREGEXP = new Regex("^\\s*<\\?xml\\s*version.*");
    @NotNull
    private static final Regex HTMLREGEXP = new Regex("^\\s*(<!DOCTYPE)|(<HTML>).*");
    @NotNull
    private static final Regex JSONREGEXP = new Regex("^\\s*(true|false|null|[0-9]+|\"\\w*|\\{\\s*(}|\"\\w+)|\\[\\s*).*");
    @NotNull
    private static final Regex XMLREGEXP2 = new Regex("^\\s*<\\w+\\s*(:\\w+=[\\\"\u201d][^\\\"\u201d]+[\\\"\u201d])?.*");
    @NotNull
    private static final Regex JSON_TYPE = new Regex(".*json", SetsKt.setOf((Object)RegexOption.IGNORE_CASE));
    @NotNull
    private static final MediaTypeRegistry registry;
    @NotNull
    private static final ContentType UNKNOWN;
    @NotNull
    private static final ContentType TEXT_PLAIN;
    @NotNull
    private static final ContentType HTML;
    @NotNull
    private static final ContentType JSON;
    @NotNull
    private static final ContentType XML;
    @NotNull
    private static final ContentType KAFKA_SCHEMA_REGISTRY_JSON;

    public ContentType(@Nullable MediaType contentType) {
        this.contentType = contentType;
    }

    @Nullable
    public final MediaType getContentType() {
        return this.contentType;
    }

    public ContentType(@NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this(MediaType.parse((String)contentType));
    }

    public final boolean isJson() {
        boolean bl;
        if (this.contentType != null) {
            if (Intrinsics.areEqual((Object)System.getProperty("pact.content_type.override." + this.contentType.getBaseType()), (Object)"json")) {
                bl = true;
            } else if (Intrinsics.areEqual((Object)"vnd.schemaregistry.v1+json", (Object)this.contentType.getSubtype())) {
                bl = false;
            } else {
                MediaType superType;
                Regex regex = ContentTypeKt.access$getJsonRegex$p();
                String string = this.contentType.getSubtype();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentType.subtype");
                String string2 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
                bl = regex.matches((CharSequence)string2) ? true : (superType = registry.getSupertype(this.contentType)) != null && Intrinsics.areEqual((Object)superType.getType(), (Object)"application") && Intrinsics.areEqual((Object)superType.getSubtype(), (Object)"json");
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isXml() {
        boolean bl;
        if (this.contentType != null) {
            if (Intrinsics.areEqual((Object)System.getProperty("pact.content_type.override." + this.contentType.getBaseType()), (Object)"xml")) {
                bl = true;
            } else {
                Regex regex = ContentTypeKt.access$getXmlRegex$p();
                String string = this.contentType.getSubtype();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentType.subtype");
                String string2 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
                bl = regex.matches((CharSequence)string2);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isKafkaSchemaRegistryJson() {
        return this.contentType != null ? (Intrinsics.areEqual((Object)System.getProperty("pact.content_type.override." + this.contentType.getBaseType()), (Object)"kafkaSchemaRegistryJson") ? true : Intrinsics.areEqual((Object)this.contentType.getSubtype(), (Object)"vnd.schemaregistry.v1+json")) : false;
    }

    public final boolean isOctetStream() {
        return this.contentType != null ? Intrinsics.areEqual((Object)this.contentType.getBaseType().toString(), (Object)"application/octet-stream") : false;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.contentType);
    }

    @Nullable
    public final String asString() {
        MediaType mediaType = this.contentType;
        return mediaType != null ? mediaType.toString() : null;
    }

    @NotNull
    public final Charset asCharset() {
        Charset charset;
        if (this.contentType != null && this.contentType.hasParameters()) {
            String cs = (String)this.contentType.getParameters().get("charset");
            Charset charset2 = KotlinLanguageSupportKt.isNotEmpty((String)cs) ? Charset.forName(cs) : Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"{\n      val cs = content\u2026ltCharset()\n      }\n    }");
            charset = charset2;
        } else {
            Charset charset3 = Charset.defaultCharset();
            charset = charset3;
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"{\n      Charset.defaultCharset()\n    }");
        }
        return charset;
    }

    @NotNull
    public final ContentType or(@NotNull ContentType other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.contentType == null ? other : this;
    }

    @Nullable
    public final String getBaseType() {
        MediaType mediaType = this.contentType;
        return mediaType != null && (mediaType = mediaType.getBaseType()) != null ? mediaType.toString() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBinaryType() {
        if (this.contentType == null) return false;
        MediaType mediaType = registry.getSupertype(this.contentType);
        if (mediaType == null) {
            mediaType = MediaType.OCTET_STREAM;
        }
        MediaType superType = mediaType;
        String type = this.contentType.getType();
        String baseType = superType.getType();
        String string = System.getProperty("pact.content_type.override." + type + "." + this.contentType.getSubtype());
        if (string == null) {
            string = System.getProperty("pact.content_type.override." + type + "/" + this.contentType.getSubtype());
        }
        String override = string;
        if (!KotlinLanguageSupportKt.isNotEmpty((String)override)) {
            if (Intrinsics.areEqual((Object)type, (Object)"text")) return false;
            if (Intrinsics.areEqual((Object)baseType, (Object)"text")) {
                return false;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"image")) return true;
            if (Intrinsics.areEqual((Object)baseType, (Object)"image")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"audio")) return true;
            if (Intrinsics.areEqual((Object)baseType, (Object)"audio")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"video")) return true;
            if (Intrinsics.areEqual((Object)baseType, (Object)"video")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"application") && Intrinsics.areEqual((Object)this.contentType.getSubtype(), (Object)"pdf")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"application") && Intrinsics.areEqual((Object)this.contentType.getSubtype(), (Object)"xml")) {
                return false;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"application") && Intrinsics.areEqual((Object)this.contentType.getSubtype(), (Object)"json")) {
                return false;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"application") && Intrinsics.areEqual((Object)superType.getSubtype(), (Object)"javascript")) {
                return false;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"application")) {
                String string2 = this.contentType.getSubtype();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contentType.subtype");
                CharSequence charSequence = string2;
                if (JSON_TYPE.matches(charSequence)) {
                    return false;
                }
            }
            if (Intrinsics.areEqual((Object)superType, (Object)MediaType.APPLICATION_ZIP)) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)superType, (Object)MediaType.OCTET_STREAM)) return false;
            return true;
        }
        boolean bl = Intrinsics.areEqual((Object)override, (Object)"binary");
        return bl;
    }

    public final boolean isMultipart() {
        return this.contentType != null ? Intrinsics.areEqual((Object)this.contentType.getBaseType().getType(), (Object)"multipart") : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMultipartFormData() {
        if (!this.isMultipart()) return false;
        MediaType mediaType = this.contentType;
        if (!Intrinsics.areEqual((Object)(mediaType != null ? mediaType.getSubtype() : null), (Object)"form-data")) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof MediaType ? Intrinsics.areEqual((Object)this.contentType, (Object)other) : (!(other instanceof ContentType) ? false : Intrinsics.areEqual((Object)this.contentType, (Object)((ContentType)other).contentType)));
    }

    public int hashCode() {
        MediaType mediaType = this.contentType;
        return mediaType != null ? mediaType.hashCode() : 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final ContentType getSupertype() {
        MediaType supertype;
        ContentType contentType;
        if (this.contentType != null) {
            String string = this.contentType.getSubtype();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentType.subtype");
            if (StringsKt.endsWith$default((String)string, (String)"+json", (boolean)false, (int)2, null)) {
                contentType = JSON;
                return contentType;
            }
        }
        if ((supertype = registry.getSupertype(this.contentType)) == null) return null;
        contentType = new ContentType(supertype);
        return contentType;
    }

    @JvmStatic
    @NotNull
    public static final ContentType fromString(@Nullable String contentType) {
        return Companion.fromString(contentType);
    }

    @NotNull
    public static final ContentType getUNKNOWN() {
        return Companion.getUNKNOWN();
    }

    @NotNull
    public static final ContentType getTEXT_PLAIN() {
        return Companion.getTEXT_PLAIN();
    }

    @NotNull
    public static final ContentType getHTML() {
        return Companion.getHTML();
    }

    @NotNull
    public static final ContentType getJSON() {
        return Companion.getJSON();
    }

    @NotNull
    public static final ContentType getXML() {
        return Companion.getXML();
    }

    @NotNull
    public static final ContentType getKAFKA_SCHEMA_REGISTRY_JSON() {
        return Companion.getKAFKA_SCHEMA_REGISTRY_JSON();
    }

    static {
        MediaTypeRegistry mediaTypeRegistry = MimeTypes.getDefaultMimeTypes((ClassLoader)ContentType.class.getClassLoader()).getMediaTypeRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)mediaTypeRegistry, (String)"getDefaultMimeTypes(Cont\u2026\n      .mediaTypeRegistry");
        registry = mediaTypeRegistry;
        UNKNOWN = new ContentType(null);
        TEXT_PLAIN = new ContentType("text/plain; charset=ISO-8859-1");
        HTML = new ContentType("text/html");
        JSON = new ContentType("application/json");
        XML = new ContentType("application/xml");
        KAFKA_SCHEMA_REGISTRY_JSON = new ContentType("application/vnd.schemaregistry.v1+json");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010)H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u001c\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u0007R\u001c\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0007R\u001c\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u0007R\u001c\u0010\u001c\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001e\u0010\u0007R\u0011\u0010\u001f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000bR\u0011\u0010!\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000bR\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lau/com/dius/pact/core/model/ContentType$Companion;", "Lmu/KLogging;", "()V", "HTML", "Lau/com/dius/pact/core/model/ContentType;", "getHTML$annotations", "getHTML", "()Lau/com/dius/pact/core/model/ContentType;", "HTMLREGEXP", "Lkotlin/text/Regex;", "getHTMLREGEXP", "()Lkotlin/text/Regex;", "JSON", "getJSON$annotations", "getJSON", "JSONREGEXP", "getJSONREGEXP", "JSON_TYPE", "getJSON_TYPE", "KAFKA_SCHEMA_REGISTRY_JSON", "getKAFKA_SCHEMA_REGISTRY_JSON$annotations", "getKAFKA_SCHEMA_REGISTRY_JSON", "TEXT_PLAIN", "getTEXT_PLAIN$annotations", "getTEXT_PLAIN", "UNKNOWN", "getUNKNOWN$annotations", "getUNKNOWN", "XML", "getXML$annotations", "getXML", "XMLREGEXP", "getXMLREGEXP", "XMLREGEXP2", "getXMLREGEXP2", "registry", "Lorg/apache/tika/mime/MediaTypeRegistry;", "getRegistry", "()Lorg/apache/tika/mime/MediaTypeRegistry;", "fromString", "contentType", "", "model"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ContentType fromString(@Nullable String contentType) {
            CharSequence charSequence = contentType;
            return charSequence == null || charSequence.length() == 0 ? this.getUNKNOWN() : new ContentType(contentType);
        }

        @NotNull
        public final Regex getXMLREGEXP() {
            return XMLREGEXP;
        }

        @NotNull
        public final Regex getHTMLREGEXP() {
            return HTMLREGEXP;
        }

        @NotNull
        public final Regex getJSONREGEXP() {
            return JSONREGEXP;
        }

        @NotNull
        public final Regex getXMLREGEXP2() {
            return XMLREGEXP2;
        }

        @NotNull
        public final Regex getJSON_TYPE() {
            return JSON_TYPE;
        }

        @NotNull
        public final MediaTypeRegistry getRegistry() {
            return registry;
        }

        @NotNull
        public final ContentType getUNKNOWN() {
            return UNKNOWN;
        }

        @JvmStatic
        public static /* synthetic */ void getUNKNOWN$annotations() {
        }

        @NotNull
        public final ContentType getTEXT_PLAIN() {
            return TEXT_PLAIN;
        }

        @JvmStatic
        public static /* synthetic */ void getTEXT_PLAIN$annotations() {
        }

        @NotNull
        public final ContentType getHTML() {
            return HTML;
        }

        @JvmStatic
        public static /* synthetic */ void getHTML$annotations() {
        }

        @NotNull
        public final ContentType getJSON() {
            return JSON;
        }

        @JvmStatic
        public static /* synthetic */ void getJSON$annotations() {
        }

        @NotNull
        public final ContentType getXML() {
            return XML;
        }

        @JvmStatic
        public static /* synthetic */ void getXML$annotations() {
        }

        @NotNull
        public final ContentType getKAFKA_SCHEMA_REGISTRY_JSON() {
            return KAFKA_SCHEMA_REGISTRY_JSON;
        }

        @JvmStatic
        public static /* synthetic */ void getKAFKA_SCHEMA_REGISTRY_JSON$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

