/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.ClosurePactSource;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.InputStreamPactSource;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactReader;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.ReaderPactSource;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.model.S3PactSource;
import au.com.dius.pact.core.model.UnknownPactSource;
import au.com.dius.pact.core.model.UrlPactSource;
import au.com.dius.pact.core.model.UrlSource;
import au.com.dius.pact.core.model.V4Interaction;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.model.messaging.MessagePact;
import au.com.dius.pact.core.pactbroker.PactBrokerResult;
import au.com.dius.pact.core.support.HttpClient;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.Utils;
import au.com.dius.pact.core.support.Version;
import au.com.dius.pact.core.support.json.JsonException;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.core.support.json.JsonValueKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0007J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J2\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00072\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0007H\u0016J$\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\u00072\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\"H\u0016J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u000fH\u0007J\u0018\u0010+\u001a\u00020$2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u000fH\u0007J\u0018\u0010,\u001a\u00020$2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u000fH\u0007J\u0018\u0010-\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u0018\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0007J\u0014\u00102\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u00063"}, d2={"Lau/com/dius/pact/core/model/DefaultPactReader;", "Lau/com/dius/pact/core/model/PactReader;", "Lmu/KLogging;", "()V", "CLASSPATH_URI_START", "", "s3Client", "", "getS3Client$annotations", "getS3Client", "()Ljava/lang/Object;", "setS3Client", "(Ljava/lang/Object;)V", "determineSpecVersion", "pactInfo", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "extractRequest", "Lau/com/dius/pact/core/model/Request;", "requestJson", "extractResponse", "Lau/com/dius/pact/core/model/Response;", "responseJson", "fileExists", "", "path", "formatBody", "", "json", "Lau/com/dius/pact/core/support/json/JsonValue;", "loadFile", "Lkotlin/Pair;", "Lau/com/dius/pact/core/model/PactSource;", "source", "options", "", "loadPact", "Lau/com/dius/pact/core/model/Pact;", "loadPactFromClasspath", "loadPactFromFile", "loadPactFromS3Bucket", "loadV2Pact", "Lau/com/dius/pact/core/model/RequestResponsePact;", "pactJson", "loadV3Pact", "loadV4Pact", "pactFromJson", "specVersion", "specification", "defaultVersion", "transformJson", "transformRequestResponseJson", "model"})
public final class DefaultPactReader
extends KLogging
implements PactReader {
    @NotNull
    public static final DefaultPactReader INSTANCE = new DefaultPactReader();
    @NotNull
    private static final String CLASSPATH_URI_START = "classpath:";
    public static Object s3Client;

    private DefaultPactReader() {
    }

    @NotNull
    public static final Object getS3Client() {
        Object object = s3Client;
        if (object != null) {
            return object;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"s3Client");
        return Unit.INSTANCE;
    }

    public static final void setS3Client(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        s3Client = object;
    }

    @JvmStatic
    public static /* synthetic */ void getS3Client$annotations() {
    }

    @Override
    @NotNull
    public Pact loadPact(@NotNull Object source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.loadPact(source, MapsKt.emptyMap());
    }

    @Override
    @NotNull
    public Pact loadPact(@NotNull Object source, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Pair<JsonValue.Object, PactSource> json2 = this.loadFile(source, options);
        return this.pactFromJson((JsonValue.Object)json2.getFirst(), (PactSource)json2.getSecond());
    }

    @Override
    @NotNull
    public Pact pactFromJson(@NotNull JsonValue.Object json2, @NotNull PactSource source) {
        Pact pact;
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String version = DefaultPactReader.determineSpecVersion(json2);
        Version specVersion2 = (Version)Version.Companion.parse(version).expect((Function0)new Function0<String>(version){
            final /* synthetic */ String $version;
            {
                this.$version = $version;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "'" + this.$version + "' is not a valid version";
            }
        });
        switch (specVersion2.getMajor()) {
            case 3: {
                pact = DefaultPactReader.loadV3Pact(source, json2);
                break;
            }
            case 4: {
                pact = DefaultPactReader.loadV4Pact(source, json2);
                break;
            }
            default: {
                pact = DefaultPactReader.loadV2Pact(source, json2);
            }
        }
        return pact;
    }

    @JvmStatic
    @NotNull
    public static final String determineSpecVersion(@NotNull JsonValue.Object pactInfo) {
        Intrinsics.checkNotNullParameter((Object)pactInfo, (String)"pactInfo");
        String version = "2.0.0";
        if (pactInfo.has("metadata")) {
            JsonValue this_$iv = pactInfo.get("metadata");
            boolean $i$f$downcast = false;
            if (!(this_$iv instanceof JsonValue.Object)) {
                throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
            }
            JsonValue.Object metadata2 = (JsonValue.Object)this_$iv;
            version = metadata2.has("pactSpecificationVersion") ? Json.INSTANCE.toString(metadata2.get("pactSpecificationVersion")) : (metadata2.has("pactSpecification") ? INSTANCE.specVersion(metadata2.get("pactSpecification"), version) : (metadata2.has("pact-specification") ? INSTANCE.specVersion(metadata2.get("pact-specification"), version) : version));
        }
        return version;
    }

    private final String specVersion(JsonValue specification, String defaultVersion) {
        if (!(specification instanceof JsonValue.Object && specification.has("version") && ((JsonValue.Object)specification).get("version").isString())) {
            return defaultVersion;
        }
        String string = ((JsonValue.Object)specification).get("version").asString();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Pact loadV3Pact(@NotNull PactSource source, @NotNull JsonValue.Object pactJson) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pactJson, (String)"pactJson");
        if (pactJson.has("messages")) {
            return MessagePact.Companion.fromJson(pactJson, source);
        }
        JsonValue.Object transformedJson = DefaultPactReader.transformJson(pactJson);
        Provider provider = Provider.Companion.fromJson(transformedJson.get("provider"));
        Consumer consumer = Consumer.Companion.fromJson(transformedJson.get("consumer"));
        List interactions2 = JsonValueKt.map((JsonValue)transformedJson.get("interactions"), (Function1)loadV3Pact.interactions.1.INSTANCE);
        return new RequestResponsePact(provider, consumer, CollectionsKt.toMutableList((Collection)interactions2), BasePact.Companion.metaData(transformedJson.get("metadata"), PactSpecVersion.V3), source);
    }

    @JvmStatic
    @NotNull
    public static final RequestResponsePact loadV2Pact(@NotNull PactSource source, @NotNull JsonValue.Object pactJson) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pactJson, (String)"pactJson");
        JsonValue.Object transformedJson = DefaultPactReader.transformJson(pactJson);
        Provider provider = Provider.Companion.fromJson(transformedJson.get("provider"));
        Consumer consumer = Consumer.Companion.fromJson(transformedJson.get("consumer"));
        List interactions2 = transformedJson.has("interactions") ? JsonValueKt.map((JsonValue)((JsonValue)transformedJson.get("interactions").asArray()), (Function1)loadV2Pact.interactions.1.INSTANCE) : CollectionsKt.emptyList();
        return new RequestResponsePact(provider, consumer, CollectionsKt.toMutableList((Collection)interactions2), BasePact.Companion.metaData(transformedJson.get("metadata"), PactSpecVersion.V2), source);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pact loadV4Pact(@NotNull PactSource source, @NotNull JsonValue.Object pactJson) {
        List list;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pactJson, (String)"pactJson");
        Provider provider = Provider.Companion.fromJson(pactJson.get("provider"));
        Consumer consumer = Consumer.Companion.fromJson(pactJson.get("consumer"));
        if (pactJson.has("interactions") && pactJson.get("interactions").isArray()) {
            void $this$mapIndexedTo$iv$iv;
            JsonValue.Array array = pactJson.get("interactions").asArray();
            Intrinsics.checkNotNull((Object)array);
            Iterable $this$mapIndexed$iv = array.getValues();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void interaction;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JsonValue jsonValue = (JsonValue)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((V4Interaction)V4Interaction.Companion.interactionFromJson((int)i, (JsonValue)interaction, source).unwrap());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List interactions2 = list;
        return new V4Pact(consumer, provider, CollectionsKt.toMutableList((Collection)interactions2), BasePact.Companion.metaData(pactJson.get("metadata"), PactSpecVersion.V4), source);
    }

    @JvmStatic
    @NotNull
    public static final Response extractResponse(@Nullable JsonValue.Object responseJson) {
        Response response2;
        if (responseJson != null) {
            INSTANCE.formatBody((JsonValue)responseJson);
            response2 = Response.Companion.fromJson(responseJson);
        } else {
            response2 = new Response(0, null, null, null, null, 31, null);
        }
        return response2;
    }

    @JvmStatic
    @NotNull
    public static final Request extractRequest(@Nullable JsonValue.Object requestJson) {
        Request request;
        if (requestJson != null) {
            INSTANCE.formatBody((JsonValue)requestJson);
            request = Request.Companion.fromJson(requestJson);
        } else {
            request = new Request(null, null, null, null, null, null, null, 127, null);
        }
        return request;
    }

    private final void formatBody(JsonValue json2) {
        JsonValue body;
        if (json2 instanceof JsonValue.Object && json2.has("body") && !((body = ((JsonValue.Object)json2).get("body")) instanceof JsonValue.Null) && !(body instanceof JsonValue.StringValue)) {
            ((JsonValue.Object)json2).set("body", (Object)body.serialise());
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final JsonValue.Object transformJson(@NotNull JsonValue.Object pactJson) {
        Intrinsics.checkNotNullParameter((Object)pactJson, (String)"pactJson");
        if (pactJson.has("interactions") && pactJson.get("interactions") instanceof JsonValue.Array) {
            pactJson.set("interactions", (Object)JsonKt.jsonArray((List)JsonValueKt.map((JsonValue)((JsonValue)pactJson.get("interactions").asArray()), (Function1)transformJson.1.INSTANCE)));
        }
        if (pactJson.has("metadata") && pactJson.get("metadata") instanceof JsonValue.Object) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            JsonValue.Object object = pactJson.get("metadata").asObject();
            Intrinsics.checkNotNull((Object)object);
            Iterable iterable = object.getEntries().entrySet();
            String string = "metadata";
            JsonValue.Object object2 = pactJson;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair;
                void entry;
                Map.Entry entry2 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)((String)entry.getKey()), (Object)"pact-specification")) {
                    pair = TuplesKt.to((Object)"pactSpecification", entry.getValue());
                } else {
                    void var10_12 = entry;
                    pair = new Pair(var10_12.getKey(), var10_12.getValue());
                }
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            object2.set(string, (Object)JsonKt.jsonObject((List)collection));
        }
        return pactJson;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonValue.Object transformRequestResponseJson(JsonValue.Object requestJson) {
        JsonValue.Object object;
        block16: {
            block14: {
                void $this$mapTo$iv$iv;
                if (requestJson == null) break block14;
                Iterable $this$map$iv = requestJson.getEntries().entrySet();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String k = (String)entry.getKey();
                    JsonValue v = (JsonValue)entry.getValue();
                    switch (k) {
                        case "responseMatchingRules": {
                            pair = TuplesKt.to((Object)"matchingRules", (Object)v);
                            break;
                        }
                        case "requestMatchingRules": {
                            pair = TuplesKt.to((Object)"matchingRules", (Object)v);
                            break;
                        }
                        case "method": {
                            String string = Json.INSTANCE.toString(v).toUpperCase();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase()");
                            pair = TuplesKt.to((Object)"method", (Object)string);
                            break;
                        }
                        default: {
                            pair = TuplesKt.to((Object)k, (Object)v);
                        }
                    }
                    collection.add(pair);
                }
                object = JsonKt.jsonObject((List)((List)destination$iv$iv));
                break block16;
            }
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonValue.Object, PactSource> loadFile(Object source, Map<String, ? extends Object> options) {
        Object urlSource2;
        if (source instanceof ClosurePactSource) {
            Object object = ((ClosurePactSource)source).getClosure().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.closure.get()");
            return this.loadFile(object, options);
        }
        if (source instanceof FileSource) {
            Pair pair;
            Object object = ((FileSource)source).getFile();
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object = (object3 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2)) instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                JsonValue this_$iv = JsonParser.parseReader((Reader)it);
                boolean $i$f$downcast = false;
                if (!(this_$iv instanceof JsonValue.Object)) {
                    throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
                }
                pair = TuplesKt.to((Object)this_$iv, (Object)source);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            return pair;
        }
        if (source instanceof InputStream || source instanceof Reader || source instanceof File) {
            return this.loadPactFromFile(source);
        }
        if (source instanceof BrokerUrlSource) {
            boolean insecureTLS = (Boolean)Utils.INSTANCE.lookupInMap(options, "insecureTLS", Boolean.TYPE, (Object)false);
            Closeable closeable = (Closeable)HttpClient.newHttpClient$default((HttpClient)HttpClient.INSTANCE, (Object)options.get("authentication"), (URI)new URI(((BrokerUrlSource)source).getPactBrokerUrl()), (int)0, (int)0, (boolean)insecureTLS, (int)12, null).getFirst();
            Throwable throwable = null;
            try {
                Pair<JsonValue.Object, PactSource> it = (Pair<JsonValue.Object, PactSource>)closeable;
                boolean bl = false;
                it = PactReaderKt.loadPactFromUrl((UrlPactSource)source, options, (CloseableHttpClient)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return it;
        }
        if (source instanceof PactBrokerResult) {
            boolean insecureTLS = (Boolean)Utils.INSTANCE.lookupInMap(options, "insecureTLS", Boolean.TYPE, (Object)false);
            Closeable closeable = (Closeable)HttpClient.newHttpClient$default((HttpClient)HttpClient.INSTANCE, (Object)options.get("authentication"), (URI)new URI(((PactBrokerResult)source).getPactBrokerUrl()), (int)0, (int)0, (boolean)insecureTLS, (int)12, null).getFirst();
            Throwable throwable = null;
            try {
                Pair<JsonValue.Object, PactSource> it = (Pair<JsonValue.Object, PactSource>)closeable;
                boolean bl = false;
                it = PactReaderKt.loadPactFromUrl(BrokerUrlSource.Companion.fromResult((PactBrokerResult)source, options, ((PactBrokerResult)source).getTag()), options, (CloseableHttpClient)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return it;
        }
        if (source instanceof URL || source instanceof UrlPactSource) {
            UrlPactSource urlSource2 = source instanceof URL ? (UrlPactSource)new UrlSource(source.toString(), null, 2, null) : (UrlPactSource)source;
            return PactReaderKt.loadPactFromUrl(urlSource2, options, PactReaderKt.newHttpClient(urlSource2.getUrl(), options));
        }
        if (source instanceof String) {
            String string = ((String)source).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            urlSource2 = string;
            if (new Regex("(https?|file)://?.*").matches((CharSequence)urlSource2)) {
                urlSource2 = new UrlSource((String)source, null, 2, null);
                return PactReaderKt.loadPactFromUrl((UrlPactSource)urlSource2, options, PactReaderKt.newHttpClient(((UrlSource)urlSource2).getUrl(), options));
            }
        }
        if (source instanceof String) {
            String string = ((String)source).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            urlSource2 = string;
            if (new Regex("s3://.*").matches((CharSequence)urlSource2)) {
                return this.loadPactFromS3Bucket((String)source);
            }
        }
        if (source instanceof String && StringsKt.startsWith$default((String)((String)source), (String)CLASSPATH_URI_START, (boolean)false, (int)2, null)) {
            String string = ((String)source).substring(10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return this.loadPactFromClasspath(string);
        }
        if (source instanceof String && this.fileExists((String)source)) {
            Pair pair;
            File file = new File((String)source);
            Object object = file;
            Object object4 = Charsets.UTF_8;
            int it = 8192;
            Object bl = object;
            object = (bl = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)bl), (Charset)object4)) instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader((Reader)bl, it);
            object4 = null;
            try {
                BufferedReader it2 = (BufferedReader)object;
                boolean bl2 = false;
                JsonValue this_$iv = JsonParser.parseReader((Reader)it2);
                boolean $i$f$downcast = false;
                if (!(this_$iv instanceof JsonValue.Object)) {
                    throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
                }
                pair = TuplesKt.to((Object)this_$iv, (Object)new FileSource(file, null, 2, null));
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object4);
            }
            return pair;
        }
        try {
            JsonValue this_$iv = JsonParser.parseString((String)source.toString());
            boolean $i$f$downcast = false;
            if (!(this_$iv instanceof JsonValue.Object)) {
                throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
            }
            return TuplesKt.to((Object)this_$iv, (Object)UnknownPactSource.INSTANCE);
        }
        catch (JsonException e) {
            throw new UnsupportedOperationException("Unable to load pact file from '" + source + "' as it is neither a json document, file, input stream, reader or an URL", e);
        }
    }

    static /* synthetic */ Pair loadFile$default(DefaultPactReader defaultPactReader, Object object, Map map, int n, Object object2) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return defaultPactReader.loadFile(object, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonValue.Object, PactSource> loadPactFromFile(Object source) {
        Pair pair;
        Object object = source;
        if (object instanceof InputStream) {
            JsonValue this_$iv = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)source));
            boolean $i$f$downcast = false;
            if (!(this_$iv instanceof JsonValue.Object)) {
                throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
            }
            pair = TuplesKt.to((Object)this_$iv, (Object)InputStreamPactSource.INSTANCE);
        } else if (object instanceof Reader) {
            JsonValue this_$iv = JsonParser.parseReader((Reader)((Reader)source));
            boolean $i$f$downcast = false;
            if (!(this_$iv instanceof JsonValue.Object)) {
                throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
            }
            pair = TuplesKt.to((Object)this_$iv, (Object)ReaderPactSource.INSTANCE);
        } else if (object instanceof File) {
            JsonValue.Object object2;
            Object object3 = (File)source;
            Object object4 = Charsets.UTF_8;
            int n = 8192;
            Object object5 = object3;
            object3 = (object5 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object5), (Charset)object4)) instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n);
            object4 = null;
            try {
                BufferedReader it = (BufferedReader)object3;
                boolean bl = false;
                JsonValue this_$iv = JsonParser.parseReader((Reader)it);
                boolean $i$f$downcast = false;
                if (!(this_$iv instanceof JsonValue.Object)) {
                    throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
                }
                object2 = (JsonValue.Object)this_$iv;
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
            }
            pair = TuplesKt.to((Object)object2, (Object)new FileSource((File)source, null, 2, null));
        } else {
            throw new IllegalArgumentException("loadPactFromFile expects either an InputStream, Reader or File. Got a " + source.getClass().getName() + " instead");
        }
        return pair;
    }

    private final Pair<JsonValue.Object, PactSource> loadPactFromS3Bucket(String source) {
        Class<?> amazonS3URIClass = Class.forName("com.amazonaws.services.s3.AmazonS3URI");
        Object[] objectArray = new Class[]{String.class};
        Constructor<?> constructor = amazonS3URIClass.getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{source};
        Object s3Uri = constructor.newInstance(objectArray);
        String bucket = amazonS3URIClass.getMethod("getBucket", new Class[0]).invoke(s3Uri, new Object[0]).toString();
        String key = amazonS3URIClass.getMethod("getKey", new Class[0]).invoke(s3Uri, new Object[0]).toString();
        if (s3Client == null) {
            Class<?> amazonS3ClientBuilderClass = Class.forName("com.amazonaws.services.s3.AmazonS3ClientBuilder");
            Object object = amazonS3ClientBuilderClass.getMethod("defaultClient", new Class[0]).invoke(null, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"amazonS3ClientBuilderCla\u2026aultClient\").invoke(null)");
            DefaultPactReader.setS3Client(object);
        }
        Class<?> s3ClientClass = Class.forName("com.amazonaws.services.s3.AmazonS3");
        Object[] objectArray2 = new Class[]{String.class, String.class};
        Method method = s3ClientClass.getMethod("getObject", (Class<?>[])objectArray2);
        objectArray2 = new Object[]{bucket, key};
        Object s3Pact = method.invoke(DefaultPactReader.getS3Client(), objectArray2);
        Class<?> s3ObjectClass = Class.forName("com.amazonaws.services.s3.model.S3Object");
        Object object = s3ObjectClass.getMethod("getObjectContent", new Class[0]).invoke(s3Pact, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.io.InputStream");
        InputStream objectContent = (InputStream)object;
        JsonValue this_$iv = JsonParser.parseReader((Reader)new InputStreamReader(objectContent));
        boolean $i$f$downcast = false;
        if (!(this_$iv instanceof JsonValue.Object)) {
            throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
        }
        return TuplesKt.to((Object)this_$iv, (Object)new S3PactSource(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonValue.Object, PactSource> loadPactFromClasspath(String source) {
        Pair<JsonValue.Object, PactSource> pair;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(source);
        if (inputStream == null) {
            throw new IllegalStateException("not found on classpath: " + source);
        }
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            pair = INSTANCE.loadPactFromFile(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return pair;
    }

    private final boolean fileExists(String path) {
        return new File(path).exists();
    }

    public static final /* synthetic */ JsonValue.Object access$transformRequestResponseJson(DefaultPactReader $this, JsonValue.Object requestJson) {
        return $this.transformRequestResponseJson(requestJson);
    }
}

