/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.IHttpPart;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.matchingrules.MatchingRules;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.json.JsonValue;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\fH\u0016J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\b\u00a8\u0006\u0018"}, d2={"Lau/com/dius/pact/core/model/HttpPart;", "Lau/com/dius/pact/core/model/IHttpPart;", "()V", "charset", "Ljava/nio/charset/Charset;", "contentType", "", "jsonBody", "", "setDefaultContentType", "", "setupGenerators", "", "Lau/com/dius/pact/core/model/generators/Generator;", "category", "Lau/com/dius/pact/core/model/generators/Category;", "context", "", "validateForVersion", "", "pactVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "xmlBody", "Companion", "model"})
public abstract class HttpPart
implements IHttpPart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CONTENT_TYPE = "Content-Type";

    @Deprecated(message="use method that returns a content type object", replaceWith=@ReplaceWith(expression="determineContentType", imports={}))
    @Nullable
    public final String contentType() {
        int n;
        CharSequence charSequence;
        Regex regex;
        Object object = this.contentTypeHeader();
        if (object == null || (object = (regex = new Regex("\\s*;\\s*")).split(charSequence = (CharSequence)object, n = 0)) == null || (object = (String)CollectionsKt.first((List)object)) == null) {
            object = this.getBody().getContentType().asString();
        }
        return object;
    }

    public final boolean jsonBody() {
        return this.determineContentType().isJson();
    }

    public final boolean xmlBody() {
        return this.determineContentType().isXml();
    }

    public final void setDefaultContentType(@NotNull String contentType) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Iterable iterable = this.getHeaders().keySet();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!StringsKt.equals((String)it, (String)CONTENT_TYPE, (boolean)true)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if (v0 == null) {
            this.getHeaders().put(CONTENT_TYPE, CollectionsKt.listOf((Object)contentType));
        }
    }

    @Nullable
    public final Charset charset() {
        Charset charset;
        if (this.getBody().isPresent()) {
            charset = this.getBody().getContentType().asCharset();
        } else {
            String contentType = this.contentTypeHeader();
            if (KotlinLanguageSupportKt.isNotEmpty((String)contentType)) {
                String string = contentType;
                Intrinsics.checkNotNull((Object)string);
                charset = new ContentType(string).asCharset();
            } else {
                charset = null;
            }
        }
        return charset;
    }

    @NotNull
    public final List<String> validateForVersion(@NotNull PactSpecVersion pactVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)pactVersion), (String)"pactVersion");
        List errors = new ArrayList();
        errors.addAll((Collection)this.getMatchingRules().validateForVersion(pactVersion));
        errors.addAll((Collection)this.getGenerators().validateForVersion(pactVersion));
        return errors;
    }

    @Override
    @NotNull
    public Map<String, Generator> setupGenerators(@NotNull Category category, @NotNull Map<String, ? extends Object> context) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Map map = this.getGenerators().getCategories().get((Object)category);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map generators = map;
        MatchingRules matchingRules = this.getMatchingRules();
        String string = category.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        Map<String, Generator> matchingRuleGenerators = matchingRules.rulesForCategory(string).generators(context);
        return MapsKt.plus((Map)generators, matchingRuleGenerators);
    }

    @Override
    @NotNull
    public ContentType determineContentType() {
        return IHttpPart.DefaultImpls.determineContentType(this);
    }

    @Override
    @Nullable
    public String contentTypeHeader() {
        return IHttpPart.DefaultImpls.contentTypeHeader(this);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OptionalBody extractBody(@NotNull JsonValue.Object json2, @NotNull ContentType contentType, @NotNull Base64.Decoder decoder) {
        return Companion.extractBody(json2, contentType, decoder);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OptionalBody extractBody(@NotNull JsonValue.Object json2, @NotNull ContentType contentType) {
        return Companion.extractBody(json2, contentType);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lau/com/dius/pact/core/model/HttpPart$Companion;", "Lmu/KLogging;", "()V", "CONTENT_TYPE", "", "decodeBody", "Lau/com/dius/pact/core/model/OptionalBody;", "body", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "decoder", "Ljava/util/Base64$Decoder;", "extractBody", "json", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "model"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OptionalBody extractBody(@NotNull JsonValue.Object json2, @NotNull ContentType contentType, @NotNull Base64.Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            JsonValue b = json2.get("body");
            return b instanceof JsonValue.Null ? OptionalBody.Companion.nullBody() : (b instanceof JsonValue.StringValue ? this.decodeBody(b.toString(), contentType, decoder) : this.decodeBody(b.serialise(), contentType, decoder));
        }

        public static /* synthetic */ OptionalBody extractBody$default(Companion companion, JsonValue.Object object, ContentType contentType, Base64.Decoder decoder, int n, Object object2) {
            if ((n & 4) != 0) {
                Base64.Decoder decoder2 = Base64.getDecoder();
                Intrinsics.checkNotNullExpressionValue((Object)decoder2, (String)"getDecoder()");
                decoder = decoder2;
            }
            return companion.extractBody(object, contentType, decoder);
        }

        private final OptionalBody decodeBody(String body, ContentType contentType, Base64.Decoder decoder) {
            OptionalBody optionalBody;
            if (contentType.isBinaryType() || contentType.isMultipart()) {
                OptionalBody optionalBody2;
                try {
                    optionalBody2 = OptionalBody.Companion.body(decoder.decode(body), contentType);
                }
                catch (IllegalArgumentException ex) {
                    this.getLogger().warn((Throwable)ex, (Function0)new Function0<Object>(contentType){
                        final /* synthetic */ ContentType $contentType;
                        {
                            this.$contentType = $contentType;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Expected body for content type " + this.$contentType + " to be base64 encoded";
                        }
                    });
                    byte[] byArray = body.getBytes(contentType.asCharset());
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    optionalBody2 = OptionalBody.Companion.body(byArray, contentType);
                }
                optionalBody = optionalBody2;
            } else {
                byte[] byArray = body.getBytes(contentType.asCharset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                optionalBody = OptionalBody.Companion.body(byArray, contentType);
            }
            return optionalBody;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OptionalBody extractBody(@NotNull JsonValue.Object json2, @NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return au.com.dius.pact.core.model.HttpPart$Companion.extractBody$default(this, json2, contentType, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

