/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.InvalidPathExpression;
import au.com.dius.pact.core.model.PathToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.iterators.PushbackIterator;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a8\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u000f\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a8\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0001\u001a>\u0010\u0016\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\f\u001a\u00020\u0001\u001a0\u0010\u0018\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0001\u001a8\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a8\u0010\u001a\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"EXP_ALLOWED_SPECIAL_CHARS", "", "PATH_SPECIAL_CHARS", "bracketPath", "", "chars", "Lorg/apache/commons/collections4/iterators/PushbackIterator;", "Lkotlin/collections/IndexedValue;", "", "tokens", "", "Lau/com/dius/pact/core/model/PathToken;", "path", "index", "", "constructPath", "", "constructValidPath", "segment", "rootPath", "identifier", "ch", "indexPath", "parsePath", "pathExp", "pathIdentifier", "stringPath", "validPathCharacter", "", "c", "model"})
public final class PathExpressionsKt {
    @NotNull
    public static final String PATH_SPECIAL_CHARS = "'[].@ \t\n";
    @NotNull
    public static final String EXP_ALLOWED_SPECIAL_CHARS = "-_:#@";

    public static final void stringPath(@NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path, int index) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object id = new String();
        IndexedValue c = new IndexedValue(index, (Object)Character.valueOf(' '));
        while (((Character)c.getValue()).charValue() != '\'' && chars.hasNext()) {
            Object object = chars.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chars.next()");
            c = (IndexedValue)object;
            if (((Character)c.getValue()).charValue() == '\'') {
                if (!(((CharSequence)id).length() == 0)) break;
                throw new InvalidPathExpression("Empty strings are not allowed in path expression \"" + path + "\" at index " + c.getIndex());
            }
            id = (String)id + c.getValue();
        }
        if (((Character)c.getValue()).charValue() != '\'') {
            throw new InvalidPathExpression("Unterminated string in path expression \"" + path + "\" at index " + c.getIndex());
        }
        tokens.add(new PathToken.Field((String)id));
    }

    public static final void indexPath(@NotNull IndexedValue<Character> ch, @NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path) {
        Intrinsics.checkNotNullParameter(ch, (String)"ch");
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String id = new String() + ch.getValue();
        while (chars.hasNext()) {
            IndexedValue c = (IndexedValue)chars.next();
            if (Character.isDigit(((Character)c.getValue()).charValue())) {
                id = id + c.getValue();
                continue;
            }
            if (((Character)c.getValue()).charValue() == ']') {
                chars.pushback((Object)c);
                break;
            }
            throw new InvalidPathExpression("Indexes can only consist of numbers or a \"*\", found \"" + c.getValue() + "\" instead in path expression \"" + path + "\" at index " + c.getIndex());
        }
        tokens.add(new PathToken.Index(Integer.parseInt(id)));
    }

    public static final void identifier(char ch, @NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String id = new String() + ch;
        while (chars.hasNext()) {
            IndexedValue c = (IndexedValue)chars.next();
            if (PathExpressionsKt.validPathCharacter(((Character)c.getValue()).charValue())) {
                id = id + c.getValue();
                continue;
            }
            if (((Character)c.getValue()).charValue() == '.' || ((Character)c.getValue()).charValue() == '\'' || ((Character)c.getValue()).charValue() == '[') {
                chars.pushback((Object)c);
                break;
            }
            throw new InvalidPathExpression("\"" + c.getValue() + "\" is not allowed in an identifier in path expression \"" + path + "\" at index " + c.getIndex());
        }
        tokens.add(new PathToken.Field(id));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void pathIdentifier(@NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path, int index) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!chars.hasNext()) throw new InvalidPathExpression("Expected a path after \".\" in path expression \"" + path + "\" at index " + index);
        IndexedValue ch = (IndexedValue)chars.next();
        if (((Character)ch.getValue()).charValue() == '*') {
            tokens.add(PathToken.Star.INSTANCE);
            return;
        } else {
            if (!PathExpressionsKt.validPathCharacter(((Character)ch.getValue()).charValue())) throw new InvalidPathExpression("Expected either a \"*\" or path identifier in path expression \"" + path + "\" at index " + ch.getIndex());
            PathExpressionsKt.identifier(((Character)ch.getValue()).charValue(), chars, tokens, path);
        }
    }

    public static final boolean validPathCharacter(char c) {
        return Character.isLetterOrDigit(c) || StringsKt.contains$default((CharSequence)EXP_ALLOWED_SPECIAL_CHARS, (char)c, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void bracketPath(@NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path, int index) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!chars.hasNext()) throw new InvalidPathExpression("Expected a \"'\" (single quote) or a digit in path expression \"" + path + "\" after index " + index);
        IndexedValue ch = (IndexedValue)chars.next();
        if (((Character)ch.getValue()).charValue() == '\'') {
            PathExpressionsKt.stringPath(chars, tokens, path, ch.getIndex());
        } else if (Character.isDigit(((Character)ch.getValue()).charValue())) {
            Intrinsics.checkNotNullExpressionValue((Object)ch, (String)"ch");
            PathExpressionsKt.indexPath((IndexedValue<Character>)ch, chars, tokens, path);
        } else if (((Character)ch.getValue()).charValue() == '*') {
            tokens.add(PathToken.StarIndex.INSTANCE);
        } else {
            if (((Character)ch.getValue()).charValue() != ']') throw new InvalidPathExpression("Indexes can only consist of numbers or a \"*\", found \"" + ch.getValue() + "\" instead in path expression \"" + path + "\" at index " + ch.getIndex());
            throw new InvalidPathExpression("Empty bracket expressions are not allowed in path expression \"" + path + "\" at index " + ch.getIndex());
        }
        if (!chars.hasNext()) throw new InvalidPathExpression("Unterminated brackets in path expression \"" + path + "\" at index " + ch.getIndex());
        IndexedValue c = (IndexedValue)chars.next();
        if (((Character)c.getValue()).charValue() == ']') return;
        throw new InvalidPathExpression("Unterminated brackets, found \"" + c.getValue() + "\" instead of \"]\" in path expression \"" + path + "\" at index " + c.getIndex());
    }

    public static final void pathExp(@NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        while (chars.hasNext()) {
            IndexedValue next = (IndexedValue)chars.next();
            char c = ((Character)next.getValue()).charValue();
            if (c == '.') {
                PathExpressionsKt.pathIdentifier(chars, tokens, path, next.getIndex());
                continue;
            }
            if (c == '[') {
                PathExpressionsKt.bracketPath(chars, tokens, path, next.getIndex());
                continue;
            }
            throw new InvalidPathExpression("Expected a \".\" or \"[\" instead of \"" + next.getValue() + "\" in path expression \"" + path + "\" at index " + next.getIndex());
        }
    }

    @NotNull
    public static final List<PathToken> parsePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ArrayList<PathToken.Root> tokens = new ArrayList<PathToken.Root>();
        PushbackIterator chars = new PushbackIterator(CollectionsKt.withIndex((Iterator)((Iterator)StringsKt.iterator((CharSequence)path))));
        if (chars.hasNext()) {
            IndexedValue ch = (IndexedValue)chars.next();
            if (((Character)ch.getValue()).charValue() == '$') {
                tokens.add(PathToken.Root.INSTANCE);
                PathExpressionsKt.pathExp((PushbackIterator<IndexedValue<Character>>)chars, (List<PathToken>)tokens, path);
            } else {
                throw new InvalidPathExpression("Path expression \"" + path + "\" does not start with a root marker \"$\"");
            }
        }
        return tokens;
    }

    @NotNull
    public static final String constructValidPath(@NotNull String segment, @NotNull String rootPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        if (((CharSequence)rootPath).length() == 0) {
            object = segment;
        } else if (((CharSequence)segment).length() == 0) {
            object = rootPath;
        } else {
            boolean bl;
            String root;
            block5: {
                root = StringUtils.stripEnd((String)rootPath, (String)".");
                CharSequence $this$any$iv = segment;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(!PathExpressionsKt.validPathCharacter(it))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            object = bl ? root + "['" + segment + "']" : root + "." + segment;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String constructPath(@NotNull List<String> path) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Iterable iterable = path;
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void segment;
            String string = (String)element$iv;
            String path2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = ((CharSequence)path2).length() == 0 ? segment : PathExpressionsKt.constructValidPath((String)segment, path2);
        }
        return accumulator$iv;
    }
}

