/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.generators;

import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.GeneratorKt;
import au.com.dius.pact.core.model.generators.InvalidGeneratorException;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"DEFAULT_GENERATOR_PACKAGE", "", "logger", "Lmu/KLogger;", "createGenerator", "Lau/com/dius/pact/core/model/generators/Generator;", "type", "generatorJson", "Lau/com/dius/pact/core/support/json/JsonValue;", "findGeneratorClass", "Ljava/lang/Class;", "generatorType", "lookupGenerator", "model"})
public final class GeneratorKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    public static final String DEFAULT_GENERATOR_PACKAGE = "au.com.dius.pact.core.model.generators";

    @Nullable
    public static final Generator lookupGenerator(@Nullable JsonValue generatorJson) {
        Generator generator = null;
        if (generatorJson instanceof JsonValue.Object) {
            try {
                generator = GeneratorKt.createGenerator(Json.INSTANCE.toString(((JsonValue.Object)generatorJson).get("type")), generatorJson);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Throwable)e, (Function0)new Function0<Object>(generatorJson){
                    final /* synthetic */ JsonValue $generatorJson;
                    {
                        this.$generatorJson = $generatorJson;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Could not find generator class for generator config '" + this.$generatorJson + "'";
                    }
                });
            }
            catch (InvalidGeneratorException e) {
                logger.warn((Throwable)e, (Function0)new Function0<Object>(e){
                    final /* synthetic */ InvalidGeneratorException $e;
                    {
                        this.$e = $e;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$e.getMessage();
                    }
                });
            }
        } else {
            logger.warn((Function0)new Function0<Object>(generatorJson){
                final /* synthetic */ JsonValue $generatorJson;
                {
                    this.$generatorJson = $generatorJson;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "'" + this.$generatorJson + "' is not a valid generator JSON value";
                }
            });
        }
        return generator;
    }

    @NotNull
    public static final Generator createGenerator(@NotNull String type, @NotNull JsonValue generatorJson) {
        Pair pair;
        Object[] objectArray42;
        Object object;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)generatorJson, (String)"generatorJson");
        KClass generatorClass = JvmClassMappingKt.getKotlinClass(GeneratorKt.findGeneratorClass(type));
        if (KClasses.getCompanionObject((KClass)generatorClass) != null) {
            KFunction kFunction;
            Object object2 = KClasses.getCompanionObjectInstance((KClass)generatorClass);
            Object object3 = KClasses.getCompanionObject((KClass)generatorClass);
            if (object3 != null && (object3 = KClasses.getDeclaredMemberFunctions((KClass)object3)) != null) {
                Object v2;
                block9: {
                    Object[] objectArray2 = (Object[])object3;
                    object = object2;
                    objectArray42 = objectArray2;
                    for (Object t : objectArray42) {
                        KFunction it = (KFunction)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"fromJson")) continue;
                        v2 = t;
                        break block9;
                    }
                    v2 = null;
                }
                object2 = object;
                kFunction = v2;
            } else {
                kFunction = null;
            }
            pair = TuplesKt.to((Object)object2, kFunction);
        } else if (generatorClass.getObjectInstance() != null) {
            Object[] objectArray;
            block10: {
                Iterable iterable = KClasses.getDeclaredMemberFunctions((KClass)generatorClass);
                object = generatorClass.getObjectInstance();
                Iterable iterable2 = iterable;
                for (Object[] objectArray42 : iterable2) {
                    KFunction it = (KFunction)objectArray42;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"fromJson")) continue;
                    objectArray = objectArray42;
                    break block10;
                }
                objectArray = null;
            }
            pair = TuplesKt.to((Object)object, objectArray);
        } else {
            pair = TuplesKt.to(null, null);
        }
        Pair pair2 = pair;
        Object instance = pair2.component1();
        KFunction fromJson2 = (KFunction)pair2.component2();
        if (fromJson2 != null) {
            objectArray42 = new Object[]{instance, generatorJson};
            Object object4 = fromJson2.call(objectArray42);
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type au.com.dius.pact.core.model.generators.Generator");
            return (Generator)object4;
        }
        throw new InvalidGeneratorException("Could not invoke generator class 'fromJson' for generator config '" + generatorJson + "'");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Class<?> findGeneratorClass(@NotNull String generatorType) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)generatorType, (String)"generatorType");
        String generatorPackages = System.getProperty("pact.generators.packages");
        CharSequence charSequence = generatorPackages;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Class<?> clazz2 = Class.forName("au.com.dius.pact.core.model.generators." + generatorType + "Generator");
            clazz = clazz2;
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"forName(\"$DEFAULT_GENERA\u2026generatorType}Generator\")");
        } else {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)generatorPackages, (String)"generatorPackages");
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)generatorPackages, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List packages = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)DEFAULT_GENERATOR_PACKAGE);
            Class<?> generatorClass = null;
            iterable = packages;
            for (Object t : iterable) {
                boolean bl;
                String it = (String)t;
                boolean bl2 = false;
                try {
                    generatorClass = Class.forName(it + "." + generatorType + "Generator");
                    bl = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = false;
                }
                if (!bl) continue;
            }
            if ((clazz = generatorClass) == null) {
                throw new ClassNotFoundException("No generator found for type '" + generatorType + "'");
            }
        }
        return clazz;
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }
}

