/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.generators;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.InvalidPactException;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.ContentTypeHandler;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.GeneratorKt;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.core.model.generators.GeneratorsKt;
import au.com.dius.pact.core.model.generators.QueryResult;
import au.com.dius.pact.core.support.json.JsonValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B'\u0012 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004J$\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0012J\u001a\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0013\u001a\u00020\u0005H\u0007J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u001eJ\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0005J\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0004J!\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0003J+\u0010#\u001a\u00020\u00002 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0001J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0005J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u0006\u0010+\u001a\u00020'J\u0006\u0010,\u001a\u00020'J\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010.\u001a\u00020/J\t\u00100\u001a\u00020\u0005H\u00d6\u0001J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u0005022\u0006\u00103\u001a\u00020/R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00065"}, d2={"Lau/com/dius/pact/core/model/generators/Generators;", "", "categories", "", "Lau/com/dius/pact/core/model/generators/Category;", "", "Lau/com/dius/pact/core/model/generators/Generator;", "(Ljava/util/Map;)V", "getCategories", "()Ljava/util/Map;", "addCategory", "category", "addGenerator", "key", "generator", "addGenerators", "", "generators", "", "keyPrefix", "applyBodyGenerators", "Lau/com/dius/pact/core/model/OptionalBody;", "body", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "context", "mode", "Lau/com/dius/pact/core/model/generators/GeneratorTestMode;", "applyGenerator", "closure", "Lkotlin/Function2;", "applyRootPrefix", "prefix", "categoryFor", "component1", "copy", "copyWithUpdatedMatcherRootPrefix", "rootPath", "equals", "", "other", "hashCode", "", "isEmpty", "isNotEmpty", "toMap", "pactSpecVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "toString", "validateForVersion", "", "pactVersion", "Companion", "model"})
public final class Generators {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Category, Map<String, Generator>> categories;

    public Generators(@NotNull Map<Category, Map<String, Generator>> categories) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        this.categories = categories;
    }

    public /* synthetic */ Generators(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        this(map);
    }

    @NotNull
    public final Map<Category, Map<String, Generator>> getCategories() {
        return this.categories;
    }

    @JvmOverloads
    @NotNull
    public final Generators addGenerator(@NotNull Category category, @Nullable String key, @NotNull Generator generator) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        if (this.categories.containsKey((Object)category) && this.categories.get((Object)category) != null) {
            Map<String, Generator> map = this.categories.get((Object)category);
            if (map != null) {
                String string = key;
                if (string == null) {
                    string = "";
                }
                map.put(string, generator);
            }
        } else {
            Map<Category, Map<String, Generator>> map = this.categories;
            Object object = new Pair[1];
            String string = key;
            if (string == null) {
                string = "";
            }
            object[0] = TuplesKt.to((Object)string, (Object)generator);
            object = MapsKt.mutableMapOf((Pair[])object);
            map.put(category, (Map<String, Generator>)object);
        }
        return this;
    }

    public static /* synthetic */ Generators addGenerator$default(Generators generators, Category category, String string, Generator generator, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return generators.addGenerator(category, string, generator);
    }

    @JvmOverloads
    @NotNull
    public final Generators addGenerators(@NotNull Generators generators, @NotNull String keyPrefix) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
        Map<Category, Map<String, Generator>> $this$forEach$iv = generators.categories;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Category, Map<String, Generator>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<String, Generator> map;
            Map.Entry<Category, Map<String, Generator>> element$iv;
            Map.Entry<Category, Map<String, Generator>> entry = element$iv = iterator.next();
            boolean bl = false;
            Category category = entry.getKey();
            Map<String, Generator> $this$forEach$iv2 = map = entry.getValue();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, Generator>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Generator> element$iv2;
                Map.Entry<String, Generator> entry2 = element$iv2 = iterator2.next();
                boolean bl2 = false;
                String key = entry2.getKey();
                Generator generator = entry2.getValue();
                this.addGenerator(category, keyPrefix + key, generator);
            }
        }
        return this;
    }

    public static /* synthetic */ Generators addGenerators$default(Generators generators, Generators generators2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return generators.addGenerators(generators2, string);
    }

    @NotNull
    public final Generators addCategory(@NotNull Category category) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        if (!this.categories.containsKey((Object)category)) {
            this.categories.put(category, new LinkedHashMap());
        }
        return this;
    }

    @Nullable
    public final Map<String, Generator> categoryFor(@NotNull Category category) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        return this.categories.get((Object)category);
    }

    public final void applyGenerator(@NotNull Category category, @NotNull GeneratorTestMode mode, @NotNull Function2<? super String, ? super Generator, Unit> closure) {
        Map<String, Generator> categoryValues;
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        if (this.categories.containsKey((Object)category) && this.categories.get((Object)category) != null && (categoryValues = this.categories.get((Object)category)) != null) {
            Companion.applyGenerators(categoryValues, mode, closure);
        }
    }

    @NotNull
    public final OptionalBody applyBodyGenerators(@NotNull OptionalBody body, @NotNull ContentType contentType, @NotNull Map<String, Object> context, @NotNull GeneratorTestMode mode) {
        OptionalBody optionalBody;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        switch (WhenMappings.$EnumSwitchMapping$0[body.getState().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                optionalBody = body;
                break;
            }
            case 4: {
                if (this.categories.get((Object)Category.BODY) != null) {
                    Map<String, Generator> map = this.categories.get((Object)Category.BODY);
                    Intrinsics.checkNotNull(map);
                    optionalBody = Companion.applyBodyGenerators(map, body, contentType, context, mode);
                    break;
                }
                optionalBody = body;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return optionalBody;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmpty() {
        Map.Entry<Category, Map<String, Generator>> it;
        if (this.categories.isEmpty()) return true;
        Map<Category, Map<String, Generator>> $this$all$iv = this.categories;
        boolean $i$f$all = false;
        if ($this$all$iv.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<Category, Map<String, Generator>>> iterator = $this$all$iv.entrySet().iterator();
        do {
            Map.Entry<Category, Map<String, Generator>> element$iv;
            if (!iterator.hasNext()) return true;
            it = element$iv = iterator.next();
            boolean bl = false;
        } while (it.getValue().isEmpty());
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isNotEmpty() {
        boolean bl;
        if (this.categories.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Map<Category, Map<String, Generator>> $this$any$iv = this.categories;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<Category, Map<String, Generator>>> iterator = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<Category, Map<String, Generator>> element$iv;
            if (!iterator.hasNext()) return false;
            Map.Entry<Category, Map<String, Generator>> it = element$iv = iterator.next();
            boolean bl3 = false;
            if (!it.getValue().isEmpty()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toMap(@NotNull PactSpecVersion pactSpecVersion) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        if (pactSpecVersion.compareTo((Enum)PactSpecVersion.V3) < 0) {
            throw new InvalidPactException("Generators are only supported with pact specification version 3+");
        }
        Iterable $this$associate$iv = this.categories.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Pair pair;
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Category key = (Category)((Object)entry.getKey());
            Map value = (Map)entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$1[key.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    String string = key.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Object v = value.get("");
                    Intrinsics.checkNotNull(v);
                    pair = TuplesKt.to((Object)string, ((Generator)v).toMap(pactSpecVersion));
                    break;
                }
                default: {
                    String string;
                    void $this$associateTo$iv$iv2;
                    void $this$associate$iv2;
                    Intrinsics.checkNotNullExpressionValue((Object)key.name().toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Iterable iterable2 = value.entrySet();
                    boolean $i$f$associate2 = false;
                    int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
                    void var19_19 = $this$associate$iv2;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
                    boolean $i$f$associateTo2 = false;
                    for (Object element$iv$iv2 : $this$associateTo$iv$iv2) {
                        Map map2 = destination$iv$iv2;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv2;
                        boolean bl2 = false;
                        String genKey = (String)entry2.getKey();
                        Generator generator = (Generator)entry2.getValue();
                        entry2 = TuplesKt.to((Object)genKey, generator.toMap(pactSpecVersion));
                        map2.put(entry2.getFirst(), entry2.getSecond());
                    }
                    pair = TuplesKt.to((Object)string, (Object)destination$iv$iv2);
                }
            }
            entry = pair;
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyRootPrefix(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Iterable $this$forEach$iv = this.categories.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapKeysTo$iv$iv;
            Map<String, Generator> $this$mapKeys$iv;
            Category category = (Category)((Object)element$iv);
            boolean bl = false;
            Map<Category, Map<String, Generator>> map = this.categories;
            Intrinsics.checkNotNull(this.categories.get((Object)category));
            boolean $i$f$mapKeys = false;
            Map<String, Generator> map2 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Object object;
                void entry;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl2 = false;
                if (StringsKt.startsWith$default((String)((String)entry.getKey()), (String)prefix, (boolean)false, (int)2, null)) {
                    object = (String)entry.getKey();
                } else if (StringsKt.startsWith$default((String)((String)entry.getKey()), (String)"$", (boolean)false, (int)2, null)) {
                    String string = ((String)entry.getKey()).substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    object = prefix + string;
                } else {
                    object = prefix + entry.getKey();
                }
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                String string = object;
                Map map4 = map3;
                boolean bl3 = false;
                Object v = it$iv$iv.getValue();
                map4.put(string, v);
            }
            Map map5 = MapsKt.toMutableMap((Map)destination$iv$iv);
            map.put(category, map5);
        }
    }

    @NotNull
    public final Generators copyWithUpdatedMatcherRootPrefix(@NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Generators generators = this.copy(MapsKt.toMutableMap(this.categories));
        generators.applyRootPrefix(rootPath);
        return generators;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<String> validateForVersion(@NotNull PactSpecVersion pactVersion) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)pactVersion), (String)"pactVersion");
        if (pactVersion.compareTo((Enum)PactSpecVersion.V3) < 0) {
            boolean bl;
            block5: {
                Map<Category, Map<String, Generator>> $this$any$iv = this.categories;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<Category, Map<String, Generator>>> iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Category, Map<String, Generator>> element$iv;
                        Map.Entry<Category, Map<String, Generator>> it = element$iv = iterator.next();
                        boolean bl2 = false;
                        boolean bl3 = !it.getValue().isEmpty();
                        if (!bl3) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                list = CollectionsKt.listOf((Object)"Generators can only be used with Pact specification versions >= V3");
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    public final void addGenerators(@NotNull Category category, @NotNull Map<String, ? extends Generator> generators) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter(generators, (String)"generators");
        this.categories.put(category, MapsKt.toMutableMap(generators));
    }

    @NotNull
    public final Map<Category, Map<String, Generator>> component1() {
        return this.categories;
    }

    @NotNull
    public final Generators copy(@NotNull Map<Category, Map<String, Generator>> categories) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        return new Generators(categories);
    }

    public static /* synthetic */ Generators copy$default(Generators generators, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = generators.categories;
        }
        return generators.copy(map);
    }

    @NotNull
    public String toString() {
        return "Generators(categories=" + this.categories + ")";
    }

    public int hashCode() {
        return ((Object)this.categories).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Generators)) {
            return false;
        }
        Generators generators = (Generators)other;
        return Intrinsics.areEqual(this.categories, generators.categories);
    }

    @JvmOverloads
    @NotNull
    public final Generators addGenerator(@NotNull Category category, @NotNull Generator generator) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        return Generators.addGenerator$default(this, category, null, generator, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Generators addGenerators(@NotNull Generators generators) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        return Generators.addGenerators$default(this, generators, null, 2, null);
    }

    public Generators() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Generators fromJson(@Nullable JsonValue json2) {
        return Companion.fromJson(json2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J<\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001c"}, d2={"Lau/com/dius/pact/core/model/generators/Generators$Companion;", "Lmu/KLogging;", "()V", "applyBodyGenerators", "Lau/com/dius/pact/core/model/OptionalBody;", "generators", "", "", "Lau/com/dius/pact/core/model/generators/Generator;", "body", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "context", "", "", "mode", "Lau/com/dius/pact/core/model/generators/GeneratorTestMode;", "applyGenerators", "", "closure", "Lkotlin/Function2;", "findContentTypeHandler", "Lau/com/dius/pact/core/model/generators/ContentTypeHandler;", "fromJson", "Lau/com/dius/pact/core/model/generators/Generators;", "json", "Lau/com/dius/pact/core/support/json/JsonValue;", "getUpdatedContentType", "model"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Generators fromJson(@Nullable JsonValue json2) {
            Generators generators = new Generators(null, 1, null);
            if (json2 instanceof JsonValue.Object) {
                Map $this$forEach$iv = ((JsonValue.Object)json2).getEntries();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                block5: while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    JsonValue generatorJson = (JsonValue)entry.getValue();
                    try {
                        String string = key;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                        String string2 = string.toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                        Category category = Category.valueOf(string2);
                        switch (WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (generatorJson.has("type")) {
                                    Generator generator = GeneratorKt.lookupGenerator((JsonValue)generatorJson.asObject());
                                    if (generator != null) {
                                        Generators.addGenerator$default(generators, category, null, generator, 2, null);
                                        break;
                                    }
                                    Companion.getLogger().warn((Function0)new Function0<Object>(generatorJson){
                                        final /* synthetic */ JsonValue $generatorJson;
                                        {
                                            this.$generatorJson = $generatorJson;
                                            super(0);
                                        }

                                        @Nullable
                                        public final Object invoke() {
                                            return "Ignoring invalid generator config '" + this.$generatorJson + "'";
                                        }
                                    });
                                    break;
                                }
                                Companion.getLogger().warn((Function0)new Function0<Object>(generatorJson){
                                    final /* synthetic */ JsonValue $generatorJson;
                                    {
                                        this.$generatorJson = $generatorJson;
                                        super(0);
                                    }

                                    @Nullable
                                    public final Object invoke() {
                                        return "Ignoring invalid generator config '" + this.$generatorJson + ".obj'";
                                    }
                                });
                                break;
                            }
                            default: {
                                Object object = generatorJson.asObject();
                                if (object == null || (object = object.getEntries()) == null) continue block5;
                                Object $this$forEach$iv2 = object;
                                boolean $i$f$forEach2 = false;
                                Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
                                while (iterator2.hasNext()) {
                                    Map.Entry element$iv2;
                                    Map.Entry entry2 = element$iv2 = iterator2.next();
                                    boolean bl2 = false;
                                    String generatorKey = (String)entry2.getKey();
                                    JsonValue generatorValue = (JsonValue)entry2.getValue();
                                    if (generatorValue instanceof JsonValue.Object && generatorValue.has("type")) {
                                        Generator generator = GeneratorKt.lookupGenerator(generatorValue);
                                        if (generator != null) {
                                            generators.addGenerator(category, generatorKey, generator);
                                            continue;
                                        }
                                        Companion.getLogger().warn((Function0)new Function0<Object>(generatorValue){
                                            final /* synthetic */ JsonValue $generatorValue;
                                            {
                                                this.$generatorValue = $generatorValue;
                                                super(0);
                                            }

                                            @Nullable
                                            public final Object invoke() {
                                                return "Ignoring invalid generator config '" + this.$generatorValue + "'";
                                            }
                                        });
                                        continue;
                                    }
                                    Companion.getLogger().warn((Function0)new Function0<Object>(generatorKey, generatorValue){
                                        final /* synthetic */ String $generatorKey;
                                        final /* synthetic */ JsonValue $generatorValue;
                                        {
                                            this.$generatorKey = $generatorKey;
                                            this.$generatorValue = $generatorValue;
                                            super(0);
                                        }

                                        @Nullable
                                        public final Object invoke() {
                                            return "Ignoring invalid generator config '" + this.$generatorKey + " -> " + this.$generatorValue + "'";
                                        }
                                    });
                                }
                                continue block5;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Companion.getLogger().warn((Throwable)e, (Function0)new Function0<Object>(key){
                            final /* synthetic */ String $key;
                            {
                                this.$key = $key;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Ignoring generator with invalid category '" + this.$key + "'";
                            }
                        });
                    }
                }
            }
            return generators;
        }

        public final void applyGenerators(@NotNull Map<String, ? extends Generator> generators, @NotNull GeneratorTestMode mode, @NotNull Function2<? super String, ? super Generator, Unit> closure) {
            Intrinsics.checkNotNullParameter(generators, (String)"generators");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter(closure, (String)"closure");
            for (Map.Entry<String, ? extends Generator> entry : generators.entrySet()) {
                String key = entry.getKey();
                Generator generator = entry.getValue();
                if (!generator.correspondsToMode(mode)) continue;
                closure.invoke((Object)key, (Object)generator);
            }
        }

        @NotNull
        public final OptionalBody applyBodyGenerators(@NotNull Map<String, ? extends Generator> generators, @NotNull OptionalBody body, @NotNull ContentType contentType, @NotNull Map<String, Object> context, @NotNull GeneratorTestMode mode) {
            Intrinsics.checkNotNullParameter(generators, (String)"generators");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            ContentTypeHandler handler = this.findContentTypeHandler(contentType);
            Object object = handler;
            if (object == null || (object = object.processBody(body, (Function1<? super QueryResult, Unit>)((Function1)new Function1<QueryResult, Unit>(generators, mode, handler, context){
                final /* synthetic */ Map<String, Generator> $generators;
                final /* synthetic */ GeneratorTestMode $mode;
                final /* synthetic */ ContentTypeHandler $handler;
                final /* synthetic */ Map<String, Object> $context;
                {
                    this.$generators = $generators;
                    this.$mode = $mode;
                    this.$handler = $handler;
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull QueryResult bodyResult) {
                    Intrinsics.checkNotNullParameter((Object)bodyResult, (String)"bodyResult");
                    for (Map.Entry<String, Generator> entry : this.$generators.entrySet()) {
                        String key = entry.getKey();
                        Generator generator = entry.getValue();
                        if (!generator.correspondsToMode(this.$mode)) continue;
                        this.$handler.applyKey(bodyResult, key, generator, this.$context);
                    }
                }
            }))) == null) {
                object = body;
            }
            return object;
        }

        private final ContentTypeHandler findContentTypeHandler(ContentType contentType) {
            ContentType supertype;
            ContentType updatedContentType = this.getUpdatedContentType(contentType);
            ContentTypeHandler typeHandler = GeneratorsKt.getContentTypeHandlers().get(updatedContentType.getBaseType());
            return typeHandler != null ? typeHandler : ((supertype = updatedContentType.getSupertype()) != null ? this.findContentTypeHandler(supertype) : null);
        }

        private final ContentType getUpdatedContentType(ContentType contentType) {
            if (contentType.isJson()) {
                return ContentType.Companion.getJSON();
            }
            return contentType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Category.values().length];
                try {
                    nArray[Category.STATUS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Category.PATH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Category.METHOD.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OptionalBody.State.values().length];
            try {
                nArray[OptionalBody.State.EMPTY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionalBody.State.MISSING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionalBody.State.NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionalBody.State.PRESENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Category.values().length];
            try {
                nArray[Category.METHOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Category.PATH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Category.STATUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

