/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.matchingrules;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.GeneratorKt;
import au.com.dius.pact.core.model.generators.NullGenerator;
import au.com.dius.pact.core.model.matchingrules.ArrayContainsMatcher;
import au.com.dius.pact.core.model.matchingrules.BooleanMatcher;
import au.com.dius.pact.core.model.matchingrules.ContentTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.DateMatcher;
import au.com.dius.pact.core.model.matchingrules.EachKeyMatcher;
import au.com.dius.pact.core.model.matchingrules.EachValueMatcher;
import au.com.dius.pact.core.model.matchingrules.EqualsIgnoreOrderMatcher;
import au.com.dius.pact.core.model.matchingrules.EqualsMatcher;
import au.com.dius.pact.core.model.matchingrules.HttpStatus;
import au.com.dius.pact.core.model.matchingrules.IncludeMatcher;
import au.com.dius.pact.core.model.matchingrules.InvalidMatcherJsonException;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleCategory;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleGroup;
import au.com.dius.pact.core.model.matchingrules.MaxEqualsIgnoreOrderMatcher;
import au.com.dius.pact.core.model.matchingrules.MaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinEqualsIgnoreOrderMatcher;
import au.com.dius.pact.core.model.matchingrules.MinMaxEqualsIgnoreOrderMatcher;
import au.com.dius.pact.core.model.matchingrules.MinMaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.NotEmptyMatcher;
import au.com.dius.pact.core.model.matchingrules.NullMatcher;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.SemverMatcher;
import au.com.dius.pact.core.model.matchingrules.StatusCodeMatcher;
import au.com.dius.pact.core.model.matchingrules.TimeMatcher;
import au.com.dius.pact.core.model.matchingrules.TimestampMatcher;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import au.com.dius.pact.core.model.matchingrules.ValuesMatcher;
import au.com.dius.pact.core.model.matchingrules.expressions.MatchingRuleDefinition;
import au.com.dius.pact.core.model.matchingrules.expressions.ValueType;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.core.support.json.JsonValueKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0018\u001a\u00020\u0016H&R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lau/com/dius/pact/core/model/matchingrules/MatchingRule;", "", "attributes", "", "", "Lau/com/dius/pact/core/support/json/JsonValue;", "getAttributes", "()Ljava/util/Map;", "name", "getName", "()Ljava/lang/String;", "buildGenerators", "", "Lau/com/dius/pact/core/model/generators/Generator;", "context", "canMatch", "", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "hasGenerators", "toMap", "spec", "Lau/com/dius/pact/core/model/PactSpecVersion;", "validateForVersion", "pactVersion", "Companion", "model"})
public interface MatchingRule {
    @NotNull
    public static final Companion Companion = au.com.dius.pact.core.model.matchingrules.MatchingRule$Companion.$$INSTANCE;

    @NotNull
    public Map<String, Object> toMap(@NotNull PactSpecVersion var1);

    public boolean canMatch(@NotNull ContentType var1);

    @NotNull
    public List<String> validateForVersion(@NotNull PactSpecVersion var1);

    @NotNull
    public List<Generator> buildGenerators(@NotNull Map<String, ? extends Object> var1);

    public boolean hasGenerators();

    @NotNull
    public String getName();

    @NotNull
    public Map<String, JsonValue> getAttributes();

    @JvmStatic
    @NotNull
    public static MatchingRule fromJson(@NotNull JsonValue json2) {
        return Companion.fromJson(json2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lau/com/dius/pact/core/model/matchingrules/MatchingRule$Companion;", "Lmu/KLogging;", "()V", "DATE", "", "MATCH", "MAX", "MIN", "REGEX", "TIME", "TIMESTAMP", "create", "Lau/com/dius/pact/core/model/matchingrules/MatchingRule;", "type", "values", "Lau/com/dius/pact/core/support/json/JsonValue;", "fromJson", "json", "ruleForIgnoreOrder", "map", "ruleForType", "model"})
    public static final class Companion
    extends KLogging {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String MATCH = "match";
        @NotNull
        private static final String MIN = "min";
        @NotNull
        private static final String MAX = "max";
        @NotNull
        private static final String REGEX = "regex";
        @NotNull
        private static final String TIMESTAMP = "timestamp";
        @NotNull
        private static final String TIME = "time";
        @NotNull
        private static final String DATE = "date";

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MatchingRule fromJson(@NotNull JsonValue json2) {
            MatchingRule matchingRule;
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            if (json2.isObject()) {
                JsonValue this_$iv = json2;
                boolean $i$f$downcast = false;
                if (!(this_$iv instanceof JsonValue.Object)) {
                    throw new UnsupportedOperationException("Can not downcast " + this_$iv.getName() + " to type " + Reflection.getOrCreateKotlinClass(JsonValue.Object.class));
                }
                JsonValue.Object j = (JsonValue.Object)this_$iv;
                if (j.has(MATCH)) {
                    matchingRule = this.create(Json.INSTANCE.toString(j.get(MATCH)), (JsonValue)j);
                } else if (j.has(REGEX)) {
                    String string = j.get(REGEX).asString();
                    Intrinsics.checkNotNull((Object)string);
                    matchingRule = new RegexMatcher(string, null, 2, null);
                } else if (j.has(MIN)) {
                    Number number = j.get(MIN).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    matchingRule = new MinTypeMatcher(number.intValue());
                } else if (j.has(MAX)) {
                    Number number = j.get(MAX).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    matchingRule = new MaxTypeMatcher(number.intValue());
                } else if (j.has(TIMESTAMP)) {
                    String string = j.get(TIMESTAMP).asString();
                    Intrinsics.checkNotNull((Object)string);
                    matchingRule = new TimestampMatcher(string);
                } else if (j.has(TIME)) {
                    String string = j.get(TIME).asString();
                    Intrinsics.checkNotNull((Object)string);
                    matchingRule = new TimeMatcher(string);
                } else if (j.has(DATE)) {
                    String string = j.get(DATE).asString();
                    Intrinsics.checkNotNull((Object)string);
                    matchingRule = new DateMatcher(string);
                } else {
                    MatchingRuleGroup.Companion.getLogger().warn((Function0)new Function0<Object>(j){
                        final /* synthetic */ JsonValue.Object $j;
                        {
                            this.$j = $j;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Unrecognised matcher definition " + this.$j + ", defaulting to equality matching";
                        }
                    });
                    matchingRule = EqualsMatcher.INSTANCE;
                }
            } else {
                MatchingRuleGroup.Companion.getLogger().warn((Function0)new Function0<Object>(json2){
                    final /* synthetic */ JsonValue $json;
                    {
                        this.$json = $json;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unrecognised matcher definition " + this.$json + ", defaulting to equality matching";
                    }
                });
                matchingRule = EqualsMatcher.INSTANCE;
            }
            return matchingRule;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MatchingRule create(@NotNull String type, @NotNull JsonValue values) {
            MatchingRule matchingRule;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            this.getLogger().trace((Function0)new Function0<Object>(type, values){
                final /* synthetic */ String $type;
                final /* synthetic */ JsonValue $values;
                {
                    this.$type = $type;
                    this.$values = $values;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "MatchingRule.create(" + this.$type + ", " + this.$values + ")";
                }
            });
            switch (type) {
                case "regex": {
                    String string = values.get((Object)REGEX).asString();
                    Intrinsics.checkNotNull((Object)string);
                    matchingRule = new RegexMatcher(string, null, 2, null);
                    break;
                }
                case "equality": {
                    matchingRule = EqualsMatcher.INSTANCE;
                    break;
                }
                case "null": {
                    matchingRule = NullMatcher.INSTANCE;
                    break;
                }
                case "include": {
                    matchingRule = new IncludeMatcher(values.get((Object)"value").toString());
                    break;
                }
                case "type": {
                    matchingRule = this.ruleForType(values);
                    break;
                }
                case "number": {
                    matchingRule = new NumberTypeMatcher(NumberTypeMatcher.NumberType.NUMBER);
                    break;
                }
                case "integer": {
                    matchingRule = new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER);
                    break;
                }
                case "decimal": {
                    matchingRule = new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL);
                    break;
                }
                case "real": {
                    MatchingRuleGroup.Companion.getLogger().warn((Function0)create.2.INSTANCE);
                    matchingRule = new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL);
                    break;
                }
                case "min": {
                    Number number = values.get((Object)MIN).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    matchingRule = new MinTypeMatcher(number.intValue());
                    break;
                }
                case "max": {
                    Number number = values.get((Object)MAX).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    matchingRule = new MaxTypeMatcher(number.intValue());
                    break;
                }
                case "datetime": 
                case "timestamp": {
                    matchingRule = values.has("format") ? new TimestampMatcher(values.get((Object)"format").toString()) : (values.has(TIMESTAMP) ? new TimestampMatcher(values.get((Object)TIMESTAMP).toString()) : new TimestampMatcher(null, 1, null));
                    break;
                }
                case "time": {
                    matchingRule = values.has("format") ? new TimeMatcher(values.get((Object)"format").toString()) : (values.has(TIME) ? new TimeMatcher(values.get((Object)TIME).toString()) : new TimeMatcher(null, 1, null));
                    break;
                }
                case "date": {
                    matchingRule = values.has("format") ? new DateMatcher(values.get((Object)"format").toString()) : (values.has(DATE) ? new DateMatcher(values.get((Object)DATE).toString()) : new DateMatcher(null, 1, null));
                    break;
                }
                case "values": {
                    matchingRule = ValuesMatcher.INSTANCE;
                    break;
                }
                case "ignore-order": {
                    matchingRule = this.ruleForIgnoreOrder(values);
                    break;
                }
                case "content-type": 
                case "contentType": {
                    matchingRule = new ContentTypeMatcher(values.get((Object)"value").toString());
                    break;
                }
                case "array-contains": 
                case "arrayContains": {
                    Collection destination$iv$iv;
                    JsonValue variants = values.get((Object)"variants");
                    if (variants instanceof JsonValue.Array) {
                        void $this$mapIndexedTo$iv$iv;
                        Iterable $this$mapIndexed$iv = ((JsonValue.Array)variants).getValues();
                        boolean $i$f$mapIndexed = false;
                        Iterable iterable = $this$mapIndexed$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                        boolean $i$f$mapIndexedTo = false;
                        int index$iv$iv = 0;
                        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                            Map map;
                            MatchingRuleCategory matchingRuleCategory;
                            Integer n;
                            void variant;
                            int n2;
                            if ((n2 = index$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            JsonValue jsonValue = (JsonValue)item$iv$iv;
                            int n3 = n2;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            if (variant instanceof JsonValue.Object) {
                                Number number = ((JsonValue.Object)variant).get("index").asNumber();
                                Intrinsics.checkNotNull((Object)number);
                                n = number.intValue();
                                matchingRuleCategory = new MatchingRuleCategory("body", null, 2, null).fromJson(((JsonValue.Object)variant).get("rules"));
                                Object object = ((JsonValue.Object)variant).get("generators").asObject();
                                if (object != null && (object = object.getEntries()) != null) {
                                    Map map2;
                                    void $this$mapValuesTo$iv$iv;
                                    void $this$mapValues$iv;
                                    Object object2 = object;
                                    MatchingRuleCategory matchingRuleCategory2 = matchingRuleCategory;
                                    Integer n4 = n;
                                    boolean $i$f$mapValues = false;
                                    void var21_26 = $this$mapValues$iv;
                                    Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                                    boolean $i$f$mapValuesTo = false;
                                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                                    boolean $i$f$associateByTo = false;
                                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                                        void it;
                                        void it$iv$iv;
                                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                                        Map map3 = destination$iv$iv2;
                                        boolean bl2 = false;
                                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                                        Object k = it$iv$iv.getKey();
                                        map2 = map3;
                                        boolean bl3 = false;
                                        Generator generator = GeneratorKt.lookupGenerator((JsonValue)it.getValue());
                                        if (generator == null) {
                                            generator = NullGenerator.INSTANCE;
                                        }
                                        Generator generator2 = generator;
                                        map2.put(k, generator2);
                                    }
                                    map2 = destination$iv$iv2;
                                    n = n4;
                                    matchingRuleCategory = matchingRuleCategory2;
                                    map = map2;
                                } else {
                                    map = MapsKt.emptyMap();
                                }
                            } else {
                                void index;
                                throw new InvalidMatcherJsonException("Array contains matchers: variant " + (int)index + " is incorrectly formed");
                            }
                            Map map4 = map;
                            MatchingRuleCategory matchingRuleCategory3 = matchingRuleCategory;
                            Integer n5 = n;
                            collection.add(new Triple((Object)n5, (Object)matchingRuleCategory3, (Object)map4));
                        }
                    } else {
                        throw new InvalidMatcherJsonException("Array contains matchers should have a list of variants");
                    }
                    List list = (List)destination$iv$iv;
                    matchingRule = new ArrayContainsMatcher(list);
                    break;
                }
                case "boolean": {
                    matchingRule = BooleanMatcher.INSTANCE;
                    break;
                }
                case "status-code": 
                case "statusCode": {
                    StatusCodeMatcher statusCodeMatcher;
                    if (values.get((Object)"status").isArray()) {
                        JsonValue.Array array = values.get((Object)"status").asArray();
                        Intrinsics.checkNotNull((Object)array);
                        JsonValue.Array asArray = array;
                        statusCodeMatcher = new StatusCodeMatcher(HttpStatus.StatusCodes, JsonValueKt.map((JsonValue)((JsonValue)asArray), (Function1)create.4.INSTANCE));
                    } else {
                        statusCodeMatcher = new StatusCodeMatcher(HttpStatus.Companion.fromJson(values.get((Object)"status")), null, 2, null);
                    }
                    matchingRule = statusCodeMatcher;
                    break;
                }
                case "not-empty": 
                case "notEmpty": {
                    matchingRule = NotEmptyMatcher.INSTANCE;
                    break;
                }
                case "semver": {
                    matchingRule = SemverMatcher.INSTANCE;
                    break;
                }
                case "each-key": 
                case "eachKey": {
                    Generator generator = values.has("generator") ? GeneratorKt.lookupGenerator(values.get((Object)"generator")) : null;
                    String string = Json.INSTANCE.toString(values.get((Object)"value"));
                    JsonValue.Array array = values.get((Object)"rules").asArray();
                    Intrinsics.checkNotNull((Object)array);
                    MatchingRuleDefinition definition2 = new MatchingRuleDefinition(string, ValueType.Unknown, JsonValueKt.map((JsonValue)((JsonValue)array), (Function1)create.definition.1.INSTANCE), generator);
                    matchingRule = new EachKeyMatcher(definition2);
                    break;
                }
                case "eachValue": 
                case "each-value": {
                    Generator generator = values.has("generator") ? GeneratorKt.lookupGenerator(values.get((Object)"generator")) : null;
                    String string = Json.INSTANCE.toString(values.get((Object)"value"));
                    JsonValue.Array array = values.get((Object)"rules").asArray();
                    Intrinsics.checkNotNull((Object)array);
                    MatchingRuleDefinition definition3 = new MatchingRuleDefinition(string, ValueType.Unknown, JsonValueKt.map((JsonValue)((JsonValue)array), (Function1)create.definition.2.INSTANCE), generator);
                    matchingRule = new EachValueMatcher(definition3);
                    break;
                }
                default: {
                    MatchingRuleGroup.Companion.getLogger().warn((Function0)new Function0<Object>(values){
                        final /* synthetic */ JsonValue $values;
                        {
                            this.$values = $values;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Unrecognised matcher " + this.$values.get((Object)"match") + ", defaulting to equality matching";
                        }
                    });
                    matchingRule = EqualsMatcher.INSTANCE;
                }
            }
            return matchingRule;
        }

        private final MatchingRule ruleForType(JsonValue map) {
            MatchingRule matchingRule;
            if (map instanceof JsonValue.Object) {
                if (map.has(MIN) && map.has(MAX)) {
                    Number number = ((JsonValue.Object)map).get(MIN).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    int n = number.intValue();
                    Number number2 = ((JsonValue.Object)map).get(MAX).asNumber();
                    Intrinsics.checkNotNull((Object)number2);
                    matchingRule = new MinMaxTypeMatcher(n, number2.intValue());
                } else if (map.has(MIN)) {
                    Number number = ((JsonValue.Object)map).get(MIN).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    matchingRule = new MinTypeMatcher(number.intValue());
                } else if (map.has(MAX)) {
                    Number number = ((JsonValue.Object)map).get(MAX).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    matchingRule = new MaxTypeMatcher(number.intValue());
                } else {
                    matchingRule = TypeMatcher.INSTANCE;
                }
            } else {
                matchingRule = TypeMatcher.INSTANCE;
            }
            return matchingRule;
        }

        private final MatchingRule ruleForIgnoreOrder(JsonValue map) {
            MatchingRule matchingRule;
            if (map instanceof JsonValue.Object) {
                if (map.has(MIN) && map.has(MAX)) {
                    Number number = ((JsonValue.Object)map).get(MIN).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    int n = number.intValue();
                    Number number2 = ((JsonValue.Object)map).get(MAX).asNumber();
                    Intrinsics.checkNotNull((Object)number2);
                    matchingRule = new MinMaxEqualsIgnoreOrderMatcher(n, number2.intValue());
                } else if (map.has(MIN)) {
                    Number number = ((JsonValue.Object)map).get(MIN).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    matchingRule = new MinEqualsIgnoreOrderMatcher(number.intValue());
                } else if (map.has(MAX)) {
                    Number number = ((JsonValue.Object)map).get(MAX).asNumber();
                    Intrinsics.checkNotNull((Object)number);
                    matchingRule = new MaxEqualsIgnoreOrderMatcher(number.intValue());
                } else {
                    matchingRule = EqualsIgnoreOrderMatcher.INSTANCE;
                }
            } else {
                matchingRule = EqualsIgnoreOrderMatcher.INSTANCE;
            }
            return matchingRule;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean canMatch(@NotNull MatchingRule $this, @NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return false;
        }

        @NotNull
        public static List<Generator> buildGenerators(@NotNull MatchingRule $this, @NotNull Map<String, ? extends Object> context) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            return CollectionsKt.emptyList();
        }

        public static boolean hasGenerators(@NotNull MatchingRule $this) {
            return false;
        }
    }
}

