/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.pactbroker;

import au.com.dius.pact.core.pactbroker.HalClient;
import au.com.dius.pact.core.pactbroker.IHalClient;
import au.com.dius.pact.core.pactbroker.InvalidHalResponse;
import au.com.dius.pact.core.pactbroker.InvalidNavigationRequest;
import au.com.dius.pact.core.pactbroker.NotFoundHalResponse;
import au.com.dius.pact.core.pactbroker.PactBrokerClientConfig;
import au.com.dius.pact.core.pactbroker.RequestFailedException;
import au.com.dius.pact.core.support.Auth;
import au.com.dius.pact.core.support.HttpClient;
import au.com.dius.pact.core.support.HttpClientUtils;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.core.support.json.JsonValueKt;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 f2\u00020\u0001:\u0001fB-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u00101\u001a\u0004\u0018\u00010+H\u0016J.\u00102\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0002J \u00105\u001a\u0012\u0012\u0004\u0012\u00020+\u0012\b\u0012\u000607j\u0002`8062\u0006\u00109\u001a\u00020\u0003H\u0016J(\u00105\u001a\u0012\u0012\u0004\u0012\u00020+\u0012\b\u0012\u000607j\u0002`8062\u0006\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;H\u0016J$\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J,\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00032\u001a\u0010A\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050BH\u0016J\n\u0010C\u001a\u0004\u0018\u00010DH\u0016J \u0010E\u001a\u0012\u0012\u0004\u0012\u00020F\u0012\b\u0012\u000607j\u0002`8062\u0006\u00109\u001a\u00020\u0003H\u0016J(\u0010E\u001a\u0012\u0012\u0004\u0012\u00020F\u0012\b\u0012\u000607j\u0002`8062\u0006\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;H\u0016J6\u0010G\u001a\u0004\u0018\u00010\u00062\u0006\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010\u00032\u001a\u0010A\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060KJ(\u0010L\u001a\u0012\u0012\u0004\u0012\u00020F\u0012\b\u0012\u000607j\u0002`8062\u0006\u0010M\u001a\u00020I2\u0006\u00109\u001a\u00020\u0003H\u0002J$\u0010N\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0006\u0010O\u001a\u00020?J\u001d\u0010P\u001a\u0002HQ\"\b\b\u0000\u0010Q*\u00020R2\u0006\u0010S\u001a\u0002HQ\u00a2\u0006\u0002\u0010TJ\u0012\u0010U\u001a\u0004\u0018\u00010\u00032\u0006\u0010V\u001a\u00020\u0003H\u0016J\b\u0010W\u001a\u00020\u0001H\u0016J\u0010\u0010W\u001a\u00020\u00012\u0006\u0010=\u001a\u00020\u0003H\u0016J$\u0010W\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010=\u001a\u00020\u0003H\u0016J\"\u0010X\u001a\u00020\u00032\u0006\u0010Y\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005J(\u0010Z\u001a\u0012\u0012\u0004\u0012\u00020;\u0012\b\u0012\u000607j\u0002`8062\u0006\u0010[\u001a\u00020\u00032\u0006\u0010J\u001a\u00020\u0003H\u0016Jb\u0010Z\u001a\u0012\u0012\u0004\u0012\u00020;\u0012\b\u0012\u000607j\u0002`8062\u0006\u0010[\u001a\u00020\u00032\u0006\u0010J\u001a\u00020\u000328\u0010\\\u001a4\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b^\u0012\b\bV\u0012\u0004\b\b(_\u0012\u0013\u0012\u00110I\u00a2\u0006\f\b^\u0012\b\bV\u0012\u0004\b\b(M\u0012\u0004\u0012\u00020;\u0018\u00010]H\u0016J<\u0010Z\u001a\u0012\u0012\u0004\u0012\u00020+\u0012\b\u0012\u000607j\u0002`8062\u0006\u0010=\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010`\u001a\u00020\u0003H\u0016J*\u0010a\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\b\u0012\u000607j\u0002`8062\u0006\u0010[\u001a\u00020b2\u0006\u0010`\u001a\u00020\u0003H\u0016J>\u0010a\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\b\u0012\u000607j\u0002`8062\u0006\u0010=\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010`\u001a\u00020\u0003H\u0016J\b\u0010c\u001a\u00020\u0015H\u0016J\u0010\u0010d\u001a\u00020\u00012\u0006\u0010e\u001a\u00020+H\u0016J\u001e\u0010d\u001a\u00020\u00012\u0014\u0010e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000b\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010\u0011\"\u0004\b)\u0010\u0013R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lau/com/dius/pact/core/pactbroker/HalClient;", "Lau/com/dius/pact/core/pactbroker/IHalClient;", "baseUrl", "", "options", "", "", "config", "Lau/com/dius/pact/core/pactbroker/PactBrokerClientConfig;", "(Ljava/lang/String;Ljava/util/Map;Lau/com/dius/pact/core/pactbroker/PactBrokerClientConfig;)V", "getBaseUrl", "()Ljava/lang/String;", "getConfig", "()Lau/com/dius/pact/core/pactbroker/PactBrokerClientConfig;", "defaultHeaders", "", "getDefaultHeaders", "()Ljava/util/Map;", "setDefaultHeaders", "(Ljava/util/Map;)V", "httpClient", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "getHttpClient", "()Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "setHttpClient", "(Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;)V", "httpContext", "Lorg/apache/hc/client5/http/protocol/HttpClientContext;", "getHttpContext", "()Lorg/apache/hc/client5/http/protocol/HttpClientContext;", "setHttpContext", "(Lorg/apache/hc/client5/http/protocol/HttpClientContext;)V", "lastUrl", "getLastUrl", "setLastUrl", "(Ljava/lang/String;)V", "maxPublishRetries", "", "getOptions$annotations", "()V", "getOptions", "setOptions", "pathInfo", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "getPathInfo", "()Lau/com/dius/pact/core/support/json/JsonValue$Object;", "setPathInfo", "(Lau/com/dius/pact/core/support/json/JsonValue$Object;)V", "publishRetryInterval", "currentDoc", "encodePathParameter", "key", "value", "fetch", "Lau/com/dius/pact/core/support/Result;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "path", "encodePath", "", "fetchLink", "link", "forAll", "", "linkName", "closure", "Ljava/util/function/Consumer;", "getAuth", "Lau/com/dius/pact/core/support/Auth;", "getJson", "Lau/com/dius/pact/core/support/json/JsonValue;", "handleFailure", "resp", "Lorg/apache/hc/core5/http/ClassicHttpResponse;", "body", "Ljava/util/function/BiFunction;", "handleHalResponse", "response", "hrefForLink", "initPathInfo", "initialiseRequest", "Method", "Lorg/apache/hc/core5/http/HttpMessage;", "method", "(Lorg/apache/hc/core5/http/HttpMessage;)Lorg/apache/hc/core5/http/HttpMessage;", "linkUrl", "name", "navigate", "parseLinkUrl", "href", "postJson", "url", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "status", "json", "putJson", "Ljava/net/URI;", "setupHttpClient", "withDocContext", "docAttributes", "Companion", "pactbroker"})
public class HalClient
implements IHalClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private Map<String, ? extends Object> options;
    @NotNull
    private final PactBrokerClientConfig config;
    @Nullable
    private CloseableHttpClient httpClient;
    @Nullable
    private HttpClientContext httpContext;
    @Nullable
    private JsonValue.Object pathInfo;
    @Nullable
    private String lastUrl;
    @NotNull
    private Map<String, String> defaultHeaders;
    private int maxPublishRetries;
    private int publishRetryInterval;
    @NotNull
    public static final String ROOT = "/";
    @NotNull
    public static final String LINKS = "_links";
    @NotNull
    public static final String PREEMPTIVE_AUTHENTICATION = "pact.pactbroker.httpclient.usePreemptiveAuthentication";
    @NotNull
    private static final Regex URL_TEMPLATE_REGEX = new Regex("\\{(\\w+)}");

    @JvmOverloads
    public HalClient(@NotNull String baseUrl, @NotNull Map<String, ? extends Object> options, @NotNull PactBrokerClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.baseUrl = baseUrl;
        this.options = options;
        this.config = config;
        this.defaultHeaders = new LinkedHashMap();
        this.maxPublishRetries = 5;
        this.publishRetryInterval = 3000;
        if (this.options.containsKey("halClient")) {
            Object object = this.options.get("halClient");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Map halClient2 = (Map)object;
            Integer n = halClient2.getOrDefault("maxPublishRetries", this.maxPublishRetries);
            Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Int");
            this.maxPublishRetries = n;
            Integer n2 = halClient2.getOrDefault("publishRetryInterval", this.publishRetryInterval);
            Intrinsics.checkNotNull((Object)n2, (String)"null cannot be cast to non-null type kotlin.Int");
            this.publishRetryInterval = n2;
        }
    }

    public /* synthetic */ HalClient(String string, Map map, PactBrokerClientConfig pactBrokerClientConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, map, pactBrokerClientConfig);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final Map<String, Object> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.options = map;
    }

    @Deprecated(message="Move use of options to PactBrokerClientConfig")
    public static /* synthetic */ void getOptions$annotations() {
    }

    @NotNull
    public final PactBrokerClientConfig getConfig() {
        return this.config;
    }

    @Nullable
    public final CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public final void setHttpClient(@Nullable CloseableHttpClient closeableHttpClient) {
        this.httpClient = closeableHttpClient;
    }

    @Nullable
    public final HttpClientContext getHttpContext() {
        return this.httpContext;
    }

    public final void setHttpContext(@Nullable HttpClientContext httpClientContext) {
        this.httpContext = httpClientContext;
    }

    @Nullable
    public final JsonValue.Object getPathInfo() {
        return this.pathInfo;
    }

    public final void setPathInfo(@Nullable JsonValue.Object object) {
        this.pathInfo = object;
    }

    @Nullable
    public final String getLastUrl() {
        return this.lastUrl;
    }

    public final void setLastUrl(@Nullable String string) {
        this.lastUrl = string;
    }

    @NotNull
    public final Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public final void setDefaultHeaders(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.defaultHeaders = map;
    }

    @NotNull
    public final <Method extends HttpMessage> Method initialiseRequest(@NotNull Method method) {
        Intrinsics.checkNotNullParameter(method, (String)"method");
        Map<String, String> $this$forEach$iv = this.defaultHeaders;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            method.addHeader(key, (Object)value);
        }
        return method;
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.postJson(url, body, null);
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body, @Nullable Function2<? super Integer, ? super ClassicHttpResponse, Boolean> handler) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Companion.getLogger().debug((Function0)new Function0<Object>(url, body){
            final /* synthetic */ String $url;
            final /* synthetic */ String $body;
            {
                this.$url = $url;
                this.$body = $body;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Posting JSON to " + this.$url + "\n" + this.$body;
            }
        });
        CloseableHttpClient client = this.setupHttpClient();
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Object>(this, url, body, client, handler){
            final /* synthetic */ HalClient this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ String $body;
            final /* synthetic */ CloseableHttpClient $client;
            final /* synthetic */ Function2<Integer, ClassicHttpResponse, Boolean> $handler;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                this.$body = $body;
                this.$client = $client;
                this.$handler = $handler;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                HttpPost httpPost = (HttpPost)this.this$0.initialiseRequest((HttpMessage)new HttpPost(this.$url));
                httpPost.addHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.toString());
                httpPost.setEntity((HttpEntity)new StringEntity(this.$body, ContentType.APPLICATION_JSON));
                return this.$client.execute((ClassicHttpRequest)httpPost, (HttpContext)this.this$0.getHttpContext(), arg_0 -> postJson.2.invoke$lambda$0(this.$handler, arg_0));
            }

            private static final Object invoke$lambda$0(Function2 $handler, ClassicHttpResponse it) {
                Object object;
                HalClient.Companion.getLogger().debug((Function0)new Function0<Object>(it){
                    final /* synthetic */ ClassicHttpResponse $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Got response " + this.$it.getCode() + " " + this.$it.getReasonPhrase();
                    }
                });
                HalClient.Companion.getLogger().debug((Function0)new Function0<Object>(it){
                    final /* synthetic */ ClassicHttpResponse $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        String string;
                        Object object = this.$it.getEntity();
                        if (object != null && (object = object.getContent()) != null) {
                            Object object2 = object;
                            Charset charset = Charsets.UTF_8;
                            string = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object2, charset));
                        } else {
                            string = null;
                        }
                        return "Response body: " + string;
                    }
                });
                if ($handler != null) {
                    Integer n = it.getCode();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    object = $handler.invoke((Object)n, (Object)it);
                } else if (it.getCode() >= 300) {
                    HalClient.Companion.getLogger().error((Function0)new Function0<Object>(it){
                        final /* synthetic */ ClassicHttpResponse $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "PUT JSON request failed with status " + this.$it.getCode() + " " + this.$it.getReasonPhrase();
                        }
                    });
                    object = new Result.Err((Object)new RequestFailedException(it.getCode(), it.getEntity() != null ? EntityUtils.toString((HttpEntity)it.getEntity()) : null, null, 4, null));
                } else {
                    object = true;
                }
                return object;
            }
        }));
    }

    @NotNull
    public CloseableHttpClient setupHttpClient() {
        if (this.httpClient == null) {
            if (this.options.containsKey("authentication") && !(this.options.get("authentication") instanceof Auth) && !(this.options.get("authentication") instanceof List)) {
                Companion.getLogger().warn((Function0)setupHttpClient.1.INSTANCE);
            }
            URI uri = new URI(this.baseUrl);
            Pair result = HttpClient.INSTANCE.newHttpClient(this.options.get("authentication"), uri, this.maxPublishRetries, this.publishRetryInterval, this.config.getInsecureTLS());
            this.httpClient = (CloseableHttpClient)result.getFirst();
            if (Intrinsics.areEqual((Object)System.getProperty(PREEMPTIVE_AUTHENTICATION), (Object)"true")) {
                HttpHost targetHost = new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
                Companion.getLogger().warn((Function0)new Function0<Object>(targetHost){
                    final /* synthetic */ HttpHost $targetHost;
                    {
                        this.$targetHost = $targetHost;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Using preemptive basic authentication with the pact broker at " + this.$targetHost;
                    }
                });
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicAuth);
                HttpClientContext httpClientContext = this.httpContext = HttpClientContext.create();
                Intrinsics.checkNotNull((Object)httpClientContext);
                httpClientContext.setCredentialsProvider((CredentialsProvider)result.getSecond());
                HttpClientContext httpClientContext2 = this.httpContext;
                Intrinsics.checkNotNull((Object)httpClientContext2);
                httpClientContext2.setAuthCache((AuthCache)authCache);
            }
        }
        CloseableHttpClient closeableHttpClient = this.httpClient;
        Intrinsics.checkNotNull((Object)closeableHttpClient);
        return closeableHttpClient;
    }

    @Override
    @NotNull
    public IHalClient navigate() throws InvalidNavigationRequest {
        Result<JsonValue.Object, Exception> result = this.fetch(ROOT);
        if (result instanceof Result.Ok) {
            this.pathInfo = (JsonValue.Object)((Result.Ok)result).getValue();
        } else if (result instanceof Result.Err) {
            Companion.getLogger().warn((Function0)navigate.1.INSTANCE);
            throw new InvalidNavigationRequest("Failed to fetch the root HAL document", (Throwable)((Result.Err)result).getError());
        }
        return this;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull Map<String, ? extends Object> options, @NotNull String link) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        JsonValue.Object object = this.pathInfo;
        if (object == null) {
            object = (JsonValue.Object)this.fetch(ROOT).unwrap();
        }
        this.pathInfo = object;
        this.pathInfo = this.fetchLink(link, options);
        return this;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return this.navigate(MapsKt.emptyMap(), link);
    }

    @Override
    @Nullable
    public JsonValue.Object currentDoc() {
        return this.pathInfo;
    }

    @Override
    @NotNull
    public Result<JsonValue.Object, Exception> fetch(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.fetch(path, true);
    }

    @Override
    @NotNull
    public Result<JsonValue.Object, Exception> fetch(@NotNull String path, boolean encodePath) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.lastUrl = path;
        Companion.getLogger().debug((Function0)new Function0<Object>(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Fetching: " + this.$path;
            }
        });
        Result result2 = this.getJson(path, encodePath);
        if (result2 instanceof Result.Ok) {
            result = (JsonValue)((Result.Ok)result2).getValue() instanceof JsonValue.Object ? (Result)new Result.Ok(((Result.Ok)result2).getValue()) : (Result)new Result.Err((Object)new RuntimeException("Expected a JSON document, but found a " + ((Result.Ok)result2).getValue()));
        } else if (result2 instanceof Result.Err) {
            result = result2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IHalClient withDocContext(@NotNull Map<String, ? extends Object> docAttributes) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(docAttributes, (String)"docAttributes");
        JsonValue.Object links = new JsonValue.Object(null, 1, null);
        Iterable iterable = docAttributes.entrySet();
        String string = LINKS;
        JsonValue.Object object = links;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsonValue jsonValue;
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            if (it.getValue() instanceof Map) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                Iterable iterable2 = ((Map)v).entrySet();
                Object k2 = k;
                boolean $i$f$map2 = false;
                void var15_17 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void entry2;
                    Map.Entry entry3 = (Map.Entry)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(Intrinsics.areEqual(entry2.getKey(), (Object)"href") ? TuplesKt.to((Object)String.valueOf(entry2.getKey()), (Object)String.valueOf(entry2.getValue())) : TuplesKt.to((Object)String.valueOf(entry2.getKey()), entry2.getValue()));
                }
                k = k2;
                jsonValue = (JsonValue)JsonKt.jsonObject((List)((List)destination$iv$iv2));
            } else {
                jsonValue = (JsonValue)JsonValue.Null.INSTANCE;
            }
            collection.add(TuplesKt.to(k, (Object)jsonValue));
        }
        collection = (List)destination$iv$iv;
        object.set(string, (Object)JsonKt.jsonObject((List)collection));
        this.pathInfo = links;
        return this;
    }

    @Override
    @NotNull
    public IHalClient withDocContext(@NotNull JsonValue.Object docAttributes) {
        Intrinsics.checkNotNullParameter((Object)docAttributes, (String)"docAttributes");
        this.pathInfo = docAttributes;
        return this;
    }

    @Override
    @NotNull
    public Result<JsonValue, Exception> getJson(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getJson(path, true);
    }

    @Override
    @NotNull
    public Result<JsonValue, Exception> getJson(@NotNull String path, boolean encodePath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.setupHttpClient();
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Object>(this, path, encodePath){
            final /* synthetic */ HalClient this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ boolean $encodePath;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                this.$encodePath = $encodePath;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                HttpGet httpGet = (HttpGet)this.this$0.initialiseRequest((HttpMessage)new HttpGet(HttpClientUtils.INSTANCE.buildUrl(this.this$0.getBaseUrl(), this.$path, this.$encodePath)));
                httpGet.addHeader("Content-Type", (Object)"application/json");
                httpGet.addHeader("Accept", (Object)"application/hal+json, application/json");
                CloseableHttpClient closeableHttpClient = this.this$0.getHttpClient();
                Intrinsics.checkNotNull((Object)closeableHttpClient);
                return closeableHttpClient.execute((ClassicHttpRequest)httpGet, (HttpContext)this.this$0.getHttpContext(), arg_0 -> getJson.1.invoke$lambda$0(this.this$0, this.$path, arg_0));
            }

            private static final Result invoke$lambda$0(HalClient this$0, String $path, ClassicHttpResponse it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return HalClient.access$handleHalResponse(this$0, it, $path);
            }
        }));
    }

    @Override
    @Nullable
    public Auth getAuth() {
        Object authentication = this.options.get("authentication");
        return authentication instanceof Auth ? (Auth)authentication : null;
    }

    private final Result<JsonValue, Exception> handleHalResponse(ClassicHttpResponse response, String path) {
        Result result;
        if (response.getCode() < 300) {
            ContentType contentType = ContentType.parseLenient((CharSequence)response.getEntity().getContentType());
            Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"contentType");
            if (HttpClientUtils.INSTANCE.isJsonResponse(contentType)) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(response.entity)");
                result = (Result)new Result.Ok((Object)JsonParser.parseString((String)string));
            } else {
                result = (Result)new Result.Err((Object)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got '" + contentType + "'"));
            }
        } else {
            Result.Err err;
            if (response.getCode() == 404) {
                err = new Result.Err((Object)new NotFoundHalResponse("No HAL document found at path '" + path + "'"));
            } else {
                String body = response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity()) : null;
                err = new Result.Err((Object)new RequestFailedException(response.getCode(), body, "Request to path '" + path + "' failed with response " + response.getCode()));
            }
            result = (Result)err;
        }
        return result;
    }

    private final JsonValue.Object fetchLink(String link, Map<String, ? extends Object> options) {
        String href = this.hrefForLink(link, options);
        return (JsonValue.Object)this.fetch(href, false).unwrap();
    }

    private final String hrefForLink(String link, Map<String, ? extends Object> options) {
        if (JsonValueKt.get((JsonValue.Object)this.pathInfo, (Object)LINKS).isNull()) {
            throw new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got a response with no '_links'. URL: '" + this.baseUrl + "', LINK: '" + link + "'");
        }
        JsonValue links = JsonValueKt.get((JsonValue.Object)this.pathInfo, (Object)LINKS);
        if (links instanceof JsonValue.Object) {
            if (!links.has(link)) {
                throw new InvalidHalResponse("Link '" + link + "' was not found in the response, only the following links where found: " + ((JsonValue.Object)links).getEntries().keySet() + ". URL: '" + this.baseUrl + "', LINK: '" + link + "'");
            }
            JsonValue linkData = ((JsonValue.Object)links).get(link);
            if (linkData instanceof JsonValue.Array) {
                if (options.containsKey("name")) {
                    String string;
                    JsonValue linkByName2 = ((JsonValue.Array)linkData).find((Function1)new Function1<JsonValue, Boolean>(options){
                        final /* synthetic */ Map<String, Object> $options;
                        {
                            this.$options = $options;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull JsonValue it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return it instanceof JsonValue.Object && Intrinsics.areEqual((Object)((JsonValue.Object)it).get("name"), (Object)this.$options.get("name"));
                        }
                    });
                    if (linkByName2 instanceof JsonValue.Object && ((JsonValue.Object)linkByName2).get("templated").isBoolean()) {
                        string = this.parseLinkUrl(((JsonValue.Object)linkByName2).get("href").toString(), options);
                    } else if (linkByName2 instanceof JsonValue.Object) {
                        string = Json.INSTANCE.toString(((JsonValue.Object)linkByName2).get("href"));
                    } else {
                        throw new InvalidNavigationRequest("Link '" + link + "' does not have an entry with name '" + options.get("name") + "'. URL: '" + this.baseUrl + "', LINK: '" + link + "'", null, 2, null);
                    }
                    return string;
                }
                throw new InvalidNavigationRequest("Link '" + link + "' has multiple entries. You need to filter by the link name. URL: '" + this.baseUrl + "', LINK: '" + link + "'", null, 2, null);
            }
            if (linkData instanceof JsonValue.Object) {
                return linkData.has("templated") && ((JsonValue.Object)linkData).get("templated").isBoolean() ? this.parseLinkUrl(Json.INSTANCE.toString(((JsonValue.Object)linkData).get("href")), options) : Json.INSTANCE.toString(((JsonValue.Object)linkData).get("href"));
            }
            throw new InvalidHalResponse("Expected link in map form in the response, but found: " + linkData + ". URL: '" + this.baseUrl + "', LINK: '" + link + "'");
        }
        throw new InvalidHalResponse("Expected a map of links in the response, but found: " + links + ". URL: '" + this.baseUrl + "', LINK: '" + link + "'");
    }

    @NotNull
    public final String parseLinkUrl(@NotNull String href, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Object result = "";
        MatchResult match = Regex.find$default((Regex)URL_TEMPLATE_REGEX, (CharSequence)href, (int)0, (int)2, null);
        int index = 0;
        while (match != null) {
            int start = match.getRange().getFirst() - 1;
            if (start >= index) {
                result = (String)result + StringsKt.substring((String)href, (IntRange)new IntRange(index, start));
            }
            index = match.getRange().getLast() + 1;
            String key = (String)match.getDestructured().getMatch().getGroupValues().get(1);
            result = (String)result + this.encodePathParameter(options, key, match.getValue());
            match = URL_TEMPLATE_REGEX.find((CharSequence)href, index);
        }
        if (index < href.length()) {
            String string = href.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            result = (String)result + string;
        }
        return result;
    }

    private final String encodePathParameter(Map<String, ? extends Object> options, String key, String value) {
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        Object object = options.get(key);
        if (object == null || (object = object.toString()) == null) {
            object = value;
        }
        return escaper.escape((String)object);
    }

    public final void initPathInfo() {
        JsonValue.Object object = this.pathInfo;
        if (object == null) {
            object = (JsonValue.Object)this.fetch(ROOT).unwrap();
        }
        this.pathInfo = object;
    }

    @Nullable
    public final Object handleFailure(@NotNull ClassicHttpResponse resp, @Nullable String body, @NotNull BiFunction<String, String, Object> closure) {
        Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        if (resp.getEntity().getContentType() != null) {
            ContentType contentType = ContentType.parseLenient((CharSequence)resp.getEntity().getContentType());
            Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"contentType");
            if (HttpClientUtils.INSTANCE.isJsonResponse(contentType)) {
                Object error = "";
                if (KotlinLanguageSupportKt.isNotEmpty((String)body)) {
                    String string = body;
                    Intrinsics.checkNotNull((Object)string);
                    JsonValue jsonBody = JsonParser.parseString((String)string);
                    if (jsonBody.has("errors")) {
                        JsonValue errors = jsonBody.get((Object)"errors");
                        if (errors instanceof JsonValue.Array) {
                            error = " - " + CollectionsKt.joinToString$default((Iterable)((JsonValue.Array)errors).getValues(), (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.1.INSTANCE, (int)30, null);
                        } else if (errors instanceof JsonValue.Object) {
                            error = " - " + CollectionsKt.joinToString$default((Iterable)((JsonValue.Object)errors).getEntries().entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.2.INSTANCE, (int)30, null);
                        }
                    }
                }
                return closure.apply("FAILED", resp.getCode() + " " + resp.getReasonPhrase() + (String)error);
            }
            return closure.apply("FAILED", resp.getCode() + " " + resp.getReasonPhrase() + " - " + body);
        }
        return closure.apply("FAILED", resp.getCode() + " " + resp.getReasonPhrase() + " - " + body);
    }

    @Override
    @Nullable
    public String linkUrl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.pathInfo != null) {
            JsonValue.Object object = this.pathInfo;
            Intrinsics.checkNotNull((Object)object);
            if (object.has(LINKS)) {
                JsonValue linkData;
                JsonValue.Object object2 = this.pathInfo;
                Intrinsics.checkNotNull((Object)object2);
                JsonValue links = object2.get(LINKS);
                if (links instanceof JsonValue.Object && links.has(name) && (linkData = ((JsonValue.Object)links).get(name)) instanceof JsonValue.Object && linkData.has("href")) {
                    return String.valueOf(Json.INSTANCE.fromJson(((JsonValue.Object)linkData).get("href")));
                }
            }
        }
        return null;
    }

    @Override
    public void forAll(@NotNull String linkName, @NotNull Consumer<Map<String, Object>> closure) {
        Intrinsics.checkNotNullParameter((Object)linkName, (String)"linkName");
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        this.initPathInfo();
        JsonValue.Object object = this.pathInfo;
        Intrinsics.checkNotNull((Object)object);
        JsonValue links = object.get(LINKS);
        if (links instanceof JsonValue.Object && links.has(linkName)) {
            JsonValue matchingLink = ((JsonValue.Object)links).get(linkName);
            if (matchingLink instanceof JsonValue.Array) {
                Iterable $this$forEach$iv = ((JsonValue.Array)matchingLink).getValues();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonValue it = (JsonValue)element$iv;
                    boolean bl = false;
                    closure.accept(Companion.asMap(it.asObject()));
                }
            } else {
                closure.accept(Companion.asMap(matchingLink.asObject()));
            }
        }
    }

    @Override
    @NotNull
    public Result<String, Exception> putJson(@NotNull String link, @NotNull Map<String, ? extends Object> options, @NotNull String json2) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        String href = this.hrefForLink(link, options);
        URI url = HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, href, false);
        return this.putJson(url, json2);
    }

    @Override
    @NotNull
    public Result<String, Exception> putJson(@NotNull URI url, @NotNull String json2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        HttpPut httpPut = (HttpPut)this.initialiseRequest((HttpMessage)new HttpPut(url));
        httpPut.addHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.toString());
        httpPut.setEntity((HttpEntity)new StringEntity(json2, ContentType.APPLICATION_JSON));
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Object>(this, httpPut){
            final /* synthetic */ HalClient this$0;
            final /* synthetic */ HttpPut $httpPut;
            {
                this.this$0 = $receiver;
                this.$httpPut = $httpPut;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                CloseableHttpClient closeableHttpClient = this.this$0.getHttpClient();
                Intrinsics.checkNotNull((Object)closeableHttpClient);
                return closeableHttpClient.execute((ClassicHttpRequest)this.$httpPut, (HttpContext)this.this$0.getHttpContext(), putJson.1::invoke$lambda$0);
            }

            private static final Object invoke$lambda$0(ClassicHttpResponse it) {
                String string;
                if (it.getCode() < 300) {
                    string = it.getEntity() != null ? EntityUtils.toString((HttpEntity)it.getEntity()) : null;
                } else {
                    HalClient.Companion.getLogger().error((Function0)new Function0<Object>(it){
                        final /* synthetic */ ClassicHttpResponse $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "PUT JSON request failed with status " + this.$it.getCode() + " " + this.$it.getReasonPhrase();
                        }
                    });
                    string = new Result.Err((Object)new RequestFailedException(it.getCode(), it.getEntity() != null ? EntityUtils.toString((HttpEntity)it.getEntity()) : null, null, 4, null));
                }
                return string;
            }
        }));
    }

    @Override
    @NotNull
    public Result<JsonValue.Object, Exception> postJson(@NotNull String link, @NotNull Map<String, ? extends Object> options, @NotNull String json2) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        String href = this.hrefForLink(link, options);
        HttpPost http = (HttpPost)this.initialiseRequest((HttpMessage)new HttpPost(HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, href, false)));
        http.addHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.toString());
        http.addHeader("Accept", (Object)"application/hal+json, application/json");
        http.setEntity((HttpEntity)new StringEntity(json2, ContentType.APPLICATION_JSON));
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Object>(this, http, href){
            final /* synthetic */ HalClient this$0;
            final /* synthetic */ HttpPost $http;
            final /* synthetic */ String $href;
            {
                this.this$0 = $receiver;
                this.$http = $http;
                this.$href = $href;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                CloseableHttpClient closeableHttpClient = this.this$0.getHttpClient();
                Intrinsics.checkNotNull((Object)closeableHttpClient);
                return closeableHttpClient.execute((ClassicHttpRequest)this.$http, (HttpContext)this.this$0.getHttpContext(), arg_0 -> postJson.3.invoke$lambda$0(this.this$0, this.$href, arg_0));
            }

            private static final Result invoke$lambda$0(HalClient this$0, String $href, ClassicHttpResponse it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$href, (String)"$href");
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return HalClient.access$handleHalResponse(this$0, it, $href);
            }
        }));
    }

    @JvmOverloads
    public HalClient(@NotNull String baseUrl, @NotNull PactBrokerClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(baseUrl, null, config, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Object> asMap(@Nullable JsonValue.Object jsonObject) {
        return Companion.asMap(jsonObject);
    }

    public static final /* synthetic */ Result access$handleHalResponse(HalClient $this, ClassicHttpResponse response, String path) {
        return $this.handleHalResponse(response, path);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lau/com/dius/pact/core/pactbroker/HalClient$Companion;", "Lmu/KLogging;", "()V", "LINKS", "", "PREEMPTIVE_AUTHENTICATION", "ROOT", "URL_TEMPLATE_REGEX", "Lkotlin/text/Regex;", "getURL_TEMPLATE_REGEX", "()Lkotlin/text/Regex;", "asMap", "", "", "jsonObject", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "pactbroker"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @NotNull
        public final Regex getURL_TEMPLATE_REGEX() {
            return URL_TEMPLATE_REGEX;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Map<String, Object> asMap(@Nullable JsonValue.Object jsonObject) {
            Map map;
            Object object = jsonObject;
            if (object != null && (object = object.getEntries()) != null && (object = object.entrySet()) != null) {
                void $this$associateTo$iv$iv;
                Iterable $this$associate$iv = (Iterable)object;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to(entry.getKey(), (Object)Json.INSTANCE.fromJson((JsonValue)entry.getValue()));
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                map = destination$iv$iv;
            } else {
                map = MapsKt.emptyMap();
            }
            return map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

