/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import java.util.Properties;

public class EnvironmentConfig
extends EnvironmentMutableConfig {
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig();
    private boolean createUP = true;
    private boolean checkpointUP = true;
    private boolean allowCreate = false;
    private boolean txnReadCommitted = false;
    private ExceptionListener exceptionListener = null;

    public EnvironmentConfig() {
    }

    public EnvironmentConfig(Properties properties) throws IllegalArgumentException {
        super(properties);
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setLockTimeout(long timeout) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, EnvironmentParams.LOCK_TIMEOUT, Long.toString(timeout), this.validateParams);
    }

    public long getLockTimeout() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.LOCK_TIMEOUT);
        long timeout = 0L;
        try {
            timeout = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad value for timeout:" + e.getMessage());
        }
        return timeout;
    }

    public void setReadOnly(boolean readOnly) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_RDONLY, Boolean.toString(readOnly), this.validateParams);
    }

    public boolean getReadOnly() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_RDONLY);
        return Boolean.valueOf(val);
    }

    public void setTransactional(boolean transactional) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_INIT_TXN, Boolean.toString(transactional), this.validateParams);
    }

    public boolean getTransactional() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_INIT_TXN);
        return Boolean.valueOf(val);
    }

    public void setLocking(boolean locking) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_INIT_LOCKING, Boolean.toString(locking), this.validateParams);
    }

    public boolean getLocking() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_INIT_LOCKING);
        return Boolean.valueOf(val);
    }

    public void setTxnTimeout(long timeout) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, EnvironmentParams.TXN_TIMEOUT, Long.toString(timeout), this.validateParams);
    }

    public long getTxnTimeout() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.TXN_TIMEOUT);
        long timeout = 0L;
        try {
            timeout = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad value for timeout:" + e.getMessage());
        }
        return timeout;
    }

    public void setTxnSerializableIsolation(boolean txnSerializableIsolation) {
        DbConfigManager.setVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION, Boolean.toString(txnSerializableIsolation), this.validateParams);
    }

    public boolean getTxnSerializableIsolation() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION);
        return Boolean.valueOf(val);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    void setTxnReadCommitted(boolean txnReadCommitted) {
        this.txnReadCommitted = txnReadCommitted;
    }

    boolean getTxnReadCommitted() {
        return this.txnReadCommitted;
    }

    public void setConfigParam(String paramName, String value) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(this.props, paramName, value, false, this.validateParams, false);
    }

    void setCreateUP(boolean createUP) {
        this.createUP = createUP;
    }

    boolean getCreateUP() {
        return this.createUP;
    }

    void setCheckpointUP(boolean checkpointUP) {
        this.checkpointUP = checkpointUP;
    }

    boolean getCheckpointUP() {
        return this.checkpointUP;
    }

    EnvironmentConfig cloneConfig() {
        try {
            return (EnvironmentConfig)this.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public String toString() {
        return "allowCreate=" + this.allowCreate + "\n" + super.toString();
    }
}

