/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UtilizationTracker {
    private EnvironmentImpl env;
    private Cleaner cleaner;
    private long activeFile;
    private long bytesSinceActivate;
    private volatile Map files;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilizationTracker(EnvironmentImpl env) throws DatabaseException {
        this(env, env.getCleaner());
    }

    UtilizationTracker(EnvironmentImpl env, Cleaner cleaner) throws DatabaseException {
        if (!$assertionsDisabled && cleaner == null) {
            throw new AssertionError();
        }
        this.env = env;
        this.cleaner = cleaner;
        this.files = new HashMap();
        this.activeFile = -1L;
    }

    public EnvironmentImpl getEnvironment() {
        return this.env;
    }

    public long evictMemory() throws DatabaseException {
        if (!this.cleaner.trackDetail) {
            return 0L;
        }
        if (!this.env.isOpen()) {
            return 0L;
        }
        MemoryBudget mb = this.env.getMemoryBudget();
        long totalEvicted = 0L;
        long totalBytes = 0L;
        int largestBytes = 0;
        TrackedFileSummary bestFile = null;
        Iterator i = this.files.values().iterator();
        while (i.hasNext()) {
            TrackedFileSummary tfs = (TrackedFileSummary)i.next();
            int mem = tfs.getMemorySize();
            totalBytes += (long)mem;
            if (mem <= largestBytes || !tfs.getAllowFlush()) continue;
            largestBytes = mem;
            bestFile = tfs;
        }
        if (bestFile != null && totalBytes > mb.getTrackerBudget()) {
            this.env.getUtilizationProfile().flushFileSummary(bestFile);
            totalEvicted += (long)largestBytes;
        }
        return totalEvicted;
    }

    public void activateCleaner() {
        this.env.getCleaner().wakeup();
        this.bytesSinceActivate = 0L;
    }

    public Collection getTrackedFiles() {
        return this.files.values();
    }

    public TrackedFileSummary getTrackedFile(long fileNum) {
        return (TrackedFileSummary)this.files.get(new Long(fileNum));
    }

    public boolean countNewLogEntry(long lsn, LogEntryType type, int size) {
        TrackedFileSummary file = this.getFile(DbLsn.getFileNumber(lsn));
        ++file.totalCount;
        file.totalSize += size;
        if (type.isNodeType()) {
            if (this.inArray(type, LogEntryType.IN_TYPES)) {
                ++file.totalINCount;
                file.totalINSize += size;
            } else {
                ++file.totalLNCount;
                file.totalLNSize += size;
            }
        }
        this.bytesSinceActivate += (long)size;
        return this.bytesSinceActivate >= this.env.getCleaner().cleanerBytesInterval;
    }

    public void countObsoleteNode(long lsn, LogEntryType type, int size) {
        TrackedFileSummary file = this.getFile(DbLsn.getFileNumber(lsn));
        this.countOneNode(file, type, size);
        long offset = DbLsn.getFileOffset(lsn);
        if (offset != 0L) {
            file.trackObsolete(offset);
        }
    }

    public void countObsoleteNodeInexact(long lsn, LogEntryType type, int size) {
        TrackedFileSummary file = this.getFile(DbLsn.getFileNumber(lsn));
        this.countOneNode(file, type, size);
    }

    private void countOneNode(TrackedFileSummary file, LogEntryType type, int size) {
        if (type == null || type.isNodeType()) {
            if (type == null || !this.inArray(type, LogEntryType.IN_TYPES)) {
                ++file.obsoleteLNCount;
                if (size > 0) {
                    file.obsoleteLNSize += size;
                    ++file.obsoleteLNSizeCounted;
                }
            } else {
                ++file.obsoleteINCount;
                if (!$assertionsDisabled && size != 0) {
                    throw new AssertionError();
                }
            }
        }
    }

    public void addSummary(long fileNumber, TrackedFileSummary other) {
        TrackedFileSummary file = this.getFile(fileNumber);
        file.addTrackedSummary(other);
    }

    public TrackedFileSummary getUnflushableTrackedSummary(long fileNum) throws DatabaseException {
        TrackedFileSummary file = this.getFile(fileNum);
        file.setAllowFlush(false);
        return file;
    }

    private TrackedFileSummary getFile(long fileNum) {
        Long fileNumLong;
        TrackedFileSummary file;
        if (this.activeFile < fileNum) {
            this.activeFile = fileNum;
        }
        if ((file = (TrackedFileSummary)this.files.get(fileNumLong = new Long(fileNum))) == null) {
            file = new TrackedFileSummary(this, fileNum, this.cleaner.trackDetail);
            HashMap<Long, TrackedFileSummary> newFiles = new HashMap<Long, TrackedFileSummary>(this.files);
            newFiles.put(fileNumLong, file);
            this.files = newFiles;
        }
        return file;
    }

    void resetFile(TrackedFileSummary file) {
        if (file.getFileNumber() < this.activeFile && file.getAllowFlush()) {
            HashMap newFiles = new HashMap(this.files);
            newFiles.remove(new Long(file.getFileNumber()));
            this.files = newFiles;
        }
    }

    private boolean inArray(Object o, Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != o) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !UtilizationTracker.class.desiredAssertionStatus();
    }
}

