/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.junit;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.plugin.Activator;
import aQute.bnd.test.ProjectLauncher;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;

public class OSGiJUnitLauncherConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "aQute.junit.runtime.Target";
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List vmArguments, List programArguments) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        Project model = Activator.getDefault().getCentral().getModel(javaProject);
        model.clear();
        try {
            super.collectExecutionArguments(configuration, vmArguments, programArguments);
            ProjectLauncher launcher = new ProjectLauncher(model);
            launcher.getArguments(vmArguments, (List<String>)programArguments, true);
            if (configuration.getAttribute("aQute.bmaker.CLEARCACHE", false)) {
                programArguments.add("-keep");
            }
            if (launcher.isOk()) {
                return;
            }
            String args = vmArguments + " " + programArguments + " " + Arrays.toString(this.getClasspath(configuration));
            Activator.getDefault().report(true, false, launcher, "Launching " + model, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "osgi.eclipse.junit", "Building arguments for remote VM", (Throwable)e));
        }
        throw new CoreException((IStatus)new Status(4, "osgi.eclipse.junit", "Building arguments for remote VM, project=" + model, null));
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        try {
            IJavaProject javaProject = this.getJavaProject(configuration);
            Project model = Activator.getDefault().getCentral().getModel(javaProject);
            ArrayList<String> classpath = new ArrayList<String>();
            classpath.add(this.getRuntime().getAbsolutePath());
            for (Container c : model.getRunpath()) {
                if (c.getType() != Container.TYPE.ERROR) {
                    classpath.add(c.getFile().getAbsolutePath());
                    continue;
                }
                this.abort("Invalid entry on the -runpath: " + c, null, 4);
            }
            return classpath.toArray(new String[classpath.size()]);
        }
        catch (Exception e) {
            this.abort("Calculating class path", e, 4);
            return null;
        }
    }

    public File getRuntime() {
        return ProjectLauncher.getRuntime();
    }
}

