/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.editors;

import aQute.bnd.plugin.editors.BndTextEditor;
import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class BndMultiPageEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private Table table;
    private TextEditor editor;
    private Font font;
    private StyledText text;

    public BndMultiPageEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    void createTextEditor() {
        try {
            this.editor = new BndTextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createPage1() {
        Composite composite = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        int index = this.addPage((Control)composite);
        TableViewer tableViewer = new TableViewer(composite, 2048);
        this.table = tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText("Key");
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(1000);
        tableColumn_1.setText("Value");
        this.setPageText(index, "Properties");
    }

    void createPage2() {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.text = new StyledText(composite, 768);
        this.text.setEditable(false);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Preview");
    }

    void createPage3() {
    }

    protected void createPages() {
        this.createTextEditor();
        this.createPage1();
        this.createPage2();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void setInput(IEditorInput iei) {
        super.setInput(iei);
        this.setPartName(iei.getName());
        this.setContentDescription(iei.getToolTipText());
        if (iei instanceof IFileEditorInput) {
            IFileEditorInput in = (IFileEditorInput)iei;
            IProject project = in.getFile().getProject();
            this.setPartName(project.getName());
        }
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 2) {
            this.sortWords();
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = BndMultiPageEditor.this.getSite().getWorkbenchWindow().getPages();
                    for (int i = 0; i < pages.length; ++i) {
                        if (!((FileEditorInput)BndMultiPageEditor.this.editor.getEditorInput()).getFile().getProject().equals(event.getResource())) continue;
                        IEditorPart editorPart = pages[i].findEditor(BndMultiPageEditor.this.editor.getEditorInput());
                        pages[i].closeEditor(editorPart, true);
                    }
                }
            });
        }
    }

    void sortWords() {
        String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        StringTokenizer tokenizer = new StringTokenizer(editorText, " \t\n\r\f!@#$%^&*()-_=+`~[]{};:'\",.<>/?|\\");
        ArrayList<String> editorWords = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            editorWords.add(tokenizer.nextToken());
        }
        Collections.sort(editorWords, Collator.getInstance());
        StringWriter displayText = new StringWriter();
        for (int i = 0; i < editorWords.size(); ++i) {
            displayText.write((String)editorWords.get(i));
            displayText.write(System.getProperty("line.separator"));
        }
        this.text.setText(displayText.toString());
    }
}

