/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.editors;

import aQute.bnd.make.ServiceComponent;
import aQute.bnd.plugin.editors.BndSourceViewerConfiguration;
import aQute.bnd.plugin.editors.MacroRule;
import aQute.lib.osgi.Analyzer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class BndScanner
extends RuleBasedScanner {
    BndSourceViewerConfiguration bsvc;

    public BndScanner(BndSourceViewerConfiguration manager) {
        this.bsvc = manager;
        IRule[] rules = new IRule[]{new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return c == ' ' || c == '\t' || c == '\n' || c == '\r';
            }
        }), new BndWordRule(), new MacroRule((IToken)this.bsvc.T_MACRO), new EndOfLineRule("#", (IToken)this.bsvc.T_COMMENT), new EndOfLineRule("\\ ", (IToken)this.bsvc.T_ERROR), new EndOfLineRule("\\\t", (IToken)this.bsvc.T_ERROR)};
        this.setRules(rules);
        this.setDefaultReturnToken((IToken)this.bsvc.T_DEFAULT);
    }

    class BndWordRule
    implements IRule {
        Map<String, IToken> keyWords = new HashMap<String, IToken>();

        public BndWordRule() {
            this.addWords(Analyzer.headers, (IToken)BndScanner.this.bsvc.T_INSTRUCTION);
            this.addWords(Analyzer.options, (IToken)BndScanner.this.bsvc.T_OPTION);
            this.addWords(Analyzer.directives, (IToken)BndScanner.this.bsvc.T_DIRECTIVE);
            this.addWords(ServiceComponent.componentDirectives, (IToken)BndScanner.this.bsvc.T_COMPONENT);
        }

        private boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        private boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c) || c == '-';
        }

        public IToken evaluate(ICharacterScanner scanner) {
            StringBuffer sb = new StringBuffer();
            int c = scanner.read();
            if (this.isWordStart((char)c) || c == 45) {
                do {
                    sb.append((char)c);
                } while ((c = scanner.read()) != -1 && this.isWordPart((char)c));
                scanner.unread();
                IToken token = this.keyWords.get(sb.toString());
                if (token != null) {
                    return token;
                }
                return BndScanner.this.bsvc.T_DEFAULT;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        private void addWords(String[] words, IToken token) {
            for (int i = 0; i < words.length; ++i) {
                this.keyWords.put(words[i], token);
            }
        }
    }
}

