/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.editors;

import aQute.bnd.plugin.editors.BndCompletionProcessor;
import aQute.bnd.plugin.editors.BndHover;
import aQute.bnd.plugin.editors.BndScanner;
import java.util.Properties;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class BndSourceViewerConfiguration
extends SourceViewerConfiguration {
    Token T_DEFAULT;
    Token T_MACRO;
    Token T_ERROR;
    Token T_COMMENT;
    Token T_INSTRUCTION;
    Token T_OPTION;
    Token T_DIRECTIVE;
    Token T_PROPERTY;
    Token T_COMPONENT;
    static final String SINGLELINE_COMMENT_TYPE = "___slc";
    static Properties syntax = null;
    BndScanner scanner;
    MultiLineCommentScanner multiLineCommentScanner;
    ISharedTextColors colors;

    public BndSourceViewerConfiguration(ISharedTextColors colors) {
        this.colors = colors;
        this.T_DEFAULT = new Token((Object)new TextAttribute(colors.getColor(new RGB(0, 0, 0))));
        this.T_MACRO = new Token((Object)new TextAttribute(colors.getColor(new RGB(0, 255, 0)), null, 1));
        this.T_ERROR = new Token((Object)new TextAttribute(colors.getColor(new RGB(255, 0, 0)), null, 1));
        this.T_COMMENT = new Token((Object)new TextAttribute(colors.getColor(new RGB(128, 0, 0))));
        this.T_INSTRUCTION = new Token((Object)new TextAttribute(colors.getColor(new RGB(0, 0, 255)), null, 1));
        this.T_OPTION = new Token((Object)new TextAttribute(colors.getColor(new RGB(0, 0, 255))));
        this.T_DIRECTIVE = new Token((Object)new TextAttribute(colors.getColor(new RGB(60, 60, 255)), null, 1));
        this.T_PROPERTY = new Token((Object)new TextAttribute(colors.getColor(new RGB(60, 60, 255)), null, 1));
        this.T_COMPONENT = new Token((Object)new TextAttribute(colors.getColor(new RGB(60, 60, 255)), null, 1));
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        this.configureReconciler(reconciler, "__dftl_partition_content_type", (ITokenScanner)this.getBndScanner());
        this.configureReconciler(reconciler, SINGLELINE_COMMENT_TYPE, (ITokenScanner)this.getMultiLineCommentScanner());
        return reconciler;
    }

    private void configureReconciler(PresentationReconciler reconciler, String partitionType, ITokenScanner scanner) {
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
        reconciler.setDamager((IPresentationDamager)dr, partitionType);
        reconciler.setRepairer((IPresentationRepairer)dr, partitionType);
    }

    protected BndScanner getBndScanner() {
        if (this.scanner == null) {
            this.scanner = new BndScanner(this);
        }
        return this.scanner;
    }

    protected MultiLineCommentScanner getMultiLineCommentScanner() {
        if (this.multiLineCommentScanner == null) {
            this.multiLineCommentScanner = new MultiLineCommentScanner();
        }
        return this.multiLineCommentScanner;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type" == contentType || SINGLELINE_COMMENT_TYPE == contentType) {
            return new String[]{"#", "//"};
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new BndHover();
    }

    public IContentAssistant getContentAssistant(ISourceViewer viewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new BndCompletionProcessor(), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new BndCompletionProcessor(), SINGLELINE_COMMENT_TYPE);
        assistant.enableAutoActivation(true);
        return assistant;
    }

    class MultiLineCommentScanner
    extends RuleBasedScanner {
        public MultiLineCommentScanner() {
            this.setDefaultReturnToken((IToken)BndSourceViewerConfiguration.this.T_COMMENT);
        }
    }

    class BndPartitionScanner
    extends RuleBasedPartitionScanner {
        public BndPartitionScanner() {
            Token singleLineComment = new Token((Object)BndSourceViewerConfiguration.SINGLELINE_COMMENT_TYPE);
            IPredicateRule[] rules = new IPredicateRule[]{new EndOfLineRule("#", (IToken)singleLineComment)};
            this.setPredicateRules(rules);
        }
    }
}

