/*
 * Decompiled with CFR 0.152.
 */
package aQute.junit.runtime;

import aQute.junit.runtime.SimplePermissionPolicy;
import aQute.junit.runtime.minifw.MiniFramework;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.permissionadmin.PermissionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFramework {
    private String framework;
    private final List jars = new ArrayList();
    private final List bundles = new ArrayList();
    private final List systemPackages = new ArrayList();
    private Framework systemBundle;
    private File storage;
    private boolean keep;
    private final Properties properties;
    private boolean security;
    private SimplePermissionPolicy policy;
    private List<Throwable> activateErrors = new ArrayList<Throwable>();

    public GenericFramework(Properties properties) {
        this.properties = properties;
        this.systemPackages.add("org.osgi.framework");
        this.systemPackages.add("org.osgi.framework.launch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Throwable> activate() {
        Policy.setPolicy(new AllPolicy());
        try {
            this.systemBundle = this.createFramework();
            if (this.systemBundle == null) {
                throw new IllegalStateException("No system bundle");
            }
            try {
                PermissionInfo[] allPermissions = new PermissionInfo[]{new PermissionInfo(AllPermission.class.getName(), null, null)};
                this.policy = new SimplePermissionPolicy(this.systemBundle.getBundleContext());
                this.policy.setDefaultPermissions(allPermissions);
                this.security = true;
            }
            catch (Throwable t) {
                this.security = false;
            }
            this.systemBundle.start();
            BundleContext systemContext = this.getFrameworkContext();
            ArrayList<Bundle> installed = new ArrayList<Bundle>();
            Iterator i = this.bundles.iterator();
            while (i.hasNext()) {
                File path = ((File)i.next()).getAbsoluteFile();
                FileInputStream in = new FileInputStream(path);
                try {
                    Bundle bundle = systemContext.installBundle(path.toString(), (InputStream)in);
                    installed.add(bundle);
                }
                catch (BundleException e) {
                    System.out.println("Install error: " + path + " ");
                    GenericFramework.report(e, System.out);
                    this.activateErrors.add(e);
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            if (this.security) {
                this.policy.setDefaultPermissions(null);
            }
            for (Bundle b : installed) {
                try {
                    if (this.isFragment(b)) continue;
                    b.start();
                }
                catch (BundleException e) {
                    System.out.println("Start error: " + b + " ");
                    GenericFramework.report(e, System.out);
                    this.activateErrors.add(e);
                }
            }
        }
        catch (Exception ex) {
            this.activateErrors.add(ex);
        }
        return this.activateErrors;
    }

    private boolean isFragment(Bundle b) {
        return b.getHeaders().get("Fragment-Host") != null;
    }

    public void deactivate() throws Exception {
        if (this.systemBundle != null) {
            this.getFrameworkBundle().stop();
            this.waitForStop(0L);
        }
    }

    public void addSystemPackage(String packageName) {
        this.systemPackages.add(packageName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Framework createFramework() throws Exception {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.properties);
        if (this.storage != null) {
            if (!this.keep) {
                this.delete(this.storage);
            }
            this.storage.mkdirs();
            if (!this.storage.isDirectory()) {
                throw new IllegalArgumentException();
            }
            p.setProperty("org.osgi.framework.storage", this.storage.getAbsolutePath());
        }
        if (!this.systemPackages.isEmpty()) {
            p.setProperty("org.osgi.framework.system.packages.extra", this.toPackages(this.systemPackages));
        }
        URL[] urls = new URL[this.jars.size()];
        for (int i = 0; i < this.jars.size(); ++i) {
            urls[i] = ((File)this.jars.get(i)).toURL();
        }
        URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
        try {
            MiniFramework systemBundle;
            if (p.containsKey("noframework")) {
                systemBundle = new MiniFramework(p);
            } else if (this.framework != null) {
                Class<?> clazz = loader.loadClass(this.framework);
                if (FrameworkFactory.class.isAssignableFrom(clazz)) {
                    FrameworkFactory f = (FrameworkFactory)clazz.newInstance();
                    systemBundle = f.newFramework((Map)p);
                } else {
                    if (!Framework.class.isAssignableFrom(clazz)) throw new IllegalArgumentException("Specified framework class is not an instance class nor a framework factory");
                    Constructor<?> ctor = clazz.getConstructor(Map.class);
                    systemBundle = (Framework)ctor.newInstance(p);
                }
            } else {
                List implementations = this.getMetaInfServices(loader, FrameworkFactory.class.getName());
                if (implementations.size() != 1) {
                    System.out.println("Found more than one framework implementatios: " + implementations);
                }
                String implementation = (String)implementations.get(0);
                Class<?> clazz = loader.loadClass(implementation);
                FrameworkFactory factory = (FrameworkFactory)clazz.newInstance();
                systemBundle = factory.newFramework((Map)p);
            }
            systemBundle.init();
            return systemBundle;
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Can not load the framework class: " + this.framework);
            return null;
        }
        catch (NoSuchMethodException nsme) {
            System.out.println("Can not find RFC 132 constructor <init>(Map) in " + this.framework);
            return null;
        }
        catch (InvocationTargetException e) {
            System.out.println("Error in constructing framework");
            e.getCause().printStackTrace();
            throw e;
        }
    }

    private List getMetaInfServices(ClassLoader loader, String factory) throws IOException {
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Enumeration<URL> e = loader.getResources("META-INF/services/" + factory);
        ArrayList<String> factories = new ArrayList<String>();
        while (e.hasMoreElements()) {
            String line;
            URL url = e.nextElement();
            BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = rdr.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                factories.add(line);
            }
        }
        return factories;
    }

    private String toPackages(List packs) {
        String del = "";
        StringBuffer sb = new StringBuffer();
        for (String s : packs) {
            sb.append(del);
            sb.append(s);
            del = ", ";
        }
        return sb.toString();
    }

    public void addBundle(File resource) {
        this.bundles.add(resource);
    }

    public void addJar(File resource) {
        this.jars.add(resource);
    }

    public BundleContext getFrameworkContext() {
        return this.systemBundle.getBundleContext();
    }

    public Framework getFrameworkBundle() {
        return this.systemBundle;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public String getFramework() {
        return this.framework;
    }

    public BundleContext getBundleContext() {
        return this.systemBundle.getBundleContext();
    }

    public void waitForStop(long time) throws Exception {
        this.getFrameworkBundle().waitForStop(time);
    }

    public Bundle getBundle(String target) {
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if (!bundles[i].getLocation().equals(target)) continue;
            return bundles[i];
        }
        return null;
    }

    public void setKeep() {
        this.keep = true;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }

    void delete(File f) {
        if (f.getAbsolutePath().matches("(/|[a-zA-Z]:\\\\*|\\\\)")) {
            throw new IllegalArgumentException("You can not make the root the storage area because it will be deleted");
        }
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                this.delete(fs[i]);
            }
        }
        f.delete();
    }

    public void report(PrintStream out) {
        try {
            BundleContext context;
            out.println("------------------------------- REPORT --------------------------");
            out.println();
            out.println("Framework             " + this.framework);
            out.println("SystemBundle          " + (this.systemBundle == null ? "<>" : this.systemBundle.getClass().getName()));
            out.println("Storage               " + this.storage);
            out.println("Keep                  " + this.keep);
            out.println("Security              " + this.security);
            this.list("Jars                  ", this.jars);
            this.list("System Packages       ", this.systemPackages);
            this.list("Classpath             ", Arrays.asList(System.getProperty("java.class.path").split(File.pathSeparator)));
            out.println("Properties");
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                out.print(this.fill(key, 40));
                out.println(value);
            }
            if (this.systemBundle != null && (context = this.systemBundle.getBundleContext()) != null) {
                Bundle[] bundles = context.getBundles();
                System.out.println();
                System.out.println("Id    State Modified      Location");
                for (int i = 0; i < bundles.length; ++i) {
                    File f = new File(bundles[i].getLocation());
                    out.print(this.fill(Long.toString(bundles[i].getBundleId()), 6));
                    out.print(this.fill(this.toState(bundles[i].getState()), 6));
                    if (f.exists()) {
                        out.print(this.fill(this.toDate(f.lastModified()), 14));
                    } else {
                        out.print(this.fill("<>", 14));
                    }
                    out.println(bundles[i].getLocation());
                }
            }
        }
        catch (Throwable t) {
            out.println("Sorry, can't print framework: " + t);
        }
    }

    String toDate(long t) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(t);
        return this.fill(c.get(1), 4) + this.fill(c.get(2), 2) + this.fill(c.get(5), 2) + this.fill(c.get(11), 2) + this.fill(c.get(12), 2);
    }

    private String fill(int n, int width) {
        return this.fill(Integer.toString(n), width, '0', -1);
    }

    private String fill(String s, int width) {
        return this.fill(s, width, ' ', -1);
    }

    private String fill(String s, int width, char filler, int dir) {
        StringBuffer sb = new StringBuffer();
        if (s.length() > width) {
            s = s.substring(0, width - 2) + "..";
        }
        int before = dir == 0 ? width / 2 : (dir < 0 ? 0 : (width -= s.length()));
        int after = width - before;
        while (before-- > 0) {
            sb.append(filler);
        }
        sb.append(s);
        while (after-- > 0) {
            sb.append(filler);
        }
        return sb.toString();
    }

    private String toState(int state) {
        switch (state) {
            case 2: {
                return "INSTL";
            }
            case 4: {
                return "RSLVD";
            }
            case 8: {
                return "STRTD";
            }
            case 16: {
                return "STPPD";
            }
            case 32: {
                return "ACTIV";
            }
            case 1: {
                return "UNNST";
            }
        }
        return "? " + state;
    }

    private void list(String del, List l) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            String s = i.next().toString();
            System.out.println(del + s);
            del = "                                                                       ".substring(0, del.length());
        }
    }

    public static void report(BundleException e, PrintStream out) {
        switch (e.getType()) {
            case 5: {
                System.out.println("Caused by in activator: ");
                e.getCause().printStackTrace();
                break;
            }
            default: {
                e.printStackTrace(System.out);
            }
        }
    }

    static class AllPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 1L;
        private static Vector list = new Vector();

        AllPermissionCollection() {
            this.setReadOnly();
        }

        public void add(Permission permission) {
        }

        public Enumeration elements() {
            return list.elements();
        }

        public boolean implies(Permission permission) {
            return true;
        }
    }

    static class AllPolicy
    extends Policy {
        static PermissionCollection all = new AllPermissionCollection();

        AllPolicy() {
        }

        public PermissionCollection getPermissions(CodeSource codesource) {
            return all;
        }

        public void refresh() {
        }
    }
}

