/*
 * Decompiled with CFR 0.152.
 */
package aQute.junit.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;
import org.osgi.util.tracker.ServiceTracker;

public class SimplePermissionPolicy
implements SynchronousBundleListener {
    static final String DEFAULT_PERMISSION_RESOURCE = "default.perm";
    BundleContext context;
    ServiceTracker tracker;
    Vector bundles;
    PermissionInfo[] defaultPermissions;

    SimplePermissionPolicy(BundleContext context) throws Exception {
        this.context = context;
        this.bundles = new Vector();
        this.tracker = new ServiceTracker(context, PermissionAdmin.class.getName(), null);
        this.tracker.open();
        context.addBundleListener((BundleListener)this);
        PermissionAdmin permissionAdmin = (PermissionAdmin)this.tracker.getService();
        if (permissionAdmin == null) {
            return;
        }
        InputStream in = this.getClass().getResourceAsStream(DEFAULT_PERMISSION_RESOURCE);
        if (in != null) {
            PermissionInfo[] info = this.parse(in);
            permissionAdmin.setDefaultPermissions(info);
        } else {
            System.out.println("default permission not found default.perm");
        }
        Bundle self = context.getBundle();
        this.setPermissions(self);
    }

    public void setPermissions(Bundle bundle) {
        PermissionAdmin permissionAdmin = (PermissionAdmin)this.tracker.getService();
        if (permissionAdmin == null) {
            return;
        }
        PermissionInfo[] info = this.getPermissions(bundle);
        if (info == null) {
            info = this.defaultPermissions;
        }
        if (info != null && info.length > 0) {
            this.bundles.addElement(this.bundles);
            System.out.print("Setting permission for " + bundle.getLocation());
            String del = "=[ ";
            for (int i = 0; i < info.length; ++i) {
                System.out.print(del);
                System.out.print(info[i]);
                del = ", ";
            }
            System.out.println(" ]");
            permissionAdmin.setPermissions(bundle.getLocation(), info);
        } else {
            System.out.println("No permissions for " + bundle.getLocation());
        }
    }

    public PermissionInfo[] getPermissions(Bundle bundle) {
        URL url = bundle.getEntry("/META-INF/permissions.perm");
        if (url == null) {
            url = bundle.getEntry("/META-INF/permissions.perm".toUpperCase());
        }
        PermissionInfo[] info = null;
        if (url != null) {
            try {
                InputStream in = url.openStream();
                info = this.parse(in);
            }
            catch (IOException e) {
                System.out.println("Unable to read permission info for bundle  " + bundle.getLocation() + " " + e);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionInfo[] parse(InputStream in) throws IOException {
        Object[] info = null;
        if (in != null) {
            Vector<PermissionInfo> permissions = new Vector<PermissionInfo>();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                    try {
                        permissions.addElement(new PermissionInfo(line));
                    }
                    catch (IllegalArgumentException iae) {
                        System.out.println("Permission incorrectly encoded: " + line + " " + iae);
                    }
                }
            }
            finally {
                in.close();
            }
            int size = permissions.size();
            if (size > 0) {
                info = new PermissionInfo[size];
                permissions.copyInto(info);
            }
        }
        return info;
    }

    public void clearPermissions(Bundle bundle) {
        PermissionAdmin permissionAdmin = (PermissionAdmin)this.tracker.getService();
        if (permissionAdmin == null) {
            return;
        }
        if (this.bundles.removeElement(bundle)) {
            permissionAdmin.setPermissions(bundle.getLocation(), null);
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (bundle.getBundleId() == 0L) {
            return;
        }
        int type = event.getType();
        switch (type) {
            case 1: 
            case 8: {
                this.setPermissions(bundle);
                break;
            }
            case 16: {
                this.clearPermissions(bundle);
            }
        }
    }

    public void setDefaultPermissions(PermissionInfo[] defaultPermissions) {
        this.defaultPermissions = defaultPermissions;
    }
}

