/*
 * Decompiled with CFR 0.152.
 */
package aQute.junit.runtime;

import aQute.junit.runtime.GenericFramework;
import aQute.junit.runtime.TestReporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.osgi.framework.Bundle;

public class XMLReport
implements TestReporter {
    final File file;
    final PrintStream out;
    List tests;
    boolean open;
    static Pattern TEST_NAME = Pattern.compile("(.+)\\((.+)\\)");

    public XMLReport(String reportName) throws FileNotFoundException {
        this.file = new File(reportName);
        this.out = new PrintStream(new FileOutputStream(this.file));
    }

    public void begin(GenericFramework fw, Bundle targetBundle, List classNames, int realcount) {
        this.out.println("<?xml version='1.0'?>");
        this.out.println("<testreport");
        this.out.println("    target='" + targetBundle.getLocation() + "'");
        this.out.println("    time='" + new Date() + "' ");
        this.out.println("    framework='" + fw.getFramework() + "'>");
        Bundle[] bundles = fw.getFrameworkBundle().getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            this.out.println("  <bundle location='" + bundles[i].getLocation() + "' ");
            this.out.println("     modified='" + bundles[i].getLastModified() + "' ");
            this.out.println("     state='" + bundles[i].getState() + "' ");
            this.out.println("     id='" + bundles[i].getBundleId() + "' ");
            this.out.println("     bsn='" + bundles[i].getSymbolicName() + "' ");
            this.out.println("     version='" + bundles[i].getHeaders().get("Bundle-Version") + "' ");
            this.out.println("  />");
        }
    }

    public void end() {
        this.out.println("</testreport>");
        this.out.close();
    }

    public void setTests(List flattened) {
        this.tests = flattened;
    }

    public void startTest(Test test) {
        String nameAndClass;
        String name = nameAndClass = test.toString();
        String clazz = "";
        Matcher m = TEST_NAME.matcher(nameAndClass);
        if (m.matches()) {
            name = m.group(1);
            clazz = m.group(2);
        }
        this.out.print("  <test name='" + name + "' class='" + clazz + "'");
        this.open = true;
    }

    public void addError(Test test, Throwable t) {
        if (this.open) {
            this.out.println(">");
        }
        this.open = false;
        if (test != null) {
            this.out.println(" <error name='" + test.toString() + "' type='" + t.getClass().getName() + "'>");
        }
        this.out.println("<![CDATA[");
        t.printStackTrace(this.out);
        this.out.println("]]>");
        this.out.println(" </error>");
    }

    public void addFailure(Test test, AssertionFailedError t) {
        if (this.open) {
            this.out.println(">");
        }
        this.open = false;
        this.out.println(" <failure name='" + test.toString() + "' type='" + t.getClass().getName() + "'>");
        this.out.println("<![CDATA[");
        t.printStackTrace(this.out);
        this.out.println("]]>");
        this.out.println(" </failure>");
    }

    public void endTest(Test test) {
        if (this.open) {
            this.out.println("/>");
        } else {
            this.out.println("  </test>");
        }
        this.open = false;
    }
}

