package aQute.bnd.make.component;

import static aQute.bnd.make.component.ServiceComponent.*;

import java.util.*;
import java.util.regex.*;

import aQute.bnd.annotation.component.*;
import aQute.lib.osgi.*;

public class ComponentAnnotationReader extends ClassDataCollector {
    static Pattern             BINDDESCRIPTOR        = Pattern
                                                             .compile("\\(L(.*);\\)V");
    static Pattern             BINDMETHOD            = Pattern
                                                             .compile("(unset|set|bind|unbind)?(.)(.*)");

    String                     method;
    String                     methodDescriptor;
    String                     className;
    Clazz                      clazz;
    String                     interfaces[];
    Set<String>                multiple              = new HashSet<String>();
    Set<String>                optional              = new HashSet<String>();
    Set<String>                dynamic               = new HashSet<String>();

    Map<String, String>        map                   = new HashMap<String, String>();

    public final static String COMPONENT_ANNOTATION  = "L"
                                                             + Component.class
                                                                     .getName()
                                                                     .replace(
                                                                             '.',
                                                                             '/')
                                                             + ";";
    final static String        REFERENCE_ANNOTATION  = "L"
                                                             + aQute.bnd.annotation.component.Reference.class
                                                                     .getName()
                                                                     .replace(
                                                                             '.',
                                                                             '/')
                                                             + ";";
    final static String        ACTIVATE_ANNOTATION   = "L"
                                                             + Activate.class
                                                                     .getName()
                                                                     .replace(
                                                                             '.',
                                                                             '/')
                                                             + ";";
    final static String        DEACTIVATE_ANNOTATION = "L"
                                                             + Deactivate.class
                                                                     .getName()
                                                                     .replace(
                                                                             '.',
                                                                             '/')
                                                             + ";";
    final static String        MODIFIED_ANNOTATION   = "L"
                                                             + Modified.class
                                                                     .getName()
                                                                     .replace(
                                                                             '.',
                                                                             '/')
                                                             + ";";

    ComponentAnnotationReader(Clazz clazz) {
        this.clazz = clazz;
    }

    public static Map<String, String> getDefiniton(Clazz c) throws Exception {
        ComponentAnnotationReader r = new ComponentAnnotationReader(c);
        c.parseClassFileWithCollector(r);
        r.finish();
        return r.map;
    }

    public void annotation(Annotation annotation) {

        if (annotation.getName().equals(COMPONENT_ANNOTATION)) {
            set(COMPONENT_NAME, annotation.get(Component.NAME), "<>");
            setBoolean(COMPONENT_FACTORY, annotation.get(Component.FACTORY),
                    false);
            setBoolean(COMPONENT_ENABLED, annotation.get(Component.ENABLED),
                    true);
            setBoolean(COMPONENT_IMMEDIATE,
                    annotation.get(Component.IMMEDIATE), false);
            setBoolean(COMPONENT_SERVICEFACTORY, annotation
                    .get(Component.SERVICEFACTORY), false);
            set(COMPONENT_CONFIGURATION_POLICY, annotation
                    .get(Component.CONFIGURATION_POLICY), "<>");

            Object[] provides = (Object[]) annotation.get(Component.PROVIDE);
            String[] p;
            if (provides == null) {
                // Use the found interfaces, but convert from internal to
                // fqn.
                if (interfaces != null) {
                    p = new String[interfaces.length];
                    for (int i = 0; i < interfaces.length; i++)
                        p[i] = interfaces[i].replace('/', '.');
                } else
                    p = new String[0];
            } else {
                // We have explicit interfaces set
                p = new String[provides.length];
                for (int i = 0; i < provides.length; i++) {
                    p[i] = descriptorToFQN(provides[i].toString());
                }
            }
            if (p.length > 0) {
                set(COMPONENT_PROVIDE, Processor.join(Arrays.asList(p)), "<>");
            }

        } else if (annotation.getName().equals(ACTIVATE_ANNOTATION)) {
            set(COMPONENT_ACTIVATE, method, "activate");
        } else if (annotation.getName().equals(DEACTIVATE_ANNOTATION)) {
            set(COMPONENT_DEACTIVATE, method, "deactivate");
        } else if (annotation.getName().equals(MODIFIED_ANNOTATION)) {
            set(COMPONENT_MODIFIED, method, "<>");
        } else if (annotation.getName().equals(REFERENCE_ANNOTATION)) {
            String name = (String) annotation.get(Reference.NAME);
            if (name == null) {
                Matcher m = BINDMETHOD.matcher(method);
                if (m.matches()) {
                    name = m.group(2).toLowerCase() + m.group(3);
                } else
                    name = method;
            }

            String service = annotation.get(Reference.SERVICE);
            if (service == null) {
                // We have to find the type of the current method to
                // link it to the referenced service.
                Matcher m = BINDDESCRIPTOR.matcher(methodDescriptor);
                if (m.matches()) {
                    service = m.group(1).replace('/', '.');
                } else
                    throw new IllegalArgumentException(
                            "Cannot detect the type of a Component Reference from the descriptor: "
                                    + methodDescriptor);
            }

            // Check if we have a target, this must be a filter
            String target = annotation.get(Reference.TARGET);
            if (target != null) {
                Verifier.verifyFilter(target, 0);
                service = service + target;
            }

            Integer c = annotation.get(Reference.TYPE);
            if (c != null && !c.equals(0) && !c.equals((int) '1')) {
                service = service + (char) c.intValue();
            }

            map.put(name, service);

            if (isTrue(annotation.get(Reference.MULTIPLE)))
                multiple.add(name);
            if (isTrue(annotation.get(Reference.OPTIONAL)))
                optional.add(name);
            if (isTrue(annotation.get(Reference.DYNAMIC)))
                dynamic.add(name);
        }
    }

    private boolean isTrue(Object object) {
        if (object == null)
            return false;
        return (Boolean) object;
    }

    private void setBoolean(String string, Object object, boolean b) {
        if (object == null)
            object = b;

        Boolean bb = (Boolean) object;
        if (bb == b)
            return;

        map.put(string, bb.toString());
    }

    private void set(String string, Object object, Object deflt) {
        if (object == null || object.equals(deflt))
            return;

        map.put(string, object.toString());
    }

    /**
     * Skip L and ; and replace / for . in an object descriptor.
     * 
     * A string like Lcom/acme/Foo; becomes com.acme.Foo
     * 
     * @param string
     * @return
     */

    private String descriptorToFQN(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < string.length() - 1; i++) {
            char c = string.charAt(i);
            if (c == '/')
                c = '.';
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void classBegin(int access, String name) {
        className = name;
    }

    @Override
    public void implementsInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public void method(int access, String name, String descriptor) {
        this.method = name;
        this.methodDescriptor = descriptor;
    }

    void set(String name, Collection<String> l) {
        if (l.size() == 0)
            return;

        set(name, Processor.join(l), "<>");
    }

    public void finish() {
        set(COMPONENT_MULTIPLE, multiple);
        set(COMPONENT_DYNAMIC, dynamic);
        set(COMPONENT_OPTIONAL, optional);
        set(COMPONENT_IMPLEMENTATION, clazz.getFQN(), "<>");
    }

}
