/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.unmodifiable;

import aQute.bnd.unmodifiable.ImmutableEntry;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

final class ImmutableMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    static final ImmutableMap<?, ?> EMPTY = new ImmutableMap(new Object[0]);
    final Object[] entries;
    final transient short[] hash_bucket;
    private static final long serialVersionUID = 1L;

    ImmutableMap(Object ... entries) {
        this.entries = entries;
        this.hash_bucket = ImmutableMap.hash(entries);
    }

    private static short[] hash(Object[] entries) {
        if ((entries.length & 1) != 0) {
            throw new IllegalArgumentException("entries is not even length");
        }
        int length = entries.length >>> 1;
        if (length == 0) {
            return new short[1];
        }
        if (length >= 65536) {
            throw new IllegalArgumentException("map too large: " + length);
        }
        short[] hash_bucket = new short[length * 2];
        int slot = 0;
        int index = 0;
        while (slot < length) {
            Object key = entries[index];
            int hash = -1 - ImmutableMap.linear_probe(entries, hash_bucket, key);
            if (hash < 0) {
                throw new IllegalArgumentException("duplicate key: " + key);
            }
            hash_bucket[hash] = (short)(++slot);
            Objects.requireNonNull(entries[index + 1]);
            index += 2;
        }
        return hash_bucket;
    }

    private static int linear_probe(Object[] entries, short[] hash_bucket, Object key) {
        int length = hash_bucket.length;
        int hash = (key.hashCode() & Integer.MAX_VALUE) % length;
        int index;
        while ((index = Short.toUnsignedInt(hash_bucket[hash]) - 1 << 1) >= 0) {
            if (entries[index].equals(key)) {
                return index;
            }
            hash = (hash + 1) % length;
        }
        return -1 - hash;
    }

    private int linear_probe(Object key) {
        return ImmutableMap.linear_probe(this.entries, this.hash_bucket, key);
    }

    @Override
    public int size() {
        return this.entries.length >>> 1;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null) {
            return this.linear_probe(key) >= 0;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            Object[] entries = this.entries;
            int end = entries.length;
            for (int index = 1; index < end; index += 2) {
                if (!value.equals(entries[index])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int index;
        if (key != null && (index = this.linear_probe(key)) >= 0) {
            return (V)this.entries[index + 1];
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.size() != other.size()) {
            return false;
        }
        try {
            Object[] entries = this.entries;
            int end = entries.length;
            for (int index = 0; index < end; index += 2) {
                if (entries[index + 1].equals(other.get(entries[index]))) continue;
                return false;
            }
        }
        catch (ClassCastException checked) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        Object[] entries = this.entries;
        int hashCode = 0;
        int end = entries.length;
        for (int index = 0; index < end; index += 2) {
            hashCode += entries[index].hashCode() ^ entries[index + 1].hashCode();
        }
        return hashCode;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        Object[] entries = this.entries;
        int end = entries.length;
        for (int index = 0; index < end; index += 2) {
            action.accept(entries[index], entries[index + 1]);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet(this);
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection(this);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    static final class EntrySet<K, V>
    extends ElementSet<Map.Entry<K, V>> {
        EntrySet(ImmutableMap<K, V> map) {
            super(map);
        }

        @Override
        Map.Entry<K, V> element(int index) {
            Object[] entries = this.map.entries;
            return new ImmutableEntry<Object, Object>(entries[index], entries[index + 1]);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            Object v = this.map.get(other.getKey());
            if (v == null) {
                return false;
            }
            return v.equals(other.getValue());
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }
    }

    static final class KeySet<K>
    extends ElementSet<K> {
        KeySet(ImmutableMap<K, ?> map) {
            super(map);
        }

        @Override
        K element(int index) {
            return (K)this.map.entries[index];
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public int hashCode() {
            Object[] entries = this.map.entries;
            int hashCode = 0;
            int end = entries.length;
            for (int index = 0; index < end; index += 2) {
                hashCode += entries[index].hashCode();
            }
            return hashCode;
        }
    }

    static final class ValueCollection<V>
    extends ElementCollection<V> {
        ValueCollection(ImmutableMap<?, V> map) {
            super(map);
        }

        @Override
        V element(int index) {
            return (V)this.map.entries[index + 1];
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsValue(o);
        }
    }

    private static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Object[] data;

        SerializationProxy(ImmutableMap<?, ?> map) {
            this.data = map.entries;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            Object[] local = this.data;
            int length = local.length;
            oos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                oos.writeObject(local[i]);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            int length = ois.readInt();
            if (length < 0) {
                throw new InvalidObjectException("negative length");
            }
            if ((length & 1) != 0) {
                throw new InvalidObjectException("odd length");
            }
            Object[] local = new Object[length];
            for (int i = 0; i < length; ++i) {
                local[i] = ois.readObject();
            }
            this.data = local;
        }

        private Object readResolve() throws InvalidObjectException {
            try {
                Object[] local = this.data;
                if (local.length == 0) {
                    return EMPTY;
                }
                return new ImmutableMap(local);
            }
            catch (RuntimeException e) {
                InvalidObjectException ioe = new InvalidObjectException("invalid");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    static abstract class ElementSet<E>
    extends ElementCollection<E>
    implements Set<E> {
        ElementSet(ImmutableMap<?, ?> map) {
            super(map);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set other = (Set)o;
            if (this.size() != other.size()) {
                return false;
            }
            try {
                return this.containsAll(other);
            }
            catch (ClassCastException checked) {
                return false;
            }
        }

        @Override
        public abstract int hashCode();
    }

    static abstract class ElementCollection<E>
    extends AbstractCollection<E>
    implements Collection<E> {
        final ImmutableMap<?, ?> map;

        ElementCollection(ImmutableMap<?, ?> map) {
            this.map = map;
        }

        abstract E element(int var1);

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public Iterator<E> iterator() {
            return new ElementIterator(0, this.map.entries.length);
        }

        @Override
        public Spliterator<E> spliterator() {
            return new ElementSpliterator(0, this.map.entries.length);
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int end = this.map.entries.length;
            for (int index = 0; index < end; index += 2) {
                action.accept(this.element(index));
            }
        }

        @Override
        public int size() {
            return this.map.size();
        }

        final class ElementIterator
        implements Iterator<E> {
            private int index;
            private final int end;

            ElementIterator(int index, int end) {
                this.index = index;
                this.end = end;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.end;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    Object element = ElementCollection.this.element(this.index);
                    this.index += 2;
                    return element;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                Objects.requireNonNull(action);
                while (this.index < this.end) {
                    Object element = ElementCollection.this.element(this.index);
                    this.index += 2;
                    action.accept(element);
                }
            }
        }

        final class ElementSpliterator
        implements Spliterator<E> {
            private int index;
            private final int end;

            ElementSpliterator(int index, int end) {
                this.index = index;
                this.end = end;
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> action) {
                Objects.requireNonNull(action);
                if (this.index < this.end) {
                    Object element = ElementCollection.this.element(this.index);
                    this.index += 2;
                    action.accept(element);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                Objects.requireNonNull(action);
                while (this.index < this.end) {
                    Object element = ElementCollection.this.element(this.index);
                    this.index += 2;
                    action.accept(element);
                }
            }

            @Override
            public Spliterator<E> trySplit() {
                int split = this.index + this.end >>> 2 << 1;
                if (this.index < split) {
                    ElementSpliterator spliterator = new ElementSpliterator(this.index, split);
                    this.index = split;
                    return spliterator;
                }
                return null;
            }

            @Override
            public long estimateSize() {
                return this.getExactSizeIfKnown();
            }

            @Override
            public int characteristics() {
                int characteristics = 17744;
                if (ElementCollection.this instanceof Set) {
                    characteristics |= 1;
                }
                return characteristics;
            }

            @Override
            public long getExactSizeIfKnown() {
                return this.end - this.index >>> 1;
            }
        }
    }
}

