/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantValueAttribute
implements Attribute {
    public static final String NAME = "ConstantValue";
    public final Object value;

    public ConstantValueAttribute(Object value) {
        this.value = value;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "ConstantValue=" + this.value;
    }

    public static ConstantValueAttribute read(DataInput in, ConstantPool constant_pool) throws IOException {
        int constantvalue_index = in.readUnsignedShort();
        Object value = constant_pool.entry(constantvalue_index);
        if (value instanceof ConstantPool.StringInfo) {
            value = constant_pool.string(constantvalue_index);
        }
        return new ConstantValueAttribute(value);
    }

    @Override
    public void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        int constantvalue_index;
        int attribute_name_index = constant_pool.utf8Info(this.name());
        int attribute_length = this.attribute_length();
        out.writeShort(attribute_name_index);
        out.writeInt(attribute_length);
        Object object = this.value;
        if (object instanceof String) {
            String string_value = (String)object;
            constantvalue_index = constant_pool.stringInfo(string_value);
        } else {
            object = this.value;
            if (object instanceof Integer) {
                Integer integer_value = (Integer)object;
                constantvalue_index = constant_pool.integerInfo(integer_value);
            } else {
                object = this.value;
                if (object instanceof Long) {
                    Long long_value = (Long)object;
                    constantvalue_index = constant_pool.longInfo(long_value);
                } else {
                    object = this.value;
                    if (object instanceof Double) {
                        Double double_value = (Double)object;
                        constantvalue_index = constant_pool.doubleInfo(double_value);
                    } else {
                        object = this.value;
                        if (object instanceof Float) {
                            Float float_value = (Float)object;
                            constantvalue_index = constant_pool.floatInfo(float_value);
                        } else {
                            throw new IOException("Unrecognized constant value type " + this.value);
                        }
                    }
                }
            }
        }
        out.writeShort(constantvalue_index);
    }

    @Override
    public int attribute_length() {
        int attribute_length = 2;
        return attribute_length;
    }
}

