/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile.builder;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.FieldInfo;
import aQute.bnd.classfile.MethodInfo;
import aQute.bnd.classfile.builder.ClassFileBuilder;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReflectBuilder {
    static final int javaSpecificationVersion = Integer.parseInt(System.getProperty("java.specification.version"));
    static final int major_version = javaSpecificationVersion + 44;

    public static ClassFileBuilder of(Class<?> c) {
        ClassFileBuilder cfb = new ClassFileBuilder(c.getModifiers(), major_version, 0, ReflectBuilder.toName(c), ReflectBuilder.toName(c.getSuperclass()), Stream.of(c.getInterfaces()).map(ReflectBuilder::toName).collect(Collectors.toSet()));
        for (Field field : c.getDeclaredFields()) {
            FieldInfo fi = new FieldInfo(field.getModifiers(), field.getName(), ReflectBuilder.descriptor(field, field.getType(), new Class[0]), ReflectBuilder.attributes(field));
            cfb.fields(fi);
        }
        for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
            MethodInfo mi = new MethodInfo(((Method)accessibleObject).getModifiers(), ((Method)accessibleObject).getName(), ReflectBuilder.descriptor((Member)((Object)accessibleObject), ((Method)accessibleObject).getReturnType(), ((Method)accessibleObject).getParameterTypes()), ReflectBuilder.attributes(accessibleObject));
            cfb.methods(mi);
        }
        cfb.attributes(ReflectBuilder.attributes(c));
        return cfb;
    }

    private static Attribute[] attributes(Object f) {
        return new Attribute[0];
    }

    private static String descriptor(Member m, Class<?> type, Class ... parameters) {
        StringBuilder sb = new StringBuilder();
        if (m instanceof Method) {
            sb.append("(");
            for (Class p : parameters) {
                ReflectBuilder.encode(p);
            }
            sb.append(")");
        }
        sb.append(ReflectBuilder.encode(type));
        return sb.toString();
    }

    private static String encode(Class<?> type) {
        if (type == Void.TYPE) {
            return "V";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        return "L".concat(ReflectBuilder.toName(type)).concat(";");
    }

    private static String toName(Class<?> c) {
        if (c == null) {
            return null;
        }
        return c.getName();
    }
}

