/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ArrayTypeSignature;
import aQute.bnd.signatures.BaseType;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.TypeArgument;
import aQute.bnd.signatures.TypeParameter;
import aQute.bnd.signatures.TypeVariableSignature;
import java.util.Objects;

public class ClassResolver {
    private final ClassSignature classSig;

    public ClassResolver(ClassSignature classSig) {
        this.classSig = Objects.requireNonNull(classSig);
    }

    public <T extends JavaTypeSignature> T resolveType(JavaTypeSignature type) {
        if (type instanceof BaseType || type instanceof ClassTypeSignature) {
            return (T)type;
        }
        if (type instanceof ArrayTypeSignature) {
            ArrayTypeSignature arrayType = (ArrayTypeSignature)type;
            return (T)this.resolveType(arrayType);
        }
        return (T)this.resolveType((TypeVariableSignature)type);
    }

    public ArrayTypeSignature resolveType(ArrayTypeSignature arrayType) {
        JavaTypeSignature component = arrayType.component;
        int depth = 1;
        while (component instanceof ArrayTypeSignature) {
            ArrayTypeSignature arrayComponent = (ArrayTypeSignature)component;
            ++depth;
            component = arrayComponent.component;
        }
        if (component instanceof BaseType || component instanceof ClassTypeSignature) {
            return arrayType;
        }
        component = this.resolveType((TypeVariableSignature)component);
        arrayType = new ArrayTypeSignature(component);
        while (--depth > 0) {
            arrayType = new ArrayTypeSignature(arrayType);
        }
        return arrayType;
    }

    public ReferenceTypeSignature resolveType(TypeArgument typeArgument) {
        return (ReferenceTypeSignature)this.resolveType(typeArgument.type);
    }

    public ReferenceTypeSignature resolveType(TypeVariableSignature typeVariable) {
        return this.resolveType(this.classSig.typeParameters, typeVariable);
    }

    protected ReferenceTypeSignature resolveType(TypeParameter[] typeParameters, TypeVariableSignature typeVariable) {
        String variable = typeVariable.identifier;
        for (TypeParameter typeParameter : typeParameters) {
            if (!variable.equals(typeParameter.identifier)) continue;
            ReferenceTypeSignature classBound = typeParameter.classBound;
            if (classBound != null) {
                return (ReferenceTypeSignature)this.resolveType(classBound);
            }
            int n = 0;
            ReferenceTypeSignature[] referenceTypeSignatureArray = typeParameter.interfaceBounds;
            int n2 = referenceTypeSignatureArray.length;
            if (n >= n2) break;
            ReferenceTypeSignature interfaceBound = referenceTypeSignatureArray[n];
            return (ReferenceTypeSignature)this.resolveType(interfaceBound);
        }
        return null;
    }

    public int hashCode() {
        return 31 + this.classSig.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassResolver)) {
            return false;
        }
        ClassResolver other = (ClassResolver)obj;
        return Objects.equals(this.classSig, other.classSig);
    }

    public String toString() {
        return "ClassResolver: " + this.classSig;
    }
}

