/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.lib.io.IO;
import aQute.lib.io.Other;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Windows
implements IO.OS {
    static final Pattern WINDOWS_BAD_FILE_NAME_P = Pattern.compile("(?:(:?.*[\u0000-\u001f<>:\"|/\\\\?*].*)|\\.\\.|CON|PRN|AUX|NUL|COM\\d|COM\u00b9|COM\u00b2|COM\u00b3|LPT\\d|LPT\u00b9|LPT\u00b2|LPT\u00b3)(?:\\.\\w+)?", 2);
    static final Pattern DRIVE_P = Pattern.compile("/?(?<drive>[a-z]:)", 2);

    Windows() {
    }

    @Override
    public File getBasedFile(File base, String subPath) throws IOException {
        String use;
        Matcher matcher = WINDOWS_BAD_FILE_NAME_P.matcher(subPath);
        if (matcher.find()) {
            try {
                Path normalizedPath = Path.of(subPath, new String[0]).normalize();
                if (normalizedPath.startsWith(IO.DOTDOT)) {
                    throw new IOException("io.sub.up invalid path, will escape the designated directory. path='" + subPath + "', base='" + base + "', normalized='" + normalizedPath + "'");
                }
                for (int i = 0; i < normalizedPath.getNameCount(); ++i) {
                    String segment = normalizedPath.getName(i).toString();
                    if (!matcher.reset(segment).matches()) continue;
                    throw new IOException("io.win.sub.invalid pathcontains reserved names on windows. path='" + subPath + "', base='" + base + "', pattern='" + WINDOWS_BAD_FILE_NAME_P + "'");
                }
                use = normalizedPath.toString();
            }
            catch (InvalidPathException e) {
                throw new IOException("io.win.sub.invalid pathcontains reserved names on windows. path='" + subPath + "', base='" + base + "': '" + e.getMessage() + "'");
            }
        } else {
            use = subPath;
        }
        return new File(base, use);
    }

    @Override
    public String getenv(String string) {
        return IO.hc.getenv(string);
    }

    @Override
    public String toSafeFileName(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ') continue;
            sb.append(switch (c) {
                case '\"', '*', '/', ':', '<', '>', '?', '\\', '|' -> '%';
                default -> c;
            });
        }
        if (sb.length() == 0 || WINDOWS_BAD_FILE_NAME_P.matcher(sb).matches()) {
            sb.append("_");
        }
        return sb.toString();
    }

    @Override
    public File getFile(File base, String file) {
        Matcher m = DRIVE_P.matcher(file = file.replace('\\', '/'));
        if (m.lookingAt()) {
            base = new File(m.group("drive"));
        }
        return Other.getFile0(base, file);
    }
}

