/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler;

import biz.gabrys.lesscss.compiler.LessCompiler;
import biz.gabrys.lesscss.compiler.LessCompilerImpl;
import biz.gabrys.lesscss.extended.compiler.CachingCompiledCodeExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.SimpleExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationCheckerImpl;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceModificationDateBasedExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.processor.DoNothingPostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PreCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.SourceTreeWithCodeCachingPreparationProcessorBuilder;
import biz.gabrys.lesscss.extended.compiler.control.provider.CachedSourceFileProvider;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportReplacer;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportReplacerImpl;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolver;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolverImpl;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryBuilder;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;

public class CachingSourceAndCompiledCodeExtendedCompilerBuilder {
    private final FullCache cache;
    private LessCompiler compiler;
    private SourceExpirationChecker expirationChecker;
    private LessImportResolver importResolver;
    private LessImportReplacer importReplacer;
    private SourceFactory sourceFactory;
    private PostCompilationProcessor postProcessor;

    public CachingSourceAndCompiledCodeExtendedCompilerBuilder(FullCache cache) {
        ParameterUtils.verifyNotNull("cache", cache);
        this.cache = cache;
    }

    public CachingSourceAndCompiledCodeExtendedCompilerBuilder withCompiler(LessCompiler compiler) {
        this.compiler = compiler;
        return this;
    }

    public CachingSourceAndCompiledCodeExtendedCompilerBuilder withExpirationChecker(SourceExpirationChecker expirationChecker) {
        this.expirationChecker = expirationChecker;
        return this;
    }

    public CachingSourceAndCompiledCodeExtendedCompilerBuilder withImportResolver(LessImportResolver importResolver) {
        this.importResolver = importResolver;
        return this;
    }

    public CachingSourceAndCompiledCodeExtendedCompilerBuilder withImportReplacer(LessImportReplacer importReplacer) {
        this.importReplacer = importReplacer;
        return this;
    }

    public CachingSourceAndCompiledCodeExtendedCompilerBuilder withSourceFactory(SourceFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
        return this;
    }

    public CachingSourceAndCompiledCodeExtendedCompilerBuilder withPostProcessor(PostCompilationProcessor postProcessor) {
        this.postProcessor = postProcessor;
        return this;
    }

    public ExtendedCompiler create() {
        LessCompiler localCompiler = this.createLessCompiler();
        SourceTreeWithCodeCachingPreparationProcessorBuilder sourceTreeBuilder = new SourceTreeWithCodeCachingPreparationProcessorBuilder(this.cache);
        SourceExpirationChecker localExpirationChecker = this.createExpirationChecker();
        SourceFactory localSourceFactory = this.createSourceFactory();
        PreCompilationProcessor localPreProcessor = this.createPreProcessor(sourceTreeBuilder, localExpirationChecker, localSourceFactory);
        PostCompilationProcessor localPostProcessor = this.createPostProcessor();
        ExtendedCompiler extendedCompiler = this.createSimpleExtendedCompiler(localCompiler, localPreProcessor, localPostProcessor);
        CompiledSourceExpirationChecker compiledSourceChecker = this.createCompiledSourceExpirationChecker(localExpirationChecker, localSourceFactory);
        return new CachingCompiledCodeExtendedCompiler(extendedCompiler, compiledSourceChecker, this.cache, this.cache);
    }

    LessCompiler createLessCompiler() {
        return this.compiler != null ? this.compiler : new LessCompilerImpl();
    }

    SourceExpirationChecker createExpirationChecker() {
        return this.expirationChecker != null ? this.expirationChecker : new SourceModificationDateBasedExpirationChecker(this.cache);
    }

    SourceFactory createSourceFactory() {
        return this.sourceFactory != null ? this.sourceFactory : this.createSourceFactoryFromBuilder(new SourceFactoryBuilder());
    }

    SourceFactory createSourceFactoryFromBuilder(SourceFactoryBuilder builder) {
        return builder.withStandard().create();
    }

    PreCompilationProcessor createPreProcessor(SourceTreeWithCodeCachingPreparationProcessorBuilder builder, SourceExpirationChecker checker, SourceFactory sourceFactory) {
        builder.withExpirationChecker(checker);
        builder.withImportResolver(this.createImportResolver());
        builder.withImportReplacer(this.createImportReplacer());
        builder.withSourceFactory(sourceFactory);
        return builder.create();
    }

    LessImportResolver createImportResolver() {
        return this.importResolver != null ? this.importResolver : new LessImportResolverImpl();
    }

    LessImportReplacer createImportReplacer() {
        return this.importReplacer != null ? this.importReplacer : new LessImportReplacerImpl();
    }

    PostCompilationProcessor createPostProcessor() {
        return this.postProcessor != null ? this.postProcessor : new DoNothingPostCompilationProcessor();
    }

    ExtendedCompiler createSimpleExtendedCompiler(LessCompiler compiler, PreCompilationProcessor preProcessor, PostCompilationProcessor postProcessor) {
        return new SimpleExtendedCompiler(compiler, preProcessor, new CachedSourceFileProvider(this.cache), postProcessor);
    }

    CompiledSourceExpirationChecker createCompiledSourceExpirationChecker(SourceExpirationChecker expirationChecker, SourceFactory sourceFactory) {
        return new CompiledSourceExpirationCheckerImpl(expirationChecker, this.cache, this.cache, sourceFactory);
    }
}

