/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler;

import biz.gabrys.lesscss.compiler.LessCompiler;
import biz.gabrys.lesscss.compiler.LessCompilerImpl;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.SimpleExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.control.processor.DoNothingPostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.DoNothingPreCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PreCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.provider.SourceFileProvider;
import biz.gabrys.lesscss.extended.compiler.control.provider.SourcePathFileProvider;

public class NonCachingExtendedCompilerBuilder {
    private LessCompiler compiler;
    private PreCompilationProcessor preProcessor;
    private SourceFileProvider fileProvider;
    private PostCompilationProcessor postProcessor;

    public NonCachingExtendedCompilerBuilder withCompiler(LessCompiler compiler) {
        this.compiler = compiler;
        return this;
    }

    public NonCachingExtendedCompilerBuilder withPreProcessor(PreCompilationProcessor preProcessor) {
        this.preProcessor = preProcessor;
        return this;
    }

    public NonCachingExtendedCompilerBuilder withFileProvider(SourceFileProvider fileProvider) {
        this.fileProvider = fileProvider;
        return this;
    }

    public NonCachingExtendedCompilerBuilder withPostProcessor(PostCompilationProcessor postProcessor) {
        this.postProcessor = postProcessor;
        return this;
    }

    public ExtendedCompiler create() {
        LessCompiler lessCompiler = this.compiler != null ? this.compiler : new LessCompilerImpl();
        PreCompilationProcessor preProc = this.preProcessor != null ? this.preProcessor : new DoNothingPreCompilationProcessor();
        SourceFileProvider provider = this.fileProvider != null ? this.fileProvider : new SourcePathFileProvider();
        PostCompilationProcessor postProc = this.postProcessor != null ? this.postProcessor : new DoNothingPostCompilationProcessor();
        return new SimpleExtendedCompiler(lessCompiler, preProc, provider, postProc);
    }
}

