/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEROctetStringParser;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.DERSetParser;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;

    public ASN1StreamParser(InputStream inputStream) {
        this(inputStream, Integer.MAX_VALUE);
    }

    public ASN1StreamParser(InputStream inputStream, int n) {
        this._in = inputStream;
        this._limit = n;
    }

    public ASN1StreamParser(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public DEREncodable readObject() throws IOException {
        int n = this._in.read();
        if (n == -1) {
            return null;
        }
        this.set00Check(false);
        int n2 = ASN1InputStream.readTagNumber(this._in, n);
        boolean bl = (n & 0x20) != 0;
        int n3 = ASN1InputStream.readLength(this._in, this._limit);
        if (n3 < 0) {
            if (!bl) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in);
            if ((n & 0x80) != 0) {
                return new BERTaggedObjectParser(n, n2, indefiniteLengthInputStream);
            }
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(indefiniteLengthInputStream);
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser);
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser);
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser);
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n3);
        if ((n & 0x40) != 0) {
            return new DERApplicationSpecific(bl, n2, definiteLengthInputStream.toByteArray());
        }
        if ((n & 0x80) != 0) {
            return new BERTaggedObjectParser(n, n2, definiteLengthInputStream);
        }
        if (bl) {
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(definiteLengthInputStream));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(definiteLengthInputStream));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(definiteLengthInputStream));
                }
            }
            return new DERUnknownTag(true, n2, definiteLengthInputStream.toByteArray());
        }
        switch (n2) {
            case 4: {
                return new DEROctetStringParser(definiteLengthInputStream);
            }
        }
        return ASN1InputStream.createPrimitiveDERObject(n2, definiteLengthInputStream.toByteArray());
    }

    ASN1EncodableVector readVector() throws IOException {
        DEREncodable dEREncodable;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((dEREncodable = this.readObject()) != null) {
            aSN1EncodableVector.add(dEREncodable.getDERObject());
        }
        return aSN1EncodableVector;
    }

    private void set00Check(boolean bl) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(bl);
        }
    }
}

