/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERInteger
extends ASN1Object {
    byte[] bytes;

    public DERInteger(int n) {
        this.bytes = BigInteger.valueOf(n).toByteArray();
    }

    public DERInteger(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.bytes = byArray;
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERInteger)) {
            return false;
        }
        DERInteger dERInteger = (DERInteger)dERObject;
        if (this.bytes.length != dERInteger.bytes.length) {
            return false;
        }
        int n = 0;
        while (n != this.bytes.length) {
            if (this.bytes[n] != dERInteger.bytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(2, this.bytes);
    }

    public static DERInteger getInstance(Object object) {
        if (object == null || object instanceof DERInteger) {
            return (DERInteger)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERInteger(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERInteger.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERInteger getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERInteger.getInstance(aSN1TaggedObject.getObject());
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 != this.bytes.length) {
            n ^= (this.bytes[n2] & 0xFF) << n2 % 4;
            ++n2;
        }
        return n;
    }

    public String toString() {
        return this.getValue().toString();
    }
}

