/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.nist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.util.Strings;

public class NISTNamedCurves {
    static final Hashtable objIds = new Hashtable();
    static final Hashtable names = new Hashtable();

    static {
        NISTNamedCurves.defineCurve("B-571", SECObjectIdentifiers.sect571r1);
        NISTNamedCurves.defineCurve("B-409", SECObjectIdentifiers.sect409r1);
        NISTNamedCurves.defineCurve("B-283", SECObjectIdentifiers.sect283r1);
        NISTNamedCurves.defineCurve("B-233", SECObjectIdentifiers.sect233r1);
        NISTNamedCurves.defineCurve("B-163", SECObjectIdentifiers.sect163r2);
        NISTNamedCurves.defineCurve("P-521", SECObjectIdentifiers.secp521r1);
        NISTNamedCurves.defineCurve("P-256", SECObjectIdentifiers.secp256r1);
        NISTNamedCurves.defineCurve("P-224", SECObjectIdentifiers.secp224r1);
        NISTNamedCurves.defineCurve("P-384", SECObjectIdentifiers.secp384r1);
    }

    static void defineCurve(String string, DERObjectIdentifier dERObjectIdentifier) {
        objIds.put(string, dERObjectIdentifier);
        names.put(dERObjectIdentifier, string);
    }

    public static X9ECParameters getByName(String string) {
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)objIds.get(Strings.toUpperCase(string));
        if (dERObjectIdentifier != null) {
            return NISTNamedCurves.getByOID(dERObjectIdentifier);
        }
        return null;
    }

    public static X9ECParameters getByOID(DERObjectIdentifier dERObjectIdentifier) {
        return SECNamedCurves.getByOID(dERObjectIdentifier);
    }

    public static String getName(DERObjectIdentifier dERObjectIdentifier) {
        return (String)names.get(dERObjectIdentifier);
    }

    public static Enumeration getNames() {
        return objIds.keys();
    }

    public static DERObjectIdentifier getOID(String string) {
        return (DERObjectIdentifier)objIds.get(Strings.toUpperCase(string));
    }
}

