/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509.qualified;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

public class TypeOfBiometricData
extends ASN1Encodable
implements ASN1Choice {
    public static final int PICTURE = 0;
    public static final int HANDWRITTEN_SIGNATURE = 1;
    DEREncodable obj;

    public TypeOfBiometricData(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("unknow PredefinedBiometricType : " + n);
        }
        this.obj = new DERInteger(n);
    }

    public TypeOfBiometricData(DERObjectIdentifier dERObjectIdentifier) {
        this.obj = dERObjectIdentifier;
    }

    public DERObjectIdentifier getBiometricDataOid() {
        return (DERObjectIdentifier)this.obj;
    }

    public static TypeOfBiometricData getInstance(Object object) {
        if (object == null || object instanceof TypeOfBiometricData) {
            return (TypeOfBiometricData)object;
        }
        if (object instanceof DERInteger) {
            DERInteger dERInteger = DERInteger.getInstance(object);
            int n = dERInteger.getValue().intValue();
            return new TypeOfBiometricData(n);
        }
        if (object instanceof DERObjectIdentifier) {
            DERObjectIdentifier dERObjectIdentifier = DERObjectIdentifier.getInstance(object);
            return new TypeOfBiometricData(dERObjectIdentifier);
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public int getPredefinedBiometricType() {
        return ((DERInteger)this.obj).getValue().intValue();
    }

    public boolean isPredefined() {
        return this.obj instanceof DERInteger;
    }

    public DERObject toASN1Object() {
        return this.obj.getDERObject();
    }
}

