/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.jce.MultiCertStoreParameters;
import org.bouncycastle.jce.cert.CRLSelector;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CertStoreSpi;

public class MultiCertStoreSpi
extends CertStoreSpi {
    private MultiCertStoreParameters params;

    public MultiCertStoreSpi(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof MultiCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("org.bouncycastle.jce.provider.MultiCertStoreSpi: parameter must be a MultiCertStoreParameters object\n" + certStoreParameters.toString());
        }
        this.params = (MultiCertStoreParameters)certStoreParameters;
    }

    public Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        boolean bl = this.params.getSearchAllStores();
        Iterator iterator = this.params.getCertStores().iterator();
        List list = bl ? new ArrayList() : Collections.EMPTY_LIST;
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            Collection collection = certStore.getCRLs(cRLSelector);
            if (bl) {
                list.addAll(collection);
                continue;
            }
            if (collection.isEmpty()) continue;
            return collection;
        }
        return list;
    }

    public Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        boolean bl = this.params.getSearchAllStores();
        Iterator iterator = this.params.getCertStores().iterator();
        List list = bl ? new ArrayList() : Collections.EMPTY_LIST;
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            Collection collection = certStore.getCertificates(certSelector);
            if (bl) {
                list.addAll(collection);
                continue;
            }
            if (collection.isEmpty()) continue;
            return collection;
        }
        return list;
    }
}

