/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class OCSPTestUtil {
    public static SecureRandom rand;
    public static KeyPairGenerator kpg;
    public static KeyPairGenerator eckpg;
    public static KeyGenerator desede128kg;
    public static KeyGenerator desede192kg;
    public static KeyGenerator rc240kg;
    public static KeyGenerator rc264kg;
    public static KeyGenerator rc2128kg;
    public static BigInteger serialNumber;
    public static final boolean DEBUG = true;

    static {
        try {
            rand = new SecureRandom();
            kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(1024, rand);
            serialNumber = new BigInteger("1");
            eckpg = KeyPairGenerator.getInstance("ECDSA", "BC");
            eckpg.initialize(192, rand);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    private static BigInteger allocateSerialNumber() {
        BigInteger bigInteger = serialNumber;
        serialNumber = serialNumber.add(BigInteger.ONE);
        return bigInteger;
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo);
    }

    private static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        return new SubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    public static X509Certificate makeCACertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, true);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, false);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2, String string3, boolean bl) throws GeneralSecurityException, IOException {
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair2.getPrivate();
        PublicKey publicKey2 = keyPair2.getPublic();
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.reset();
        x509V3CertificateGenerator.setSerialNumber(OCSPTestUtil.allocateSerialNumber());
        x509V3CertificateGenerator.setIssuerDN(new X509Name(string2));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis()));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 8640000000L));
        x509V3CertificateGenerator.setSubjectDN(new X509Name(string));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSignatureAlgorithm(string3);
        x509V3CertificateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)OCSPTestUtil.createSubjectKeyId(publicKey));
        x509V3CertificateGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)OCSPTestUtil.createAuthorityKeyId(publicKey2));
        x509V3CertificateGenerator.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(bl));
        X509Certificate x509Certificate = x509V3CertificateGenerator.generateX509Certificate(privateKey);
        x509Certificate.checkValidity(new Date());
        x509Certificate.verify(publicKey2);
        return x509Certificate;
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2, boolean bl) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, "MD5withRSA", bl);
    }

    public static X509Certificate makeECDSACertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeECDSACertificate(keyPair, string, keyPair2, string2, false);
    }

    public static X509Certificate makeECDSACertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2, boolean bl) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, "SHA1WithECDSA", bl);
    }

    public static KeyPair makeECKeyPair() {
        return ((KeyPairGeneratorSpi)eckpg).generateKeyPair();
    }

    public static KeyPair makeKeyPair() {
        return ((KeyPairGeneratorSpi)kpg).generateKeyPair();
    }
}

