/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ocsp;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.X509Extensions;

public class Request
implements DEREncodable {
    CertID reqCert;
    X509Extensions singleRequestExtensions;

    public Request(ASN1Sequence aSN1Sequence) {
        this.reqCert = CertID.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() == 2) {
            this.singleRequestExtensions = X509Extensions.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true);
        }
    }

    public CertID getReqCert() {
        return this.reqCert;
    }

    public X509Extensions getSingleRequestExtensions() {
        return this.singleRequestExtensions;
    }

    public DERObject getDERObject() {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add(this.reqCert);
        if (this.singleRequestExtensions != null) {
            dEREncodableVector.add(new DERTaggedObject(true, 0, this.singleRequestExtensions));
        }
        return new DERSequence(dEREncodableVector);
    }
}

