/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        if (!(certPathParameters instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXBuilderParameters instance");
        }
        PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        Object var7_4 = null;
        Object var9_5 = null;
        CertPath certPath = null;
        CertPathValidatorException certPathValidatorException = null;
        try {
            CertSelector certSelector = pKIXBuilderParameters.getTargetCertConstraints();
            if (certSelector == null) {
                throw new CertPathBuilderException("targetCertConstraints must be non-null for CertPath building");
            }
            Collection collection = PKIXCertPathBuilderSpi.findCertificates(certSelector, pKIXBuilderParameters.getCertStores());
            if (collection.isEmpty()) {
                throw new CertPathBuilderException("no certificate found matching targetCertContraints");
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                arrayList.clear();
                while (x509Certificate != null) {
                    arrayList.add(x509Certificate);
                    if (PKIXCertPathBuilderSpi.findTrustAnchor(x509Certificate, pKIXBuilderParameters.getTrustAnchors()) != null) {
                        try {
                            certPath = CertificateFactory.getInstance("X.509", "BC").generateCertPath(arrayList);
                            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX", "BC");
                            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXBuilderParameters);
                            return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
                        }
                        catch (CertPathValidatorException certPathValidatorException2) {
                            certPathValidatorException = certPathValidatorException2;
                            x509Certificate = null;
                            continue;
                        }
                    }
                    try {
                        x509Certificate = PKIXCertPathBuilderSpi.findIssuer(x509Certificate, pKIXBuilderParameters.getCertStores());
                    }
                    catch (CertPathValidatorException certPathValidatorException3) {
                        certPathValidatorException = certPathValidatorException3;
                        x509Certificate = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception thrown while doing CertPath building\n", exception);
        }
        if (certPath != null) {
            throw new CertPathBuilderException("found certifiacte chain, but could not be validated", certPathValidatorException);
        }
        throw new CertPathBuilderException("unable to find certificate chain");
    }

    /*
     * Unable to fully structure code
     */
    static final TrustAnchor findTrustAnchor(X509Certificate var0, Set var1_1) throws CertPathValidatorException {
        var2_2 = var1_1.iterator();
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        var6_6 = new X509CertSelector();
        try {
            var6_6.setSubject(var0.getIssuerX500Principal().getEncoded());
            if (true) ** GOTO lbl40
        }
        catch (IOException var7_7) {
            var7_7.printStackTrace();
            return null;
        }
        do {
            block15: {
                if ((var3_3 = (TrustAnchor)var2_2.next()).getTrustedCert() != null) {
                    if (var6_6.match(var3_3.getTrustedCert())) {
                        var4_4 = var3_3.getTrustedCert().getPublicKey();
                    } else {
                        var3_3 = null;
                    }
                } else if (var3_3.getCAName() != null && var3_3.getCAPublicKey() != null) {
                    try {
                        var7_8 = var0.getIssuerX500Principal();
                        var8_11 = new X500Principal(var3_3.getCAName());
                        if (var7_8.equals(var8_11)) {
                            var4_4 = var3_3.getCAPublicKey();
                            break block15;
                        }
                        var3_3 = null;
                    }
                    catch (IllegalArgumentException var7_9) {
                        var3_3 = null;
                    }
                } else {
                    var3_3 = null;
                }
            }
            if (var4_4 == null) continue;
            try {
                var0.verify(var4_4);
            }
            catch (Exception var7_10) {
                var5_5 = var7_10;
                var3_3 = null;
            }
lbl40:
            // 4 sources

        } while (var2_2.hasNext() && var3_3 == null);
        if (var3_3 == null && var5_5 != null) {
            throw new CertPathValidatorException("TrustAnchor found put certificate validation failed", var5_5, null, -1);
        }
        return var3_3;
    }

    private static final Collection findCertificates(CertSelector certSelector, List list) {
        HashSet<? extends Certificate> hashSet = new HashSet<Certificate>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCertificates(certSelector));
            }
            catch (CertStoreException certStoreException) {
                certStoreException.printStackTrace();
            }
        }
        return hashSet;
    }

    private static final X509Certificate findIssuer(X509Certificate x509Certificate, List list) throws CertPathValidatorException {
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        Iterator iterator = PKIXCertPathBuilderSpi.findCertificates(x509CertSelector, list).iterator();
        X509Certificate x509Certificate2 = null;
        while (iterator.hasNext() && x509Certificate2 == null) {
            x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
            }
            catch (Exception exception2) {
                exception = exception2;
                x509Certificate2 = null;
            }
        }
        if (x509Certificate2 == null && exception != null) {
            throw new CertPathValidatorException("issuer found but certificate validation failed", (Throwable)exception, null, -1);
        }
        return x509Certificate2;
    }
}

