/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.util.test.SimpleTest;

public class InputStreamTest
extends SimpleTest {
    private static final byte[] outOfBoundsLength = new byte[]{48, -1, -1, -1, -1, -1};
    private static final byte[] negativeLength = new byte[]{48, -124, -1, -1, -1, -1};
    private static final byte[] outsideLimitLength = new byte[]{48, -125, 15, -1, -1};

    public String getName() {
        return "InputStream";
    }

    public void performTest() throws Exception {
        block8: {
            ASN1InputStream aSN1InputStream;
            block7: {
                block6: {
                    aSN1InputStream = new ASN1InputStream(outOfBoundsLength);
                    try {
                        aSN1InputStream.readObject();
                        this.fail("out of bounds length not detected.");
                    }
                    catch (IOException iOException) {
                        if (iOException.getMessage().equals("DER length more than 4 bytes")) break block6;
                        this.fail("wrong exception: " + iOException.getMessage());
                    }
                }
                aSN1InputStream = new ASN1InputStream(negativeLength);
                try {
                    aSN1InputStream.readObject();
                    this.fail("negative length not detected.");
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().equals("corrupted steam - negative length found")) break block7;
                    this.fail("wrong exception: " + iOException.getMessage());
                }
            }
            aSN1InputStream = new ASN1InputStream(outsideLimitLength);
            try {
                aSN1InputStream.readObject();
                this.fail("outside limit length not detected.");
            }
            catch (IOException iOException) {
                if (iOException.getMessage().equals("corrupted steam - out of bounds length found")) break block8;
                this.fail("wrong exception: " + iOException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        InputStreamTest.runTest(new InputStreamTest());
    }
}

