/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.SkipjackEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class CTSTest
extends SimpleTest {
    static byte[] in1 = Hex.decode("4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode("9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode("358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode("170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    private void testCTS(int n, BlockCipher blockCipher, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        byte[] byArray3 = new byte[byArray.length];
        CTSBlockCipher cTSBlockCipher = new CTSBlockCipher(blockCipher);
        cTSBlockCipher.init(true, cipherParameters);
        int n2 = ((BufferedBlockCipher)cTSBlockCipher).processBytes(byArray, 0, byArray.length, byArray3, 0);
        ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray3, n2);
        if (!this.areEqual(byArray2, byArray3)) {
            this.fail("failed encryption expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        cTSBlockCipher.init(false, cipherParameters);
        n2 = ((BufferedBlockCipher)cTSBlockCipher).processBytes(byArray2, 0, byArray2.length, byArray3, 0);
        ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray3, n2);
        if (!this.areEqual(byArray, byArray3)) {
            this.fail("failed encryption expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray3)));
        }
    }

    public String getName() {
        return "CTS";
    }

    public void performTest() throws Exception {
        byte[] byArray = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] byArray2 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -18, -1};
        byte[] byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.testCTS(1, new DESEngine(), new KeyParameter(byArray), in1, out1);
        this.testCTS(2, new CBCBlockCipher(new DESEngine()), new ParametersWithIV(new KeyParameter(byArray), byArray3), in1, out2);
        this.testCTS(3, new CBCBlockCipher(new SkipjackEngine()), new ParametersWithIV(new KeyParameter(byArray2), byArray3), in2, out3);
    }

    public static void main(String[] stringArray) {
        CTSTest.runTest(new CTSTest());
    }
}

