/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAValidationParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.SimpleTest;

public class DSATest
extends SimpleTest {
    byte[] k1 = Hex.decode("d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    byte[] k2 = Hex.decode("345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
    SecureRandom random = new FixedSecureRandom(new byte[][]{this.k1, this.k2});
    byte[] keyData = Hex.decode("b5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    SecureRandom keyRandom = new FixedSecureRandom(new byte[][]{this.keyData, this.keyData});
    BigInteger pValue = new BigInteger("8df2a494492276aa3d25759bb06869cbeac0d83afb8d0cf7cbb8324f0d7882e5d0762fc5b7210eafc2e9adac32ab7aac49693dfbf83724c2ec0736ee31c80291", 16);
    BigInteger qValue = new BigInteger("c773218c737ec8ee993b4f2ded30f48edace915f", 16);

    public String getName() {
        return "DSA";
    }

    public void performTest() {
        BigInteger bigInteger = new BigInteger("68076202252361894315274692543577577550894681403");
        BigInteger bigInteger2 = new BigInteger("1089214853334067536215539335472893651470583479365");
        DSAParametersGenerator dSAParametersGenerator = new DSAParametersGenerator();
        dSAParametersGenerator.init(512, 80, this.random);
        DSAParameters dSAParameters = dSAParametersGenerator.generateParameters();
        DSAValidationParameters dSAValidationParameters = dSAParameters.getValidationParameters();
        if (dSAValidationParameters.getCounter() != 105) {
            this.fail("Counter wrong");
        }
        if (!this.pValue.equals(dSAParameters.getP()) || !this.qValue.equals(dSAParameters.getQ())) {
            this.fail("p or q wrong");
        }
        DSAKeyPairGenerator dSAKeyPairGenerator = new DSAKeyPairGenerator();
        DSAKeyGenerationParameters dSAKeyGenerationParameters = new DSAKeyGenerationParameters(this.keyRandom, dSAParameters);
        dSAKeyPairGenerator.init(dSAKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dSAKeyPairGenerator.generateKeyPair();
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.keyRandom);
        DSASigner dSASigner = new DSASigner();
        dSASigner.init(true, parametersWithRandom);
        byte[] byArray = new BigInteger("968236873715988614170569073515315707566766479517").toByteArray();
        BigInteger[] bigIntegerArray = dSASigner.generateSignature(byArray);
        if (!bigInteger.equals(bigIntegerArray[0])) {
            this.fail("r component wrong.", bigInteger, bigIntegerArray[0]);
        }
        if (!bigInteger2.equals(bigIntegerArray[1])) {
            this.fail("s component wrong.", bigInteger2, bigIntegerArray[1]);
        }
        dSASigner.init(false, asymmetricCipherKeyPair.getPublic());
        if (!dSASigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
            this.fail("verification fails");
        }
    }

    public static void main(String[] stringArray) {
        DSATest.runTest(new DSATest());
    }
}

