/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class ECPointTest
extends TestCase {
    public static final String[] CURVES = new String[]{"sect163r2", "sect233r1", "sect283r1", "sect409r1", "sect571r1", "secp224r1", "secp256r1", "secp521r1"};
    private SecureRandom secRand = new SecureRandom();
    private Fp fp = null;
    private F2m f2m = null;

    public void setUp() {
        this.fp = new Fp();
        this.fp.createPoints();
        this.f2m = new F2m();
        this.f2m.createPoints();
    }

    public void testPointCreationConsistency() {
        ECPoint eCPoint;
        try {
            eCPoint = new ECPoint.Fp(this.fp.curve, new ECFieldElement.Fp(this.fp.q, new BigInteger("12")), null);
            ECPointTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            eCPoint = new ECPoint.Fp(this.fp.curve, null, new ECFieldElement.Fp(this.fp.q, new BigInteger("12")));
            ECPointTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            eCPoint = new ECPoint.F2m(this.f2m.curve, new ECFieldElement.F2m(4, 1, new BigInteger("1011")), null);
            ECPointTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            eCPoint = new ECPoint.F2m(this.f2m.curve, null, new ECFieldElement.F2m(4, 1, new BigInteger("1011")));
            ECPointTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void implTestAdd(ECPoint[] eCPointArray, ECPoint eCPoint) {
        ECPointTest.assertEquals((String)"p0 plus p1 does not equal p2", (Object)eCPointArray[2], (Object)eCPointArray[0].add(eCPointArray[1]));
        ECPointTest.assertEquals((String)"p1 plus p0 does not equal p2", (Object)eCPointArray[2], (Object)eCPointArray[1].add(eCPointArray[0]));
        for (int i = 0; i < eCPointArray.length; ++i) {
            ECPointTest.assertEquals((String)"Adding infinity failed", (Object)eCPointArray[i], (Object)eCPointArray[i].add(eCPoint));
            ECPointTest.assertEquals((String)"Adding to infinity failed", (Object)eCPointArray[i], (Object)eCPoint.add(eCPointArray[i]));
        }
    }

    public void testAdd() {
        this.implTestAdd(this.fp.p, this.fp.infinity);
        this.implTestAdd(this.f2m.p, this.f2m.infinity);
    }

    private void implTestTwice(ECPoint[] eCPointArray) {
        ECPointTest.assertEquals((String)"Twice incorrect", (Object)eCPointArray[3], (Object)eCPointArray[0].twice());
        ECPointTest.assertEquals((String)"Add same point incorrect", (Object)eCPointArray[3], (Object)eCPointArray[0].add(eCPointArray[0]));
    }

    public void testTwice() {
        this.implTestTwice(this.fp.p);
        this.implTestTwice(this.f2m.p);
    }

    private void implTestAllPoints(ECPoint eCPoint, ECPoint eCPoint2) {
        ECPoint eCPoint3 = eCPoint2;
        ECPoint eCPoint4 = eCPoint2;
        int n = 1;
        do {
            eCPoint3 = eCPoint3.add(eCPoint);
            eCPoint4 = eCPoint.multiply(new BigInteger(Integer.toString(n)));
            ECPointTest.assertEquals((String)("Results of add() and multiply() are inconsistent " + n), (Object)eCPoint3, (Object)eCPoint4);
            ++n;
        } while (!eCPoint3.equals(eCPoint2));
    }

    public void testAllPoints() {
        int n;
        for (n = 0; n < this.fp.p.length; ++n) {
            this.implTestAllPoints(this.fp.p[0], this.fp.infinity);
        }
        for (n = 0; n < this.f2m.p.length; ++n) {
            this.implTestAllPoints(this.f2m.p[0], this.f2m.infinity);
        }
    }

    private ECPoint multiply(ECPoint eCPoint, BigInteger bigInteger) {
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        int n = bigInteger.bitLength();
        for (int i = 0; i < n; ++i) {
            if (bigInteger.testBit(i)) {
                eCPoint2 = eCPoint2.add(eCPoint);
            }
            eCPoint = eCPoint.twice();
        }
        return eCPoint2;
    }

    private void implTestMultiply(ECPoint eCPoint, int n) {
        BigInteger bigInteger = new BigInteger(n, this.secRand);
        ECPoint eCPoint2 = this.multiply(eCPoint, bigInteger);
        ECPoint eCPoint3 = eCPoint.multiply(bigInteger);
        ECPointTest.assertEquals((String)"ECPoint.multiply is incorrect", (Object)eCPoint2, (Object)eCPoint3);
    }

    private void implTestMultiplyAll(ECPoint eCPoint, int n) {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(n);
        BigInteger bigInteger2 = BigInteger.ZERO;
        do {
            ECPoint eCPoint2 = this.multiply(eCPoint, bigInteger2);
            ECPoint eCPoint3 = eCPoint.multiply(bigInteger2);
            ECPointTest.assertEquals((String)"ECPoint.multiply is incorrect", (Object)eCPoint2, (Object)eCPoint3);
        } while ((bigInteger2 = bigInteger2.add(BigInteger.ONE)).compareTo(bigInteger) < 0);
    }

    private void implTestAddSubtract(ECPoint eCPoint, ECPoint eCPoint2) {
        ECPointTest.assertEquals((String)"Twice and Add inconsistent", (Object)eCPoint.twice(), (Object)eCPoint.add(eCPoint));
        ECPointTest.assertEquals((String)"Twice p - p is not p", (Object)eCPoint, (Object)eCPoint.twice().subtract(eCPoint));
        ECPointTest.assertEquals((String)"p - p is not infinity", (Object)eCPoint2, (Object)eCPoint.subtract(eCPoint));
        ECPointTest.assertEquals((String)"p plus infinity is not p", (Object)eCPoint, (Object)eCPoint.add(eCPoint2));
        ECPointTest.assertEquals((String)"infinity plus p is not p", (Object)eCPoint, (Object)eCPoint2.add(eCPoint));
        ECPointTest.assertEquals((String)"infinity plus infinity is not infinity ", (Object)eCPoint2, (Object)eCPoint2.add(eCPoint2));
    }

    public void testAddSubtractMultiplySimple() {
        int n;
        for (n = 0; n < this.fp.pointSource.length / 2; ++n) {
            this.implTestAddSubtract(this.fp.p[n], this.fp.infinity);
            this.implTestMultiplyAll(this.fp.p[n], 6);
            this.implTestMultiplyAll(this.fp.infinity, 6);
        }
        for (n = 0; n < this.f2m.pointSource.length / 2; ++n) {
            this.implTestAddSubtract(this.f2m.p[n], this.f2m.infinity);
            this.implTestMultiplyAll(this.f2m.p[n], 6);
            this.implTestMultiplyAll(this.f2m.infinity, 6);
        }
    }

    private void implTestEncoding(ECPoint eCPoint) {
        ECPoint eCPoint2;
        ECPoint eCPoint3;
        if (eCPoint instanceof ECPoint.Fp) {
            eCPoint3 = new ECPoint.Fp(eCPoint.getCurve(), eCPoint.getX(), eCPoint.getY(), false);
            eCPoint2 = new ECPoint.Fp(eCPoint.getCurve(), eCPoint.getX(), eCPoint.getY(), true);
        } else {
            eCPoint3 = new ECPoint.F2m(eCPoint.getCurve(), eCPoint.getX(), eCPoint.getY(), false);
            eCPoint2 = new ECPoint.F2m(eCPoint.getCurve(), eCPoint.getX(), eCPoint.getY(), true);
        }
        byte[] byArray = eCPoint3.getEncoded();
        ECPoint eCPoint4 = eCPoint.getCurve().decodePoint(byArray);
        ECPointTest.assertEquals((String)"Error decoding uncompressed point", (Object)eCPoint, (Object)eCPoint4);
        byte[] byArray2 = eCPoint2.getEncoded();
        ECPoint eCPoint5 = eCPoint.getCurve().decodePoint(byArray2);
        ECPointTest.assertEquals((String)"Error decoding compressed point", (Object)eCPoint, (Object)eCPoint5);
    }

    public void testAddSubtractMultiplyTwiceEncoding() {
        for (int i = 0; i < CURVES.length; ++i) {
            X9ECParameters x9ECParameters = SECNamedCurves.getByName(CURVES[i]);
            BigInteger bigInteger = x9ECParameters.getN();
            BigInteger bigInteger2 = new BigInteger(bigInteger.bitLength(), this.secRand);
            ECPoint eCPoint = x9ECParameters.getG();
            ECPoint eCPoint2 = eCPoint.multiply(bigInteger2);
            ECPoint eCPoint3 = x9ECParameters.getCurve().getInfinity();
            this.implTestAddSubtract(eCPoint2, eCPoint3);
            this.implTestMultiply(eCPoint2, bigInteger.bitLength());
            this.implTestMultiply(eCPoint3, bigInteger.bitLength());
            this.implTestEncoding(eCPoint2);
        }
    }

    public static Test suite() {
        return new TestSuite(ECPointTest.class);
    }

    public static class F2m {
        private final int m = 4;
        private final int k1 = 1;
        private final ECFieldElement.F2m aTpb = new ECFieldElement.F2m(4, 1, new BigInteger("1000", 2));
        private final ECFieldElement.F2m bTpb = new ECFieldElement.F2m(4, 1, new BigInteger("1001", 2));
        private final ECCurve.F2m curve = new ECCurve.F2m(4, 1, this.aTpb.toBigInteger(), this.bTpb.toBigInteger());
        private final ECPoint.F2m infinity = (ECPoint.F2m)this.curve.getInfinity();
        private final String[] pointSource = new String[]{"0010", "1111", "1100", "1100", "0001", "0001", "1011", "0010"};
        private ECPoint.F2m[] p = new ECPoint.F2m[this.pointSource.length / 2];

        private void createPoints() {
            for (int i = 0; i < this.pointSource.length / 2; ++i) {
                ECFieldElement.F2m f2m = new ECFieldElement.F2m(4, 1, new BigInteger(this.pointSource[2 * i], 2));
                ECFieldElement.F2m f2m2 = new ECFieldElement.F2m(4, 1, new BigInteger(this.pointSource[2 * i + 1], 2));
                this.p[i] = new ECPoint.F2m(this.curve, f2m, f2m2);
            }
        }
    }

    public static class Fp {
        private final BigInteger q = new BigInteger("29");
        private final BigInteger a = new BigInteger("4");
        private final BigInteger b = new BigInteger("20");
        private final ECCurve.Fp curve = new ECCurve.Fp(this.q, this.a, this.b);
        private final ECPoint.Fp infinity = (ECPoint.Fp)this.curve.getInfinity();
        private final int[] pointSource = new int[]{5, 22, 16, 27, 13, 6, 14, 6};
        private ECPoint.Fp[] p = new ECPoint.Fp[this.pointSource.length / 2];

        private void createPoints() {
            for (int i = 0; i < this.pointSource.length / 2; ++i) {
                ECFieldElement.Fp fp = new ECFieldElement.Fp(this.q, new BigInteger(Integer.toString(this.pointSource[2 * i])));
                ECFieldElement.Fp fp2 = new ECFieldElement.Fp(this.q, new BigInteger(Integer.toString(this.pointSource[2 * i + 1])));
                this.p[i] = new ECPoint.Fp(this.curve, fp, fp2);
            }
        }
    }
}

