/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.util.Random;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.icao.DataGroupHash;
import org.bouncycastle.asn1.icao.LDSSecurityObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.test.SimpleTest;

public class LDSSecurityObjectUnitTest
extends SimpleTest {
    public String getName() {
        return "LDSSecurityObject";
    }

    private byte[] generateHash() {
        Random random = new Random();
        byte[] byArray = new byte[20];
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = (byte)random.nextInt();
        }
        return byArray;
    }

    public void performTest() throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier("1.3.14.3.2.26");
        DataGroupHash[] dataGroupHashArray = new DataGroupHash[]{new DataGroupHash(1, new DEROctetString(this.generateHash())), new DataGroupHash(2, new DEROctetString(this.generateHash()))};
        LDSSecurityObject lDSSecurityObject = new LDSSecurityObject(algorithmIdentifier, dataGroupHashArray);
        this.checkConstruction(lDSSecurityObject, algorithmIdentifier, dataGroupHashArray);
        lDSSecurityObject = LDSSecurityObject.getInstance(null);
        if (lDSSecurityObject != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            LDSSecurityObject.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            new LDSSecurityObject(new DERSequence(aSN1EncodableVector));
            this.fail("constructor failed to detect empty sequence.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new LDSSecurityObject(algorithmIdentifier, new DataGroupHash[1]);
            this.fail("constructor failed to detect small DataGroupHash array.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new LDSSecurityObject(algorithmIdentifier, new DataGroupHash[17]);
            this.fail("constructor failed to out of bounds DataGroupHash array.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(LDSSecurityObject lDSSecurityObject, AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray) throws IOException {
        this.checkStatement(lDSSecurityObject, algorithmIdentifier, dataGroupHashArray);
        lDSSecurityObject = LDSSecurityObject.getInstance(lDSSecurityObject);
        this.checkStatement(lDSSecurityObject, algorithmIdentifier, dataGroupHashArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(lDSSecurityObject.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        lDSSecurityObject = LDSSecurityObject.getInstance(aSN1Sequence);
        this.checkStatement(lDSSecurityObject, algorithmIdentifier, dataGroupHashArray);
    }

    private void checkStatement(LDSSecurityObject lDSSecurityObject, AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray) {
        if (algorithmIdentifier != null) {
            if (!lDSSecurityObject.getDigestAlgorithmIdentifier().equals(algorithmIdentifier)) {
                this.fail("ids don't match.");
            }
        } else if (lDSSecurityObject.getDigestAlgorithmIdentifier() != null) {
            this.fail("digest algorithm Id found when none expected.");
        }
        if (dataGroupHashArray != null) {
            DataGroupHash[] dataGroupHashArray2 = lDSSecurityObject.getDatagroupHash();
            for (int i = 0; i != dataGroupHashArray2.length; ++i) {
                if (dataGroupHashArray[i].equals(dataGroupHashArray2[i])) continue;
                this.fail("name registration authorities don't match.");
            }
        } else if (lDSSecurityObject.getDatagroupHash() != null) {
            this.fail("data hash groups found when none expected.");
        }
    }

    public static void main(String[] stringArray) {
        LDSSecurityObjectUnitTest.runTest(new LDSSecurityObjectUnitTest());
    }
}

