/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SetTest
implements Test {
    public String getName() {
        return "Set";
    }

    public TestResult perform() {
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            byte[] byArray = new byte[10];
            aSN1EncodableVector.add(new DEROctetString(byArray));
            aSN1EncodableVector.add(new DERBitString(byArray));
            aSN1EncodableVector.add(new DERInteger(100));
            aSN1EncodableVector.add(new DERBoolean(true));
            ASN1Set aSN1Set = new DERSet(aSN1EncodableVector);
            if (!(aSN1Set.getObjectAt(0) instanceof DERBoolean)) {
                return new SimpleTestResult(false, this.getName() + ": sorting failed.");
            }
            aSN1Set = new BERSet(aSN1EncodableVector);
            if (!(aSN1Set.getObjectAt(0) instanceof DEROctetString)) {
                return new SimpleTestResult(false, this.getName() + ": BER set sort order changed.");
            }
            DERTaggedObject dERTaggedObject = new DERTaggedObject(false, 1, new DERSequence(aSN1EncodableVector));
            aSN1Set = ASN1Set.getInstance(dERTaggedObject, false);
            if (aSN1Set.getObjectAt(0) instanceof DERBoolean) {
                return new SimpleTestResult(false, this.getName() + ": sorted when shouldn't be.");
            }
            aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new DERBoolean(true));
            aSN1EncodableVector.add(new DERBoolean(true));
            aSN1EncodableVector.add(new DERBoolean(true));
            aSN1Set = new DERSet(aSN1EncodableVector);
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Exception - " + exception.toString(), exception);
        }
    }

    public static void main(String[] stringArray) {
        SetTest setTest = new SetTest();
        TestResult testResult = setTest.perform();
        System.out.println(testResult);
    }
}

