/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class AESVectorFileTest
implements Test {
    private int countOfTests = 0;
    private int testNum = 0;
    private static final String[] zipFileNames = new String[]{"rijn.tv.ecbnk.zip", "rijn.tv.ecbnt.zip", "rijn.tv.ecbvk.zip", "rijn.tv.ecbvt.zip"};

    protected BlockCipher createNewEngineForTest() {
        return new AESEngine();
    }

    private Test[] readTestVectors(InputStream inputStream) {
        ArrayList<BlockCipherVectorTest> arrayList = new ArrayList<BlockCipherVectorTest>();
        String string = null;
        String string2 = null;
        String string3 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                int n;
                if ((string4 = string4.trim().toLowerCase()).startsWith("blocksize=")) {
                    n = 0;
                    try {
                        n = Integer.parseInt(string4.substring(10).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n != 128) {
                        return null;
                    }
                } else if (string4.startsWith("keysize=")) {
                    n = 0;
                    try {
                        n = Integer.parseInt(string4.substring(10).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n != 128 && n != 192 && n != 256) {
                        return null;
                    }
                } else if (string4.startsWith("key=")) {
                    string = string4.substring(4).trim();
                } else if (string4.startsWith("pt=")) {
                    string2 = string4.substring(3).trim();
                } else if (string4.startsWith("ct=")) {
                    string3 = string4.substring(3).trim();
                } else if (string4.startsWith("test=") && string != null && string2 != null && string3 != null) {
                    arrayList.add(new BlockCipherVectorTest(this.testNum++, this.createNewEngineForTest(), new KeyParameter(Hex.decode(string)), string2, string3));
                }
                string4 = bufferedReader.readLine();
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string != null && string2 != null && string3 != null) {
            arrayList.add(new BlockCipherVectorTest(this.testNum++, this.createNewEngineForTest(), new KeyParameter(Hex.decode(string)), string2, string3));
        }
        return arrayList.toArray(new Test[arrayList.size()]);
    }

    public String getName() {
        return "AES";
    }

    private TestResult performTestsFromZipFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Test[] testArray = null;
                try {
                    testArray = this.readTestVectors(zipFile.getInputStream(enumeration.nextElement()));
                }
                catch (Exception exception) {
                    return new SimpleTestResult(false, this.getName() + ": threw " + exception);
                }
                if (testArray == null) continue;
                for (int i = 0; i != testArray.length; ++i) {
                    TestResult testResult = testArray[i].perform();
                    ++this.countOfTests;
                    if (testResult.isSuccessful()) continue;
                    return testResult;
                }
            }
            zipFile.close();
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": threw " + exception);
        }
    }

    public TestResult perform() {
        this.countOfTests = 0;
        for (int i = 0; i < zipFileNames.length; ++i) {
            File file = new File(zipFileNames[i]);
            TestResult testResult = this.performTestsFromZipFile(file);
            if (testResult.isSuccessful()) continue;
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": " + this.countOfTests + " performed Okay");
    }

    public static void main(String[] stringArray) {
        AESVectorFileTest aESVectorFileTest = new AESVectorFileTest();
        TestResult testResult = aESVectorFileTest.perform();
        System.out.println(testResult);
        aESVectorFileTest = new AESLightVectorFileTest();
        testResult = aESVectorFileTest.perform();
        System.out.println(testResult);
        aESVectorFileTest = new AESFastVectorFileTest();
        testResult = aESVectorFileTest.perform();
        System.out.println(testResult);
    }

    private static class AESFastVectorFileTest
    extends AESVectorFileTest {
        private AESFastVectorFileTest() {
        }

        protected BlockCipher createNewEngineForTest() {
            return new AESFastEngine();
        }

        public String getName() {
            return "AESFast";
        }
    }

    private static class AESLightVectorFileTest
    extends AESVectorFileTest {
        private AESLightVectorFileTest() {
        }

        protected BlockCipher createNewEngineForTest() {
            return new AESLightEngine();
        }

        public String getName() {
            return "AESLight";
        }
    }
}

