/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.macs.ISO9797Alg3Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ISO9797Alg3MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode("7CA110454A1A6E570131D9619DC1376E");
    static byte[] ivBytes = Hex.decode("0000000000000000");
    static byte[] input1 = "Hello World !!!!".getBytes();
    static byte[] output1 = Hex.decode("F09B856213BAB83B");

    public void performTest() {
        KeyParameter keyParameter = new KeyParameter(keyBytes);
        DESEngine dESEngine = new DESEngine();
        ISO9797Alg3Mac iSO9797Alg3Mac = new ISO9797Alg3Mac(dESEngine);
        iSO9797Alg3Mac.init(keyParameter);
        iSO9797Alg3Mac.update(input1, 0, input1.length);
        byte[] byArray = new byte[8];
        iSO9797Alg3Mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(byArray)));
        }
        iSO9797Alg3Mac.reset();
        iSO9797Alg3Mac.init(keyParameter);
        for (int i = 0; i != input1.length / 2; ++i) {
            iSO9797Alg3Mac.update(input1[i]);
        }
        iSO9797Alg3Mac.update(input1, input1.length / 2, input1.length - input1.length / 2);
        iSO9797Alg3Mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output1)) {
            this.fail("Reset failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(byArray)));
        }
    }

    public String getName() {
        return "ISO9797Alg3Mac";
    }

    public static void main(String[] stringArray) {
        ISO9797Alg3MacTest.runTest(new ISO9797Alg3MacTest());
    }
}

