/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.engines.NullEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class NullTest
extends CipherTest {
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, new NullEngine(), new KeyParameter(Hex.decode("00")), "00", "00")};

    NullTest() {
        super(tests);
    }

    public String getName() {
        return "Null";
    }

    public void performTest() throws Exception {
        super.performTest();
        NullEngine nullEngine = new NullEngine();
        nullEngine.init(true, null);
        byte[] byArray = new byte[1];
        nullEngine.processBlock(byArray, 0, byArray, 0);
        if (byArray[0] != 0) {
            this.fail("NullCipher changed data!");
        }
        byte[] byArray2 = new byte[]{};
        try {
            nullEngine.processBlock(byArray2, 0, byArray, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        try {
            nullEngine.processBlock(byArray, 0, byArray2, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        NullTest.runTest(new NullTest());
    }
}

